/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public interface PhaseInterface
extends ThermodynamicConstantsInterface,
Cloneable {
    public void addcomponent(String var1, double var2, double var4, int var6);

    public void setMoleFractions(double[] var1);

    public double getPhaseFraction();

    public double[] getComposition(String var1);

    public double getCp0();

    public double getDensity_AGA8();

    public double getJouleThomsonCoefficient();

    public double getJouleThomsonCoefficient(String var1);

    public double[] getMolarComposition();

    public void resetPhysicalProperties();

    public double getVolume();

    public double getVolume(String var1);

    public double getGamma();

    default public double getGamma2() {
        return this.getCp() / (this.getCp() - 8.3144621 * this.getNumberOfMolesInPhase());
    }

    public ComponentInterface getComponentWithIndex(int var1);

    public double getWtFractionOfWaxFormingComponents();

    public double getdrhodN();

    public void setInitType(int var1);

    public void init(double var1, int var3, int var4, int var5, double var6);

    public void init();

    public void initPhysicalProperties();

    public void initPhysicalProperties(String var1);

    public double getdrhodP();

    public double getdrhodT();

    public double getEnthalpydP();

    public double getEnthalpydT();

    public double getEntropydP();

    public double getEntropydT();

    public double getMoleFraction();

    public ComponentInterface[] getcomponentArray();

    public double getMass();

    public double getWtFraction(SystemInterface var1);

    public double getMolarVolume();

    public double getFlowRate(String var1);

    public void setComponentArray(ComponentInterface[] var1);

    public double getDensity_GERG2008();

    public double[] getProperties_GERG2008();

    public double getDensity();

    public double getDensity(String var1);

    public void removeComponent(String var1, double var2, double var4, int var6);

    public double getFugacity(int var1);

    public double getFugacity(String var1);

    public double getTotalVolume();

    public double getCorrectedVolume();

    public boolean hasTBPFraction();

    public double getMolalMeanIonicActivity(int var1, int var2);

    public double getMixGibbsEnergy();

    public boolean hasPlusFraction();

    public double getExessGibbsEnergy();

    public double getSresTP();

    public void setPhaseType(int var1);

    public void setBeta(double var1);

    public void setProperties(PhaseInterface var1);

    public void useVolumeCorrection(boolean var1);

    public boolean useVolumeCorrection();

    public double getBeta();

    public double getWtFrac(int var1);

    public double getWtFrac(String var1);

    public void setMixingRuleGEModel(String var1);

    public ComponentInterface getComponent(String var1);

    public ComponentInterface getComponent(int var1);

    public double getActivityCoefficient(int var1);

    public double getActivityCoefficient(int var1, int var2);

    public void setPressure(double var1);

    public double getpH();

    public void normalize();

    public double getLogPureComponentFugacity(int var1);

    public double getPureComponentFugacity(int var1);

    public double getPureComponentFugacity(int var1, boolean var2);

    public void addMolesChemReac(int var1, double var2);

    public void addMolesChemReac(int var1, double var2, double var4);

    public void setEmptyFluid();

    public void setPhysicalProperties();

    public void setPhysicalProperties(int var1);

    public int getInitType();

    public void setAttractiveTerm(int var1);

    public void resetMixingRule(int var1);

    public void setTemperature(double var1);

    public PhysicalPropertiesInterface getPhysicalProperties();

    public double molarVolume(double var1, double var3, double var5, double var7, int var9) throws IsNaNException, TooManyIterationsException;

    public double geta(PhaseInterface var1, double var2, double var4, int var6);

    public double getb(PhaseInterface var1, double var2, double var4, int var6);

    public double getAntoineVaporPressure(double var1);

    public double calcA(PhaseInterface var1, double var2, double var4, int var6);

    public double calcB(PhaseInterface var1, double var2, double var4, int var6);

    public double calcAi(int var1, PhaseInterface var2, double var3, double var5, int var7);

    public double calcAiT(int var1, PhaseInterface var2, double var3, double var5, int var7);

    public double calcAij(int var1, int var2, PhaseInterface var3, double var4, double var6, int var8);

    public double calcBij(int var1, int var2, PhaseInterface var3, double var4, double var6, int var8);

    public double calcAT(int var1, PhaseInterface var2, double var3, double var5, int var7);

    public double calcBi(int var1, PhaseInterface var2, double var3, double var5, int var7);

    public double calcR();

    public double getg();

    public void addMoles(int var1, double var2);

    public double getEnthalpy();

    public double getEnthalpy(String var1);

    public double getEntropy();

    public double getEntropy(String var1);

    public double getViscosity();

    public double getViscosity(String var1);

    @Deprecated
    public double getConductivity();

    @Deprecated
    public double getConductivity(String var1);

    public double getThermalConductivity();

    public double getThermalConductivity(String var1);

    public double getCp();

    public double getCp(String var1);

    public double getHresTP();

    public double getGresTP();

    public double getCv();

    public double getCv(String var1);

    public double getKappa();

    public double getCpres();

    public double getZ();

    public double getPseudoCriticalPressure();

    public double getPseudoCriticalTemperature();

    public PhaseInterface getPhase();

    public int getNumberOfComponents();

    public void setNumberOfComponents(int var1);

    public void setMixingRule(int var1);

    public ComponentInterface[] getComponents();

    public double getNumberOfMolesInPhase();

    public int getPhaseType();

    public void calcMolarVolume(boolean var1);

    public void setTotalVolume(double var1);

    public void setMolarVolume(double var1);

    public double getInfiniteDiluteFugacity(int var1, int var2);

    public double getHelmholtzEnergy();

    public int getNumberOfMolecularComponents();

    public int getNumberOfIonicComponents();

    public double getA();

    public double getB();

    public double getAT();

    public double getATT();

    public double getGibbsEnergy();

    public PhaseInterface clone();

    public double getTemperature();

    public double getPressure();

    public double getPressure(String var1);

    public double getMolarMass();

    public double getInternalEnergy();

    public double getdPdrho();

    public double getdPdTVn();

    public double getdPdVTn();

    public double Fn();

    public double FT();

    public double FV();

    public double FD();

    public double FB();

    public double gb();

    public double fb();

    public double gV();

    public double fv();

    public double FnV();

    public double FnB();

    public double FTT();

    public double FBT();

    public double FDT();

    public double FBV();

    public double FBB();

    public double FDV();

    public double FBD();

    public double FTV();

    public double FVV();

    public double gVV();

    public double gBV();

    public double gBB();

    public double fVV();

    public double fBV();

    public double fBB();

    public double dFdT();

    public double dFdV();

    public double dFdTdV();

    public double dFdVdV();

    public double dFdTdT();

    public double getOsmoticCoefficientOfWater();

    public double getOsmoticCoefficient(int var1);

    public double getMeanIonicActivity(int var1, int var2);

    public double getLogInfiniteDiluteFugacity(int var1, int var2);

    public double getLogInfiniteDiluteFugacity(int var1);

    public int getMixingRuleNumber();

    public void initRefPhases(boolean var1);

    public PhaseInterface getRefPhase(int var1);

    public PhaseInterface[] getRefPhase();

    public void setRefPhase(int var1, PhaseInterface var2);

    public void setRefPhase(PhaseInterface[] var1);

    public int getPhysicalPropertyType();

    public void setPhysicalPropertyType(int var1);

    public void setParams(PhaseInterface var1, double[][] var2, double[][] var3, double[][] var4, String[][] var5, double[][] var6);

    public String getPhaseTypeName();

    public void setPhaseTypeName(String var1);

    public boolean isMixingRuleDefined();

    public void setMixingRuleDefined(boolean var1);

    public double getActivityCoefficientSymetric(int var1);

    public double getActivityCoefficientUnSymetric(int var1);

    public double getExessGibbsEnergySymetric();

    public boolean hasComponent(String var1);

    public double getLogActivityCoefficient(int var1, int var2);

    public boolean isConstantPhaseVolume();

    public void setConstantPhaseVolume(boolean var1);

    public double getSoundSpeed();
}

