/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentCPAInterface;
import neqsim.thermo.component.ComponentElectrolyteCPA;
import neqsim.thermo.mixingRule.CPAMixing;
import neqsim.thermo.mixingRule.CPAMixingInterface;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhaseModifiedFurstElectrolyteEos;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.simple.SimpleMatrix;

public class PhaseElectrolyteCPA
extends PhaseModifiedFurstElectrolyteEos
implements PhaseCPAInterface {
    private static final long serialVersionUID = 1000L;
    public CPAMixing cpaSelect = new CPAMixing();
    public CPAMixingInterface cpamix;
    double gcpavv = 0.0;
    double gcpavvv = 0.0;
    double gcpa = 0.0;
    double hcpatot = 1.0;
    double FCPA = 0.0;
    double dFCPAdTdV;
    double dFCPAdTdT = 0.0;
    double dFCPAdT = 0.0;
    double dFCPAdV = 0.0;
    double dFCPAdVdV = 0.0;
    double dFCPAdVdVdV = 0.0;
    private double gcpav = 0.0;
    int cpaon = 1;
    int oldTotalNumberOfAccociationSites = 0;
    private int totalNumberOfAccociationSites = 0;
    int[][][] selfAccociationScheme = null;
    int[][][][] crossAccociationScheme = null;
    int[] moleculeNumber = null;
    int[] assSiteNumber = null;
    private double[][] gvector = null;
    private double[][] delta = null;
    private double[][] deltaNog = null;
    private double[][] deltadT = null;
    private double[][] deltadTdT = null;
    private double[][][] Klkni = null;
    private SimpleMatrix KlkTVMatrix = null;
    private SimpleMatrix KlkTTMatrix = null;
    private SimpleMatrix KlkTMatrix = null;
    private SimpleMatrix udotTimesmMatrix = null;
    private SimpleMatrix mVector = null;
    private SimpleMatrix udotMatrix = null;
    private SimpleMatrix uMatrix = null;
    private SimpleMatrix QMatksiksiksi = null;
    private SimpleMatrix KlkVVVMatrix = null;
    private SimpleMatrix KlkVVMatrix = null;
    private SimpleMatrix udotTimesmiMatrix = null;
    private SimpleMatrix ksiMatrix = null;
    private SimpleMatrix KlkMatrix = null;
    private SimpleMatrix hessianMatrix = null;
    private SimpleMatrix hessianInvers = null;
    private SimpleMatrix KlkVMatrix = null;
    DMatrixRMaj corr2Matrix = null;
    DMatrixRMaj corr3Matrix = null;
    DMatrixRMaj corr4Matrix = null;
    static Logger logger = LogManager.getLogger(PhaseElectrolyteCPA.class);

    @Override
    public PhaseElectrolyteCPA clone() {
        PhaseElectrolyteCPA clonedPhase = null;
        try {
            clonedPhase = (PhaseElectrolyteCPA)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.cpamix = this.cpaSelect.getMixingRule(1, this);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        if (type == 0) {
            this.setTotalNumberOfAccociationSites(0);
            this.selfAccociationScheme = new int[numberOfComponents][0][0];
            this.crossAccociationScheme = new int[numberOfComponents][numberOfComponents][0][0];
            int i = 0;
            while (i < numberOfComponents) {
                if (this.getComponent(i).getNumberOfmoles() < 1.0E-100) {
                    this.getComponent(i).setNumberOfAssociationSites(0);
                } else {
                    this.getComponent(i).setNumberOfAssociationSites(this.getComponent(i).getOrginalNumberOfAssociationSites());
                    this.setTotalNumberOfAccociationSites(this.getTotalNumberOfAccociationSites() + this.getComponent(i).getNumberOfAssociationSites());
                    this.selfAccociationScheme[i] = this.cpaSelect.setAssociationScheme(i, this);
                    int j = 0;
                    while (j < numberOfComponents) {
                        this.crossAccociationScheme[i][j] = this.cpaSelect.setCrossAssociationScheme(i, j, this);
                        ++j;
                    }
                }
                ++i;
            }
            if (this.getTotalNumberOfAccociationSites() != this.oldTotalNumberOfAccociationSites) {
                this.mVector = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.KlkMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkVVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkVVVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.hessianMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkTMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkTTMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkTVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.corr2Matrix = new DMatrixRMaj(this.getTotalNumberOfAccociationSites(), 1);
                this.corr3Matrix = new DMatrixRMaj(this.getTotalNumberOfAccociationSites(), 1);
                this.corr4Matrix = new DMatrixRMaj(this.getTotalNumberOfAccociationSites(), 1);
                this.Klkni = new double[numberOfComponents][this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
                this.ksiMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.uMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.udotMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.moleculeNumber = new int[this.getTotalNumberOfAccociationSites()];
                this.assSiteNumber = new int[this.getTotalNumberOfAccociationSites()];
                this.gvector = new double[this.getTotalNumberOfAccociationSites()][1];
                this.udotTimesmMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.udotTimesmiMatrix = new SimpleMatrix(this.getNumberOfComponents(), this.getTotalNumberOfAccociationSites());
                this.delta = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
                this.deltaNog = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
                this.deltadT = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
                this.deltadTdT = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
                this.QMatksiksiksi = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
            }
            this.oldTotalNumberOfAccociationSites = this.getTotalNumberOfAccociationSites();
            int temp = 0;
            int i2 = 0;
            while (i2 < numberOfComponents) {
                int j = 0;
                while (j < this.getComponent(i2).getNumberOfAssociationSites()) {
                    this.moleculeNumber[temp + j] = i2;
                    this.assSiteNumber[temp + j] = j;
                    ++j;
                }
                temp += this.getComponent(i2).getNumberOfAssociationSites();
                ++i2;
            }
        }
        if (this.cpamix == null) {
            this.cpamix = this.cpaSelect.getMixingRule(1, this);
        }
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        if (type > 0 && this.isConstantPhaseVolume()) {
            this.volInit();
            this.calcDelta();
            this.solveX();
            super.init(totalNumberOfMoles, numberOfComponents, 1, phase, beta);
            this.gcpa = this.calc_g();
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
        }
        if (type > 0) {
            this.hcpatot = this.calc_hCPA();
        }
        if (type > 1) {
            this.volInit();
            this.initCPAMatrix(type);
        }
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
    }

    public void calcDelta() {
        int i = 0;
        while (i < this.totalNumberOfAccociationSites) {
            int j = i;
            while (j < this.totalNumberOfAccociationSites) {
                this.deltaNog[i][j] = this.cpamix.calcDeltaNog(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                this.deltaNog[j][i] = this.delta[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void initCPAMatrix(int type) {
        int j;
        if (this.getTotalNumberOfAccociationSites() == 0) {
            this.FCPA = 0.0;
            this.dFCPAdTdV = 0.0;
            this.dFCPAdTdT = 0.0;
            this.dFCPAdT = 0.0;
            this.dFCPAdV = 0.0;
            this.dFCPAdVdV = 0.0;
            this.dFCPAdVdVdV = 0.0;
            return;
        }
        int temp = 0;
        int i = 0;
        while (i < this.numberOfComponents) {
            j = 0;
            while (j < this.getComponent(i).getNumberOfAssociationSites()) {
                this.uMatrix.set(temp + j, 0, Math.log(this.ksiMatrix.get(temp + j, 0)) - this.ksiMatrix.get(temp + j, 0) + 1.0);
                this.gvector[temp + j][0] = this.mVector.get(temp + j, 0) * this.udotMatrix.get(temp + j, 0);
                ++j;
            }
            temp += this.getComponent(i).getNumberOfAssociationSites();
            ++i;
        }
        i = 0;
        while (i < this.getNumberOfComponents()) {
            j = 0;
            while (j < this.getTotalNumberOfAccociationSites()) {
                if (this.moleculeNumber[j] == i) {
                    this.udotTimesmiMatrix.set(i, j, this.udotMatrix.get(j, 0));
                } else {
                    this.udotTimesmiMatrix.set(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.getTotalNumberOfAccociationSites()) {
            j = i;
            while (j < this.getTotalNumberOfAccociationSites()) {
                this.delta[i][j] = this.deltaNog[i][j] * this.getGcpa();
                this.delta[j][i] = this.delta[i][j];
                if (type > 1) {
                    this.deltadT[i][j] = this.cpamix.calcDeltadT(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                    this.deltadT[j][i] = this.deltadT[i][j];
                    this.deltadTdT[i][j] = this.cpamix.calcDeltadTdT(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                    this.deltadTdT[j][i] = this.deltadTdT[i][j];
                }
                ++j;
            }
            ++i;
        }
        double gdv1 = this.getGcpav() - 1.0 / this.getTotalVolume();
        double gdv2 = gdv1 * gdv1;
        double gdv3 = gdv2 * gdv1;
        double totVol = this.getTotalVolume();
        int i2 = 0;
        while (i2 < this.getTotalNumberOfAccociationSites()) {
            int j2 = i2;
            while (j2 < this.getTotalNumberOfAccociationSites()) {
                this.KlkVMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * gdv1);
                this.KlkVMatrix.set(j2, i2, this.KlkVMatrix.get(i2, j2));
                this.KlkVVMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * gdv2 + this.KlkMatrix.get(i2, j2) * (this.gcpavv + 1.0 / this.getTotalVolume() / this.getTotalVolume()));
                this.KlkVVMatrix.set(j2, i2, this.KlkVVMatrix.get(i2, j2));
                this.KlkVVVMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * gdv3 + 3.0 * this.KlkMatrix.get(i2, j2) * (this.getGcpav() - 1.0 / this.getTotalVolume()) * (this.gcpavv + 1.0 / (totVol * totVol)) + this.KlkMatrix.get(i2, j2) * (this.gcpavvv - 2.0 / (totVol * totVol * totVol)));
                this.KlkVVVMatrix.set(j2, i2, this.KlkVVVMatrix.get(i2, j2));
                if (type > 1) {
                    double tempVar = this.deltadT[i2][j2] / this.delta[i2][j2];
                    double tempVardT = this.deltadTdT[i2][j2] / this.delta[i2][j2] - this.deltadT[i2][j2] * this.deltadT[i2][j2] / (this.delta[i2][j2] * this.delta[i2][j2]);
                    if (!Double.isNaN(tempVar)) {
                        this.KlkTMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * tempVar);
                        this.KlkTMatrix.set(j2, i2, this.KlkTMatrix.get(i2, j2));
                        this.KlkTVMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * tempVar * (this.gcpav - 1.0 / this.getTotalVolume()));
                        this.KlkTVMatrix.set(j2, i2, this.KlkTVMatrix.get(i2, j2));
                        this.KlkTTMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * (tempVar * tempVar + tempVardT));
                        this.KlkTTMatrix.set(j2, i2, this.KlkTTMatrix.get(i2, j2));
                    }
                    if (type > 2) {
                        int p = 0;
                        while (p < this.numberOfComponents) {
                            double t1 = 0.0;
                            double t2 = 0.0;
                            if (this.moleculeNumber[i2] == p) {
                                t1 = 1.0 / this.mVector.get(i2, 0);
                            }
                            if (this.moleculeNumber[j2] == p) {
                                t2 = 1.0 / this.mVector.get(j2, 0);
                            }
                            this.Klkni[p][i2][j2] = this.KlkMatrix.get(i2, j2) * (t1 + t2 + ((ComponentElectrolyteCPA)this.getComponent(p)).calc_lngi(this));
                            this.Klkni[p][j2][i2] = this.Klkni[p][i2][j2];
                            ++p;
                        }
                    }
                }
                ++j2;
            }
            this.QMatksiksiksi.set(i2, 0, 2.0 * this.mVector.get(i2, 0) / (this.ksiMatrix.get(i2, 0) * this.ksiMatrix.get(i2, 0) * this.ksiMatrix.get(i2, 0)));
            ++i2;
        }
        SimpleMatrix ksiMatrixTranspose = (SimpleMatrix)this.ksiMatrix.transpose();
        SimpleMatrix KlkVMatrixksi = this.KlkVMatrix.mult(this.ksiMatrix);
        SimpleMatrix XV = this.hessianInvers.mult(KlkVMatrixksi);
        SimpleMatrix XVtranspose = (SimpleMatrix)XV.transpose();
        SimpleMatrix QCPA = ((SimpleMatrix)this.mVector.transpose()).mult(this.uMatrix.minus((SimpleMatrix)this.ksiMatrix.elementMult(this.udotMatrix).scale(0.5)));
        this.FCPA = QCPA.get(0, 0);
        SimpleMatrix tempMatrix = (SimpleMatrix)ksiMatrixTranspose.mult(KlkVMatrixksi).scale(-0.5);
        this.dFCPAdV = tempMatrix.get(0, 0);
        SimpleMatrix KlkVVMatrixTImesKsi = this.KlkVVMatrix.mult(this.ksiMatrix);
        SimpleMatrix tempMatrixVV = ((SimpleMatrix)ksiMatrixTranspose.mult(KlkVVMatrixTImesKsi).scale(-0.5)).minus(((SimpleMatrix)KlkVMatrixksi.transpose()).mult(XV));
        this.dFCPAdVdV = tempMatrixVV.get(0, 0);
        SimpleMatrix QVVV = (SimpleMatrix)ksiMatrixTranspose.mult(this.KlkVVVMatrix.mult(this.ksiMatrix)).scale(-0.5);
        SimpleMatrix QVVksi = (SimpleMatrix)KlkVVMatrixTImesKsi.scale(-1.0);
        SimpleMatrix QksiVksi = (SimpleMatrix)this.KlkVMatrix.scale(-1.0);
        SimpleMatrix mat1 = (SimpleMatrix)((SimpleMatrix)QVVksi.transpose()).mult(XV).scale(3.0);
        SimpleMatrix mat2 = (SimpleMatrix)XVtranspose.mult(QksiVksi.mult(XV)).scale(3.0);
        SimpleMatrix mat4 = XVtranspose.mult(this.QMatksiksiksi.mult(XVtranspose)).mult(XV);
        SimpleMatrix dFCPAdVdVdVMatrix = QVVV.plus(mat1).plus(mat2).plus(mat2).plus(mat4);
        this.dFCPAdVdVdV = dFCPAdVdVdVMatrix.get(0, 0);
        temp = 0;
        if (type == 1) {
            return;
        }
        int p = 0;
        while (p < this.numberOfComponents) {
            int kk = 0;
            while (kk < this.getComponent(p).getNumberOfAssociationSites()) {
                ((ComponentCPAInterface)this.getComponent(p)).setXsitedV(kk, XV.get(temp + kk, 0));
                ++kk;
            }
            temp += this.getComponent(p).getNumberOfAssociationSites();
            ++p;
        }
        SimpleMatrix KlkTMatrixTImesKsi = this.KlkTMatrix.mult(this.ksiMatrix);
        SimpleMatrix tempMatrix2 = (SimpleMatrix)ksiMatrixTranspose.mult(KlkTMatrixTImesKsi).scale(-0.5);
        this.dFCPAdT = tempMatrix2.get(0, 0);
        SimpleMatrix XT = this.hessianInvers.mult(KlkTMatrixTImesKsi);
        SimpleMatrix tempMatrixTT = ((SimpleMatrix)ksiMatrixTranspose.mult(this.KlkTTMatrix.mult(this.ksiMatrix)).scale(-0.5)).minus(((SimpleMatrix)KlkTMatrixTImesKsi.transpose()).mult(XT));
        this.dFCPAdTdT = tempMatrixTT.get(0, 0);
        SimpleMatrix tempMatrixTV = ((SimpleMatrix)ksiMatrixTranspose.mult(this.KlkTVMatrix.mult(this.ksiMatrix)).scale(-0.5)).minus(((SimpleMatrix)KlkTMatrixTImesKsi.transpose()).mult(XV));
        this.dFCPAdTdV = tempMatrixTV.get(0, 0);
        temp = 0;
        int p2 = 0;
        while (p2 < this.numberOfComponents) {
            int kk = 0;
            while (kk < this.getComponent(p2).getNumberOfAssociationSites()) {
                ((ComponentCPAInterface)this.getComponent(p2)).setXsitedT(kk, XT.get(temp + kk, 0));
                ++kk;
            }
            temp += this.getComponent(p2).getNumberOfAssociationSites();
            ++p2;
        }
        if (type == 2) {
            return;
        }
        p2 = 0;
        while (p2 < this.numberOfComponents) {
            SimpleMatrix KiMatrix = new SimpleMatrix(this.Klkni[p2]);
            SimpleMatrix tempMatrix4 = KiMatrix.mult(this.ksiMatrix);
            SimpleMatrix tempMatrix5 = ((SimpleMatrix)((SimpleMatrix)this.udotTimesmiMatrix.extractVector(true, p2)).transpose()).minus(tempMatrix4);
            SimpleMatrix tempMatrix6 = this.hessianInvers.mult(tempMatrix5);
            int temp2 = 0;
            int compp = 0;
            while (compp < this.numberOfComponents) {
                int kk = 0;
                while (kk < this.getComponent(compp).getNumberOfAssociationSites()) {
                    ((ComponentCPAInterface)this.getComponent(compp)).setXsitedni(kk, p2, -1.0 * tempMatrix6.get(temp2 + kk, 0));
                    ++kk;
                }
                temp2 += this.getComponent(compp).getNumberOfAssociationSites();
                ++compp;
            }
            ++p2;
        }
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(componentName, moles, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentElectrolyteCPA(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public double getF() {
        return super.getF() + (double)this.cpaon * this.FCPA();
    }

    @Override
    public double dFdT() {
        return super.dFdT() + (double)this.cpaon * this.dFCPAdT();
    }

    @Override
    public double dFdTdV() {
        return super.dFdTdV() + (double)this.cpaon * this.dFCPAdTdV();
    }

    @Override
    public double dFdV() {
        double dv2 = this.dFCPAdV();
        return super.dFdV() + (double)this.cpaon * dv2;
    }

    @Override
    public double dFdVdV() {
        return super.dFdVdV() + (double)this.cpaon * this.dFCPAdVdV();
    }

    @Override
    public double dFdVdVdV() {
        return super.dFdVdVdV() + (double)this.cpaon * this.dFCPAdVdVdV();
    }

    @Override
    public double dFdTdT() {
        return super.dFdTdT() + (double)this.cpaon * this.dFCPAdTdT();
    }

    public double FCPA() {
        return this.FCPA;
    }

    public double dFCPAdV() {
        return this.dFCPAdV;
    }

    public double dFCPAdVdV() {
        return this.dFCPAdVdV;
    }

    public double dFCPAdVdVdV() {
        return this.dFCPAdVdVdV;
    }

    public double dFCPAdT() {
        return this.dFCPAdT;
    }

    public double dFCPAdTdT() {
        return this.dFCPAdTdT;
    }

    public double dFCPAdTdV() {
        return this.dFCPAdTdV;
    }

    public double calc_hCPA() {
        double htot = 0.0;
        double tot = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            htot = 0.0;
            int j = 0;
            while (j < this.getComponent(i).getNumberOfAssociationSites()) {
                htot += 1.0 - ((ComponentCPAInterface)this.getComponent(i)).getXsite()[j];
                ++j;
            }
            tot += this.getComponent(i).getNumberOfMolesInPhase() * htot;
            ++i;
        }
        return tot;
    }

    public void calcXsitedV() {
        if (this.totalNumberOfAccociationSites > 0) {
            this.initCPAMatrix(1);
        }
    }

    public boolean solveX() {
        if (this.getTotalNumberOfAccociationSites() == 0) {
            return true;
        }
        boolean solvedX = this.solveX2(5);
        DMatrixRMaj mat1 = (DMatrixRMaj)this.KlkMatrix.getMatrix();
        DMatrixRMaj mat2 = (DMatrixRMaj)this.ksiMatrix.getMatrix();
        int temp = 0;
        int iter = 0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.getComponent(i).getNumberOfAssociationSites()) {
                this.mVector.set(temp + j, 0, this.getComponent(i).getNumberOfMolesInPhase());
                ++j;
            }
            temp += this.getComponent(i).getNumberOfAssociationSites();
            ++i;
        }
        double Klk = 0.0;
        double totvolume = this.getTotalVolume();
        int i2 = 0;
        while (i2 < this.getTotalNumberOfAccociationSites()) {
            int j = i2;
            while (j < this.getTotalNumberOfAccociationSites()) {
                Klk = this.mVector.get(i2, 0) * this.mVector.get(j, 0) / totvolume * this.delta[i2][j];
                this.KlkMatrix.set(i2, j, Klk);
                this.KlkMatrix.set(j, i2, Klk);
                ++j;
            }
            ++i2;
        }
        boolean solved = true;
        do {
            int j;
            solved = true;
            ++iter;
            temp = 0;
            int i3 = 0;
            while (i3 < this.numberOfComponents) {
                j = 0;
                while (j < this.getComponent(i3).getNumberOfAssociationSites()) {
                    this.ksiMatrix.set(temp + j, 0, ((ComponentCPAInterface)this.getComponent(i3)).getXsite()[j]);
                    this.udotMatrix.set(temp + j, 0, 1.0 / this.ksiMatrix.get(temp + j, 0) - 1.0);
                    this.udotTimesmMatrix.set(temp + j, 0, this.mVector.get(temp + j, 0) * this.udotMatrix.get(temp + j, 0));
                    ++j;
                }
                temp += this.getComponent(i3).getNumberOfAssociationSites();
                ++i3;
            }
            i3 = 0;
            while (i3 < this.getTotalNumberOfAccociationSites()) {
                j = i3;
                while (j < this.getTotalNumberOfAccociationSites()) {
                    boolean krondelt = false;
                    if (i3 == j) {
                        krondelt = true;
                    }
                    this.hessianMatrix.set(i3, j, -this.mVector.get(i3, 0) / (this.ksiMatrix.get(i3, 0) * this.ksiMatrix.get(i3, 0)) * (double)krondelt - this.KlkMatrix.get(i3, j));
                    this.hessianMatrix.set(j, i3, this.hessianMatrix.get(i3, j));
                    ++j;
                }
                ++i3;
            }
            try {
                this.hessianInvers = (SimpleMatrix)this.hessianMatrix.invert();
            }
            catch (Exception ex) {
                logger.error("error", (Throwable)ex);
                return false;
            }
            CommonOps_DDRM.mult(mat1, mat2, this.corr2Matrix);
            CommonOps_DDRM.subtract(this.udotTimesmMatrix.getDDRM(), this.corr2Matrix, this.corr3Matrix);
            CommonOps_DDRM.mult(this.hessianInvers.getDDRM(), this.corr3Matrix, this.corr4Matrix);
            temp = 0;
            i3 = 0;
            while (i3 < this.numberOfComponents) {
                j = 0;
                while (j < this.getComponent(i3).getNumberOfAssociationSites()) {
                    double newX = this.ksiMatrix.get(temp + j, 0) - this.corr4Matrix.unsafe_get(temp + j, 0);
                    if (newX < 0.0) {
                        newX = 1.0E-10;
                        solved = false;
                    }
                    ((ComponentCPAInterface)this.getComponent(i3)).setXsite(j, newX);
                    ++j;
                }
                temp += this.getComponent(i3).getNumberOfAssociationSites();
                ++i3;
            }
        } while ((NormOps_DDRM.normF(this.corr4Matrix) > 1.0E-12 || !solved) && iter < 100);
        return true;
    }

    public boolean solveX2(int maxIter) {
        double err = 0.0;
        int iter = 0;
        double old = 0.0;
        double neeval = 0.0;
        do {
            ++iter;
            err = 0.0;
            int i = 0;
            while (i < this.getTotalNumberOfAccociationSites()) {
                old = ((ComponentCPAInterface)this.getComponent(this.moleculeNumber[i])).getXsite()[this.assSiteNumber[i]];
                neeval = 0.0;
                int j = 0;
                while (j < this.getTotalNumberOfAccociationSites()) {
                    neeval += this.getComponent(this.moleculeNumber[j]).getNumberOfMolesInPhase() * this.delta[i][j] * ((ComponentCPAInterface)this.getComponent(this.moleculeNumber[j])).getXsite()[this.assSiteNumber[j]];
                    ++j;
                }
                neeval = 1.0 / (1.0 + 1.0 / this.getTotalVolume() * neeval);
                ((ComponentCPAInterface)this.getComponent(this.moleculeNumber[i])).setXsite(this.assSiteNumber[i], neeval);
                err += Math.abs((old - neeval) / neeval);
                ++i;
            }
        } while (Math.abs(err) > 1.0E-10 && iter < maxIter);
        return false;
    }

    @Override
    public double getHcpatot() {
        return this.hcpatot;
    }

    public void setHcpatot(double hcpatot) {
        this.hcpatot = hcpatot;
    }

    @Override
    public double getGcpa() {
        return this.gcpa;
    }

    public double calcRootVolFinder(int phase) {
        double BonV;
        double solvedBonVHigh = 0.0;
        double solvedBonVlow = 1.0;
        double oldh = 1.0;
        double BonVold = BonV = 0.9999999999;
        double Btemp = 0.0;
        double h = 1.0;
        Btemp = this.getB();
        this.getA();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int i = 0;
        while (i < 2000) {
            BonVold = BonV;
            BonV = 1.0 - ((double)i + 1.0E-6) * 1.0 / 2000.0;
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = this.pressure * this.getMolarVolume() / (8.3144621 * this.temperature);
            this.gcpa = this.calc_g();
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            this.volInit();
            while (!this.solveX()) {
            }
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - this.pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * this.temperature);
            if (Math.signum(h) * Math.signum(oldh) < 0.0 && i > 2) {
                if (solvedBonVlow < 0.001) {
                    solvedBonVlow = (BonV + BonVold) / 2.0;
                    if (phase == 1) {
                        break;
                    }
                } else {
                    solvedBonVHigh = (BonV + BonVold) / 2.0;
                    if (phase == 0) break;
                }
            }
            solvedBonVHigh = (BonV + BonVold) / 2.0;
            oldh = h;
            ++i;
        }
        if (solvedBonVlow < 0.001) {
            solvedBonVlow = solvedBonVHigh;
        }
        if (phase == 1) {
            return solvedBonVlow;
        }
        return solvedBonVHigh;
    }

    @Override
    public double molarVolume2(double pressure, double temperature, double A, double B, int phasetype) throws IsNaNException, TooManyIterationsException {
        double BonV;
        double d = BonV = phasetype == 0 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 1.0E-8;
        }
        if (BonV > 1.1) {
            BonV = 1.1;
        }
        double BonVold = BonV;
        double Btemp = 0.0;
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.calcDelta();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        do {
            this.volInit();
            ++iterations;
            this.gcpa = this.calc_g();
            if (this.gcpa < 0.0) {
                this.setMolarVolume(1.0 / Btemp / this.numberOfMolesInPhase);
                this.gcpa = this.calc_g();
            }
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            this.solveX();
            this.hcpatot = this.calc_hCPA();
            this.initCPAMatrix(1);
            this.volInit();
            double BonV2 = BonV * BonV;
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / BonV2 * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / (BonV2 * BonV) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Btemp * Btemp / (BonV2 * BonV2) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += 0.5 * d1;
            } else if (d1 > d2) {
                BonV += d2;
                double hnew = h + d2 * dh;
                if (Math.abs(hnew) > Math.abs(h)) {
                    BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            } else {
                BonV += 0.5 * d1;
            }
            if (Math.abs((BonV - BonVold) / BonVold) > 0.1) {
                BonV = BonVold + 0.1 * (BonV - BonVold);
            }
            if (BonV > 1.1) {
                if (iterations < 3) {
                    BonV = (BonVold + BonV) / 2.0;
                } else {
                    double d3 = BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            }
            if (BonV < 0.0) {
                BonV = iterations < 3 ? Math.abs(BonVold + BonV) / 2.0 : (phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621));
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((BonV - BonVold) / BonV) > 1.0E-10 && iterations < 100);
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolume2", "Molar volume");
        }
        return this.getMolarVolume();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phasetype) throws IsNaNException, TooManyIterationsException {
        double BonVold;
        double BonV;
        double d = BonV = phasetype == 0 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV <= 0.0) {
            BonV = 1.0E-8;
        } else if (BonV >= 1.0) {
            BonV = 0.9999;
        }
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.calcDelta();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        do {
            ++iterations;
            this.volInit();
            this.gcpa = this.calc_g();
            if (this.gcpa < 0.0) {
                this.setMolarVolume(1.0 / Btemp / this.numberOfMolesInPhase);
                this.gcpa = this.calc_g();
            }
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            if (this.getTotalNumberOfAccociationSites() > 0) {
                this.solveX();
            }
            this.initCPAMatrix(1);
            double BonV2 = BonV * BonV;
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / BonV2 * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / (BonV2 * BonV) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Btemp * Btemp / (BonV2 * BonV2) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += 0.5 * d1;
            } else if (d1 > d2) {
                BonV += d2;
                double hnew = h + d2 * dh;
                if (Math.abs(hnew) > Math.abs(h)) {
                    BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            } else {
                BonV += 0.5 * d1;
            }
            if (Math.abs((BonV - BonVold) / BonVold) > 0.1) {
                BonV = BonVold + 0.1 * (BonV - BonVold);
            }
            if (BonV > 0.9999) {
                if (iterations >= 3) return this.molarVolumeChangePhase(pressure, temperature, A, B, phasetype);
                BonV = (BonVold + BonV) / 2.0;
            } else if (BonV < 0.0) {
                if (iterations >= 3) return this.molarVolumeChangePhase(pressure, temperature, A, B, phasetype);
                BonV = Math.abs(BonVold + BonV) / 2.0;
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while ((Math.abs((BonV - BonVold) / BonV) > 1.0E-10 || Math.abs(h) > 1.0E-9) && iterations < 100);
        if (Math.abs(h) > 1.0E-9) {
            return this.molarVolumeChangePhase(pressure, temperature, A, B, phasetype);
        }
        if (!Double.isNaN(this.getMolarVolume())) return this.getMolarVolume();
        throw new IsNaNException(this, "molarVolume", "Molar volume");
    }

    public double molarVolumeChangePhase(double pressure, double temperature, double A, double B, int phasetype) throws IsNaNException, TooManyIterationsException {
        double BonV = this.calcRootVolFinder(phasetype);
        if (BonV < 0.0) {
            BonV = 1.0E-8;
        }
        if (BonV >= 1.0) {
            BonV = 0.9999;
        }
        double BonVold = BonV;
        double Btemp = 0.0;
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.calcDelta();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        do {
            this.volInit();
            ++iterations;
            this.gcpa = this.calc_g();
            if (this.gcpa < 0.0) {
                this.setMolarVolume(1.0 / Btemp / this.numberOfMolesInPhase);
                this.gcpa = this.calc_g();
            }
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            this.solveX();
            this.initCPAMatrix(1);
            double BonV2 = BonV * BonV;
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / BonV2 * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / (BonV2 * BonV) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Btemp * Btemp / (BonV2 * BonV2) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += 0.5 * d1;
            } else if (d1 > d2) {
                BonV += d2;
                double hnew = h + d2 * dh;
                if (Math.abs(hnew) > Math.abs(h)) {
                    BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            } else {
                BonV += 0.5 * d1;
            }
            if (Math.abs((BonV - BonVold) / BonVold) > 0.1) {
                BonV = BonVold + 0.1 * (BonV - BonVold);
            }
            if (BonV > 1.1) {
                if (iterations < 3) {
                    BonV = (BonVold + BonV) / 2.0;
                } else {
                    double d = BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            }
            if (BonV < 0.0) {
                BonV = iterations < 3 ? Math.abs(BonVold + BonV) / 2.0 : (phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621));
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((BonV - BonVold) / BonV) > 1.0E-10 && iterations < 100);
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolumeChangePhase", "Molar volume");
        }
        return this.getMolarVolume();
    }

    @Override
    public double getGcpav() {
        return this.gcpav;
    }

    public void setGcpav(double gcpav) {
        this.gcpav = gcpav;
    }

    @Override
    public CPAMixingInterface getCpamix() {
        return this.cpamix;
    }

    @Override
    public double calcPressure() {
        this.gcpa = this.calc_g();
        this.setGcpav(this.calc_lngV());
        this.gcpavv = this.calc_lngVV();
        this.gcpavvv = this.calc_lngVVV();
        this.solveX();
        this.hcpatot = this.calc_hCPA();
        this.initCPAMatrix(1);
        return super.calcPressure();
    }

    @Override
    public int getCrossAssosiationScheme(int comp1, int comp2, int site1, int site2) {
        if (comp1 == comp2) {
            return this.selfAccociationScheme[comp1][site1][site2];
        }
        return this.crossAccociationScheme[comp1][comp2][site1][site2];
    }

    public double[][] croeneckerProduct(double[][] a, double[][] b) {
        int aLength = a.length;
        int aCols = a[0].length;
        int bLength = b.length;
        int bCols = b[0].length;
        double[][] result = new double[aLength * bLength][aCols * bCols];
        int z = 0;
        while (z < aLength) {
            int i = 0;
            while (i < aCols) {
                int j = 0;
                while (j < bLength) {
                    int k = 0;
                    while (k < bCols) {
                        result[j + z * bLength][k + i * bCols] = a[z][i] * b[j][k];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++z;
        }
        return result;
    }

    @Override
    public int getTotalNumberOfAccociationSites() {
        return this.totalNumberOfAccociationSites;
    }

    @Override
    public void setTotalNumberOfAccociationSites(int totalNumberOfAccociationSites) {
        this.totalNumberOfAccociationSites = totalNumberOfAccociationSites;
    }

    public double calc_g() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double g = 1.0 / (1.0 - x);
        return g;
    }

    public double calc_lngV() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double gv = x / this.getTotalVolume() / (1.0 - x);
        return -gv;
    }

    public double calc_lngVV() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double xV = -0.475 * this.getB() / (this.getTotalVolume() * this.getTotalVolume());
        double u = 1.0 - x;
        double val = -x / (this.getTotalVolume() * this.getTotalVolume() * u) + xV / (this.getTotalVolume() * u) - x / (this.getTotalVolume() * u * u) * -1.0 * xV;
        return -val;
    }

    public double calc_lngVVV() {
        double totVol = this.getTotalVolume();
        double totVol4 = totVol * totVol * totVol * totVol;
        double totVol5 = totVol4 * totVol;
        double temp1 = 1.0 - 0.475 * this.getB() / this.getTotalVolume();
        double gvv = -0.21434375 / (temp1 * temp1 * temp1) * this.getB() * this.getB() * this.getB() / (totVol5 * totVol) - 1.35375 / (temp1 * temp1) * this.getB() * this.getB() / totVol5 - 2.85 / temp1 * this.getB() / totVol4;
        return gvv;
    }
}

