/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveEosTerm;

import neqsim.MathLib.nonLinearSolver.newtonRhapson;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermBaseClass;

public class AttractiveTermPr
extends AttractiveTermBaseClass {
    private static final long serialVersionUID = 1000L;

    public AttractiveTermPr(ComponentEosInterface component) {
        super(component);
        this.m = 0.37464 + 1.54226 * component.getAcentricFactor() - 0.26992 * component.getAcentricFactor() * component.getAcentricFactor();
    }

    @Override
    public AttractiveTermPr clone() {
        AttractiveTermPr attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermPr)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public void setm(double val) {
        this.m = val;
        newtonRhapson solve = new newtonRhapson();
        solve.setOrder(2);
        double[] acentricConstants = new double[]{-0.26992, 1.54226, 0.37464 - this.m};
        solve.setConstants(acentricConstants);
        this.getComponent().setAcentricFactor(solve.solve(0.2));
    }

    @Override
    public void init() {
        this.m = 0.37464 + 1.54226 * this.getComponent().getAcentricFactor() - 0.26992 * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor();
    }

    @Override
    public double alpha(double temperature) {
        double temp = 1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC()));
        return temp * temp;
    }

    @Override
    public double aT(double temperature) {
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        return -(1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC()))) * this.m / Math.sqrt(temperature / this.getComponent().getTC()) / this.getComponent().getTC();
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        double tr = temperature / this.getComponent().getTC();
        return this.m * this.m / temperature / this.getComponent().getTC() / 2.0 + (1.0 + this.m * (1.0 - Math.sqrt(tr))) * this.m / Math.sqrt(tr * tr * tr) / (this.getComponent().getTC() * this.getComponent().getTC()) / 2.0;
    }

    @Override
    public double diffaT(double temperature) {
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

