/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.ComponentPR;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhasePrEosvolcor;

public class ComponentPRvolcor
extends ComponentPR {
    private static final long serialVersionUID = 1000L;
    private double c;
    public double[] Cij = new double[100];
    public double Ci = 0.0;

    public ComponentPRvolcor(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    public double calcc() {
        return (0.1154 - 0.4406 * (0.29056 - 0.08775 * this.getAcentricFactor())) * 8.3144621 * this.criticalTemperature / this.criticalPressure;
    }

    public double calccT() {
        return 0.0;
    }

    public double calccTT() {
        return 0.0;
    }

    public ComponentPRvolcor(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.c = (0.1154 - 0.4406 * (0.29056 - 0.08775 * this.getAcentricFactor())) * 8.3144621 * this.criticalTemperature / this.criticalPressure;
    }

    @Override
    public void init(double temp, double pres, double totMoles, double beta, int type) {
        super.init(temp, pres, totMoles, beta, type);
        this.c = this.calcc();
    }

    public double getc() {
        return this.c;
    }

    public double getcT() {
        return 0.0;
    }

    @Override
    public void Finit(PhaseInterface phase, double temp, double pres, double totMoles, double beta, int numberOfComponents, int type) {
        super.Finit(phase, temp, pres, totMoles, beta, numberOfComponents, type);
        this.Ci = ((PhasePrEosvolcor)phase).calcCi(this.componentNumber, phase, temp, pres, numberOfComponents);
        if (type >= 2) {
            ((PhasePrEosvolcor)phase).calcCiT(this.componentNumber, phase, temp, pres, numberOfComponents);
        }
        if (type >= 3) {
            int j = 0;
            while (j < numberOfComponents) {
                this.Cij[j] = ((PhasePrEosvolcor)phase).calcCij(this.componentNumber, j, phase, temp, pres, numberOfComponents);
                ++j;
            }
        }
    }

    public double getCi() {
        return this.Ci;
    }

    public double getCij(int j) {
        return this.Cij[j];
    }

    public double getCiT() {
        return 0.0;
    }

    public double getcTT() {
        return 0.0;
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return phase.Fn() + phase.FB() * this.getBi() + phase.FD() * this.getAi() + ((PhasePrEosvolcor)phase).FC() * this.getCi();
    }

    public double getFC(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhasePrEosvolcor)phase).FC();
    }

    @Override
    public double dFdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double loc_CT = ((PhasePrEosvolcor)phase).getCT();
        double loc_FnC = ((PhasePrEosvolcor)phase).FnC();
        double loc_FBC = ((PhasePrEosvolcor)phase).FBC();
        double loc_FCD = ((PhasePrEosvolcor)phase).FCD();
        double loc_FC = ((PhasePrEosvolcor)phase).FC();
        double loc_FCT = ((PhasePrEosvolcor)phase).FTC();
        double loc_FCC = ((PhasePrEosvolcor)phase).FCC();
        return loc_FnC * loc_CT + (phase.FBT() + phase.FBD() * phase.getAT() + loc_FBC * loc_CT) * this.getBi() + (loc_FCD * loc_CT + phase.FDT()) * this.getAi() + (loc_FCT + loc_FCC * loc_CT + loc_FCD * phase.getAT()) * this.getCi() + phase.FD() * this.getAiT() + loc_FC * this.getCiT();
    }

    @Override
    public double dFdNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double loc_FnC = ((PhasePrEosvolcor)phase).FnC();
        double loc_FBC = ((PhasePrEosvolcor)phase).FBC();
        double loc_FCD = ((PhasePrEosvolcor)phase).FCD();
        double loc_FC = ((PhasePrEosvolcor)phase).FC();
        double loc_FCC = ((PhasePrEosvolcor)phase).FCC();
        ComponentEosInterface[] comp_Array = (ComponentEosInterface[])phase.getcomponentArray();
        double loc_Cj = ((ComponentPRvolcor)comp_Array[j]).getCi();
        return phase.FnB() * comp_Array[j].getBi() + loc_FnC * loc_Cj + (phase.FnB() + phase.FBB() * comp_Array[j].getBi() + loc_FBC * loc_Cj + phase.FBD() * comp_Array[j].getAi()) * this.getBi() + phase.FB() * this.getBij(j) + (loc_FnC + loc_FCC * loc_Cj + loc_FBC * comp_Array[j].getBi() + loc_FCD * comp_Array[j].getAi()) * this.getCi() + loc_FC * this.getCij(j) + (loc_FCD * loc_Cj + phase.FBD() * comp_Array[j].getBi()) * this.getAi() + phase.FD() * this.getAij(j);
    }

    @Override
    public double dFdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double loc_FCV = ((PhasePrEosvolcor)phase).FCV();
        return phase.FnV() + phase.FBV() * this.getBi() + phase.FDV() * this.getAi() + loc_FCV * this.getCi();
    }
}

