/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentHydrate;
import neqsim.thermo.phase.PhaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentHydrateStatoil
extends ComponentHydrate {
    private static final long serialVersionUID = 1000L;
    double[][] coordNumb = new double[2][2];
    double[][] cavRadius = new double[2][2];
    double[][] cavNumb = new double[2][2];
    double[][] cavprwat = new double[2][2];
    static Logger logger = LogManager.getLogger(ComponentHydrateStatoil.class);

    public ComponentHydrateStatoil(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.coordNumb[0][0] = 20.0;
        this.coordNumb[0][1] = 24.0;
        this.cavRadius[0][0] = 3.95;
        this.cavRadius[0][1] = 4.33;
        this.cavNumb[0][0] = 2.0;
        this.cavNumb[0][1] = 6.0;
        this.cavprwat[0][0] = 0.043478260869565216;
        this.cavprwat[0][1] = 0.13043478260869565;
        this.coordNumb[1][0] = 20.0;
        this.coordNumb[1][1] = 28.0;
        this.cavRadius[1][0] = 3.91;
        this.cavRadius[1][1] = 4.73;
        this.cavNumb[1][0] = 16.0;
        this.cavNumb[1][1] = 8.0;
        this.cavprwat[1][0] = 0.11764705882352941;
        this.cavprwat[1][1] = 0.058823529411764705;
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        return this.fugcoef(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure());
    }

    @Override
    public double fugcoef(PhaseInterface phase, int numberOfComps, double temp, double pres) {
        if (this.componentName.equals("water")) {
            double solvol = this.getMolarVolumeHydrate(this.hydrateStructure, temp);
            if (this.hydrateStructure == -1) {
                this.fugacityCoefficient = this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp) * Math.exp(solvol / (8.3144621 * temp) * (pres - this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp)) * 100000.0) / pres;
            } else {
                double val = 0.0;
                double tempy = 1.0;
                int cavType = 0;
                while (cavType < 2) {
                    tempy = 0.0;
                    int j = 0;
                    while (j < phase.getNumberOfComponents()) {
                        double tee = ((ComponentHydrate)phase.getComponent(j)).calcYKI(this.hydrateStructure, cavType, phase);
                        tempy += tee;
                        ++j;
                    }
                    val += this.cavprwat[this.hydrateStructure][cavType] * Math.log(1.0 - tempy);
                    ++cavType;
                }
                this.fugacityCoefficient = Math.exp(val) * this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp) * Math.exp(solvol / (8.3144621 * temp) * (pres - this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp)) * 100000.0) / pres;
            }
        } else {
            this.fugacityCoefficient = 1.0E50;
        }
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        return this.fugacityCoefficient;
    }

    @Override
    public double calcYKI(int stucture, int cavityType, PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            return 0.0;
        }
        double yki = this.calcCKI(stucture, cavityType, phase) * this.reffug[this.componentNumber] * 100000.0;
        double temp = 1.0;
        int i = 0;
        while (i < phase.getNumberOfComponents()) {
            if (phase.getComponent(i).isHydrateFormer()) {
                temp += ((ComponentHydrate)phase.getComponent(i)).calcCKI(stucture, cavityType, phase) * 100000.0 * this.reffug[i];
            }
            ++i;
        }
        return yki / temp;
    }

    @Override
    public double calcCKI(int stucture, int cavityType, PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            return 0.0;
        }
        double cki = 12.5663706 / (phase.getTemperature() * 8.3144621) * this.potIntegral(stucture, cavityType, phase) * 6.023E23;
        return cki / 1.0E30;
    }

    @Override
    public double potIntegral(int stucture, int cavityType, PhaseInterface phase) {
        double step;
        double val = 0.0;
        int numberOfSteps = 200;
        double endval = this.cavRadius[stucture][cavityType] - this.getSphericalCoreRadiusHydrate();
        double x = 0.0;
        x = step = endval / (double)numberOfSteps;
        int i = 1;
        while (i < numberOfSteps) {
            val += step * ((this.getPot(x, stucture, cavityType, phase) + 4.0 * this.getPot(x + 0.5 * step, stucture, cavityType, phase) + this.getPot(x + step, stucture, cavityType, phase)) / 6.0);
            x = (double)i * step;
            ++i;
        }
        if (Double.isNaN(val)) {
            logger.error("val NaN ...");
        }
        if (Double.isInfinite(val)) {
            logger.error("val Infinite ...");
        }
        return val;
    }

    @Override
    public double getPot(double radius, int struccture, int cavityType, PhaseInterface phase) {
        double pot = 2.0 * this.coordNumb[struccture][cavityType] * this.getLennardJonesEnergyParameterHydrate() * (Math.pow(this.getLennardJonesMolecularDiameterHydrate(), 12.0) / (Math.pow(this.cavRadius[struccture][cavityType], 11.0) * radius) * (this.delt(10.0, radius, struccture, cavityType) + this.getSphericalCoreRadiusHydrate() / this.cavRadius[struccture][cavityType] * this.delt(11.0, radius, struccture, cavityType)) - Math.pow(this.getLennardJonesMolecularDiameterHydrate(), 6.0) / (Math.pow(this.cavRadius[struccture][cavityType], 5.0) * radius) * (this.delt(4.0, radius, struccture, cavityType) + this.getSphericalCoreRadiusHydrate() / this.cavRadius[struccture][cavityType] * this.delt(5.0, radius, struccture, cavityType)));
        if (Double.isNaN(pot = Math.exp(-pot / phase.getTemperature()) * radius * radius)) {
            logger.error("pot NaN ...");
        }
        if (Double.isInfinite(pot)) {
            logger.error("pot Infinite ...");
        }
        return pot;
    }

    public double delt(double n, double radius, int struccture, int cavityType) {
        double diff1 = (radius + this.getSphericalCoreRadiusHydrate()) / this.cavRadius[struccture][cavityType];
        double diff2 = (radius - this.getSphericalCoreRadiusHydrate()) / this.cavRadius[struccture][cavityType];
        double delt = 1.0 / n * (Math.pow(1.0 - diff1, -n) - Math.pow(1.0 + diff2, -n));
        if (Double.isNaN(delt)) {
            logger.error("delt NaN ...");
        }
        if (Double.isInfinite(delt)) {
            logger.error("delt Infinite ...");
        }
        return delt;
    }
}

