/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentHydrate;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentHydratePVTsim
extends ComponentHydrate {
    private static final long serialVersionUID = 1000L;
    double[][] Ak = new double[2][2];
    double[][] Bk = new double[2][2];
    static Logger logger = LogManager.getLogger(ComponentHydratePVTsim.class);

    public ComponentHydratePVTsim(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = null;
        if (!component_name.equals("default")) {
            try {
                try {
                    logger.info("reading hydrate parameters ..............");
                    try {
                        dataSet = NeqSimDataBase.createTemporaryTables() ? database.getResultSet("SELECT * FROM comptemp WHERE name='" + component_name + "'") : database.getResultSet("SELECT * FROM comp WHERE name='" + component_name + "'");
                        dataSet.next();
                    }
                    catch (Exception ex) {
                        dataSet.close();
                        logger.info("no parameters in tempcomp -- trying comp.. " + component_name);
                        dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + component_name + "'");
                        dataSet.next();
                    }
                    this.Ak[0][0] = Double.parseDouble(dataSet.getString("HydrateA1Small"));
                    this.Bk[0][0] = Double.parseDouble(dataSet.getString("HydrateB1Small"));
                    this.Ak[0][1] = Double.parseDouble(dataSet.getString("HydrateA1Large"));
                    this.Bk[0][1] = Double.parseDouble(dataSet.getString("HydrateB1Large"));
                    this.Ak[1][0] = Double.parseDouble(dataSet.getString("HydrateA2Small"));
                    this.Bk[1][0] = Double.parseDouble(dataSet.getString("HydrateB2Small"));
                    this.Ak[1][1] = Double.parseDouble(dataSet.getString("HydrateA2Large"));
                    this.Bk[1][1] = Double.parseDouble(dataSet.getString("HydrateB2Large"));
                }
                catch (Exception ex) {
                    logger.error("error in ComponentHydratePVTsim", (Throwable)ex);
                    try {
                        dataSet.close();
                        database.getConnection().close();
                    }
                    catch (Exception ex2) {
                        logger.error("error closing comp hydrate database....." + component_name);
                    }
                }
            }
            finally {
                try {
                    dataSet.close();
                    database.getConnection().close();
                }
                catch (Exception ex2) {
                    logger.error("error closing comp hydrate database....." + component_name);
                }
            }
        }
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        return this.fugcoef(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure());
    }

    @Override
    public double fugcoef(PhaseInterface phase, int numberOfComps, double temp, double pres) {
        double maxFug = 1.0E100;
        int stableStructure = 0;
        if (this.hydrateStructure == -1) {
            stableStructure = -1;
            this.refPhase.setTemperature(temp);
            this.refPhase.setPressure(pres);
            this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 3, 0, 1.0);
            double refWaterFugacityCoef = Math.log(this.refPhase.getComponent("water").fugcoef(this.refPhase));
            double dhf = 6010.0;
            double tmi = 273.15;
            double dcp = 37.29;
            double LNFUG_ICEREF = refWaterFugacityCoef - dhf / (8.3144621 * tmi) * (tmi / temp - 1.0) + dcp / 8.3144621 * (tmi / temp - 1.0 - Math.log(tmi / temp));
            double VM = 0.0;
            double K1 = 1.607E-4;
            double K2 = 3.4619E-7;
            double K3 = -2.637E-11;
            VM = 1.96522E-5 * (1.0 + K1 * (temp - tmi) + K2 * Math.pow(temp - tmi, 2.0) + K3 * Math.pow(temp - tmi, 3.0));
            double LNFUG_ICE = LNFUG_ICEREF + VM * 100000.0 * (pres - 1.0) / (8.3144621 * temp);
            this.fugacityCoefficient = Math.exp(LNFUG_ICE);
        } else {
            int structure = 0;
            while (structure < 2) {
                this.hydrateStructure = structure;
                if (this.componentName.equals("water")) {
                    this.refPhase.setTemperature(temp);
                    this.refPhase.setPressure(pres);
                    this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 3, 0, 1.0);
                    double refWaterFugacity = this.refPhase.getComponent("water").fugcoef(this.refPhase) * pres;
                    double alphaWater = this.reffug[this.getComponentNumber()];
                    double wateralphaRef = Math.log(refWaterFugacity / alphaWater);
                    logger.info("wateralphaRef " + wateralphaRef + " refFUgalpha " + alphaWater + " refFug " + refWaterFugacity);
                    double val = 0.0;
                    double tempy = 1.0;
                    int cavType = 0;
                    while (cavType < 2) {
                        tempy = 0.0;
                        int j = 0;
                        while (j < phase.getNumberOfComponents()) {
                            double tee = ((ComponentHydrate)phase.getComponent(j)).calcYKI(this.hydrateStructure, cavType, phase);
                            tempy += tee;
                            ++j;
                        }
                        val += this.getCavprwat()[this.hydrateStructure][cavType] * Math.log(1.0 - tempy);
                        ++cavType;
                    }
                    logger.info("val " + val + " structure " + this.hydrateStructure);
                    logger.info("emty " + this.calcDeltaChemPot(phase, numberOfComps, temp, pres, this.hydrateStructure));
                    this.fugacityCoefficient = alphaWater * Math.exp(val + this.calcDeltaChemPot(phase, numberOfComps, temp, pres, this.hydrateStructure) + wateralphaRef) / pres;
                    if (this.fugacityCoefficient < maxFug) {
                        maxFug = this.fugacityCoefficient;
                        stableStructure = this.hydrateStructure;
                    }
                } else {
                    this.fugacityCoefficient = 1.0E50;
                }
                ++structure;
            }
            this.fugacityCoefficient = maxFug;
        }
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        this.hydrateStructure = stableStructure;
        return this.fugacityCoefficient;
    }

    @Override
    public double calcYKI(int stucture, int cavityType, PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            return 0.0;
        }
        double yki = this.calcCKI(stucture, cavityType, phase) * this.reffug[this.componentNumber];
        double temp = 1.0;
        int i = 0;
        while (i < phase.getNumberOfComponents()) {
            if (phase.getComponent(i).isHydrateFormer()) {
                temp += ((ComponentHydrate)phase.getComponent(i)).calcCKI(stucture, cavityType, phase) * this.reffug[i];
            }
            ++i;
        }
        return yki / temp;
    }

    @Override
    public double calcCKI(int stucture, int cavityType, PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            return 0.0;
        }
        return this.Ak[stucture][cavityType] / phase.getTemperature() * Math.exp(this.Bk[stucture][cavityType] / phase.getTemperature());
    }

    public double calcDeltaChemPot(PhaseInterface phase, int numberOfComps, double temp, double pres, int hydrateStruct) {
        double dGf = 0.0;
        double dHf = 0.0;
        double Cp = 0.0;
        double deltaMolarVolume = 0.0;
        if (hydrateStruct == 0) {
            dGf = 1264.0;
            dHf = -4858.0;
            Cp = -39.16;
            deltaMolarVolume = 4.6E-6;
        } else {
            dGf = 883.0;
            dHf = -5201.0;
            Cp = -39.16;
            deltaMolarVolume = 5.0E-6;
        }
        double T0 = 273.15;
        return dGf / 8.3144621 / T0 - (-1.0 * dHf * (0.1202723625380408 / temp - 0.1202723625380408 / T0) + Cp / 8.3144621 * Math.log(temp / T0) + Cp * T0 / 8.3144621 * (1.0 / temp - 1.0 / T0)) + deltaMolarVolume / 8.3144621 / temp * (pres * 100000.0);
    }
}

