/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentGE;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentGEWilson
extends ComponentGE {
    private static final long serialVersionUID = 1000L;

    public ComponentGEWilson(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    public double fugcoef(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.fugacityCoefficient = this.getGamma(phase, numberOfComponents, temperature, pressure, phasetype) * this.getAntoineVaporPressure(temperature) / pressure;
        return this.fugacityCoefficient;
    }

    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        return this.getWilsonActivityCoefficient(phase);
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype, double[][] HValpha, double[][] HVgij, double[][] intparam, String[][] mixRule) {
        return 0.0;
    }

    public double getWilsonActivityCoefficient(PhaseInterface phase1) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double tempSum = 0.0;
        int i = 0;
        while (i < phase1.getNumberOfComponents()) {
            sum1 += phase1.getComponent(i).getx() * ((ComponentGEWilson)phase1.getComponent(i)).getCharEnergyParamter(phase1, this.getComponentNumber(), i);
            tempSum = 0.0;
            int j = 0;
            while (j < phase1.getNumberOfComponents()) {
                tempSum += phase1.getComponent(j).getx() * ((ComponentGEWilson)phase1.getComponent(j)).getCharEnergyParamter(phase1, i, j);
                ++j;
            }
            sum2 += phase1.getComponent(i).getx() * ((ComponentGEWilson)phase1.getComponent(i)).getCharEnergyParamter(phase1, i, this.getComponentNumber()) / tempSum;
            ++i;
        }
        return Math.exp(1.0 - Math.log(sum1) - sum2);
    }

    public double getCharEnergyParamter(PhaseInterface phase1, int comp1, int comp2) {
        double param1 = 0.0;
        double param2 = 0.0;
        if (comp1 == comp2) {
            return 1.0;
        }
        if (phase1.getComponent(comp1).getMolarMass() > phase1.getComponent(comp2).getMolarMass()) {
            param1 = ((ComponentGEWilson)phase1.getComponent(comp2)).getWilsonInteractionEnergy(phase1);
            param2 = ((ComponentGEWilson)phase1.getComponent(comp2)).getWilsonInteractionEnergy(phase1);
        } else {
            param1 = ((ComponentGEWilson)phase1.getComponent(comp1)).getWilsonInteractionEnergy(phase1);
            param2 = ((ComponentGEWilson)phase1.getComponent(comp2)).getWilsonInteractionEnergy(phase1);
        }
        double energyParameter = Math.exp(-(param2 - param1) / (8.3144621 * phase1.getTemperature()));
        return energyParameter;
    }

    public double getWilsonInteractionEnergy(PhaseInterface phase1) {
        double coordinationNumber = 6.0;
        double carbonnumber = this.getMolarMass() / 0.014;
        double x = 1.0 - phase1.getTemperature() / this.getTC();
        double deltaHvap0 = 5.2804 * Math.pow(x, 0.3333) + 12.865 * Math.pow(x, 0.8333) + 1.171 * Math.pow(x, 1.2083) - 13.166 * x + 0.4858 * Math.pow(x, 2.0) - 1.088 * Math.pow(x, 3.0);
        double deltaHvap1 = 0.80022 * Math.pow(x, 0.3333) + 273.23 * Math.pow(x, 0.8333) + 465.08 * Math.pow(x, 1.2083) - 638.51 * x - 145.12 * Math.pow(x, 2.0) - 74.049 * Math.pow(x, 3.0);
        double deltaHvap2 = 7.2543 * Math.pow(x, 0.3333) - 346.45 * Math.pow(x, 0.8333) - 610.48 * Math.pow(x, 1.2083) + 839.89 * x + 160.05 * Math.pow(x, 2.0) - 50.711 * Math.pow(x, 3.0);
        double omega = 0.052075 + 0.0448946 * carbonnumber - 1.85397E-4 * carbonnumber * carbonnumber;
        double deltaHvap = 8.3144621 * this.getTC() * (deltaHvap0 + omega * deltaHvap1 + omega * omega * deltaHvap2) * 4.1868;
        double deltaHtot = (3.7791 * carbonnumber - 12.654) * 1000.0;
        double Tf = 374.5 + 0.2617 * this.getMolarMass() - 20.172 / this.getMolarMass();
        double deltaHf = 0.1426 * this.getMolarMass() * Tf * 4.1868;
        double deltaHtrans = deltaHtot - deltaHf;
        double deltaHsub = deltaHvap + deltaHf + deltaHtrans;
        return -2.0 / coordinationNumber * (deltaHsub - 8.3144621 * phase1.getTemperature());
    }
}

