/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.thermo.atomElement.UNIFACgroup;
import neqsim.thermo.component.ComponentGEUniquac;
import neqsim.thermo.phase.PhaseGEUnifac;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentGEUnifac
extends ComponentGEUniquac {
    private static final long serialVersionUID = 1000L;
    ArrayList<UNIFACgroup> unifacGroups = new ArrayList();
    UNIFACgroup[] unifacGroupsArray = new UNIFACgroup[0];
    double[] lnGammakComp = null;
    double[] lnGammakMix = null;
    double Q = 0.0;
    double R = 0.0;
    int numberOfUnifacSubGroups = 133;
    static Logger logger = LogManager.getLogger(ComponentGEUnifac.class);

    public ComponentGEUnifac(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        if (!this.getClass().equals(ComponentGEUnifac.class)) {
            return;
        }
        if (component_name.contains("_PC")) {
            double number = this.getMolarMass() / 0.014;
            int intNumb = (int)Math.round(number) - 2;
            this.unifacGroups.add(new UNIFACgroup(1, 2));
            this.unifacGroups.add(new UNIFACgroup(2, intNumb));
            logger.info("adding unifac pseudo.." + intNumb);
            return;
        }
        try {
            NeqSimDataBase database = new NeqSimDataBase();
            ResultSet dataSet = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM unifaccomp WHERE Name='" + component_name + "'");
                dataSet.next();
                dataSet.getClob("name");
            }
            catch (Exception ex) {
                dataSet.close();
                dataSet = database.getResultSet("SELECT * FROM unifaccomp WHERE Name='" + component_name + "'");
                dataSet.next();
            }
            int p = 1;
            while (p < this.numberOfUnifacSubGroups) {
                int temp = Integer.parseInt(dataSet.getString("sub" + Integer.toString(p)));
                if (temp > 0) {
                    this.unifacGroups.add(new UNIFACgroup(p, temp));
                }
                ++p;
            }
            dataSet.close();
            database.getConnection().close();
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
    }

    public void addUNIFACgroup(int p, int n) {
        this.unifacGroups.add(new UNIFACgroup(p, n));
        this.unifacGroupsArray = this.unifacGroups.toArray(this.unifacGroupsArray);
    }

    public double getQ() {
        double sum = 0.0;
        int i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            sum += this.getUnifacGroup(i).getQ() * (double)this.getUnifacGroup(i).getN();
            ++i;
        }
        this.Q = sum;
        return sum;
    }

    public double getR() {
        double sum = 0.0;
        int i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            sum += this.getUnifacGroup(i).getR() * (double)this.getUnifacGroup(i).getN();
            ++i;
        }
        this.R = sum;
        return sum;
    }

    @Override
    public double fugcoef(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.fugacityCoefficient = this.getGamma(phase, numberOfComponents, temperature, pressure, phasetype) * this.getAntoineVaporPressure(temperature) / pressure;
        return this.fugacityCoefficient;
    }

    public void calclnGammak(int k, PhaseInterface phase) {
        double sum1Comp = 0.0;
        double sum1Mix = 0.0;
        double sum3Comp = 0.0;
        double sum3Mix = 0.0;
        int i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            sum1Comp += this.getUnifacGroup(i).getQComp() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(i).getGroupIndex(), this.getUnifacGroup(k).getGroupIndex()));
            sum1Mix += this.getUnifacGroup(i).getQMix() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(i).getGroupIndex(), this.getUnifacGroup(k).getGroupIndex()));
            double sum2Comp = 0.0;
            double sum2Mix = 0.0;
            int j = 0;
            while (j < this.getNumberOfUNIFACgroups()) {
                sum2Comp += this.getUnifacGroup(j).getQComp() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(j).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex()));
                sum2Mix += this.getUnifacGroup(j).getQMix() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(j).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex()));
                ++j;
            }
            sum3Comp += this.getUnifacGroup(i).getQComp() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(k).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex())) / sum2Comp;
            sum3Mix += this.getUnifacGroup(i).getQMix() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(k).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex())) / sum2Mix;
            ++i;
        }
        double tempGammaComp = this.getUnifacGroup(k).getQ() * (1.0 - Math.log(sum1Comp) - sum3Comp);
        double tempGammaMix = this.getUnifacGroup(k).getQ() * (1.0 - Math.log(sum1Mix) - sum3Mix);
        this.getUnifacGroup(k).setLnGammaComp(tempGammaComp);
        this.getUnifacGroup(k).setLnGammaMix(tempGammaMix);
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        double lngammaCombinational = 0.0;
        double lngammaResidual = 0.0;
        this.dlngammadn = new double[numberOfComponents];
        this.dlngammadt = 0.0;
        ComponentGEUnifac[] compArray = (ComponentGEUnifac[])phase.getcomponentArray();
        double temp1 = 0.0;
        double temp2 = 0.0;
        double suml = 0.0;
        double V = 0.0;
        double F = 0.0;
        int j = 0;
        while (j < numberOfComponents) {
            temp1 += compArray[j].getx() * compArray[j].getR();
            temp2 += compArray[j].getQ() * compArray[j].getx();
            suml += compArray[j].getx() * (5.0 * (compArray[j].getR() - compArray[j].getQ()) - (compArray[j].getR() - 1.0));
            ++j;
        }
        V = this.getx() * this.getR() / temp1;
        F = this.getx() * this.getQ() / temp2;
        double li = 5.0 * (this.getR() - this.getQ()) - (this.getR() - 1.0);
        lngammaCombinational = Math.log(V / this.getx()) + 5.0 * this.getQ() * Math.log(F / V) + li - V / this.getx() * suml;
        int i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            this.getUnifacGroup(i).calcXComp(this);
            this.getUnifacGroup(i).calcQComp(this);
            this.getUnifacGroup(i).calcQMix((PhaseGEUnifac)phase);
            ++i;
        }
        this.lnGammakComp = new double[this.getNumberOfUNIFACgroups()];
        this.lnGammakMix = new double[this.getNumberOfUNIFACgroups()];
        i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            this.calclnGammak(i, phase);
            ++i;
        }
        lngammaResidual = 0.0;
        i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            lngammaResidual += (double)this.getUnifacGroup(i).getN() * (this.getUnifacGroup(i).getLnGammaMix() - this.getUnifacGroup(i).getLnGammaComp());
            ++i;
        }
        this.lngamma = lngammaResidual + lngammaCombinational;
        this.gamma = Math.exp(this.lngamma);
        return this.gamma;
    }

    @Override
    public double fugcoefDiffPres(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.dfugdp = (Math.log(this.fugcoef(phase, numberOfComponents, temperature, pressure + 0.01, phasetype)) - Math.log(this.fugcoef(phase, numberOfComponents, temperature, pressure - 0.01, phasetype))) / 0.02;
        return this.dfugdp;
    }

    @Override
    public double fugcoefDiffTemp(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.dfugdt = (Math.log(this.fugcoef(phase, numberOfComponents, temperature + 0.01, pressure, phasetype)) - Math.log(this.fugcoef(phase, numberOfComponents, temperature - 0.01, pressure, phasetype))) / 0.02;
        return this.dfugdt;
    }

    public ArrayList<UNIFACgroup> getUnifacGroups2() {
        return this.unifacGroups;
    }

    public UNIFACgroup[] getUnifacGroups() {
        return this.unifacGroupsArray;
    }

    public UNIFACgroup getUnifacGroup2(int i) {
        return this.unifacGroups.get(i);
    }

    public UNIFACgroup getUnifacGroup(int i) {
        return this.unifacGroupsArray[i];
    }

    public void setUnifacGroups(ArrayList<UNIFACgroup> unifacGroups) {
        this.unifacGroups = unifacGroups;
        this.unifacGroupsArray = unifacGroups.toArray(this.unifacGroupsArray);
    }

    public int getNumberOfUNIFACgroups() {
        return this.unifacGroups.size();
    }

    public void setQ(double Q) {
        this.Q = Q;
    }

    public void setR(double R) {
        this.R = R;
    }
}

