/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentCPAInterface;
import neqsim.thermo.component.ComponentModifiedFurstElectrolyteEos;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentElectrolyteCPA
extends ComponentModifiedFurstElectrolyteEos
implements ComponentCPAInterface {
    private static final long serialVersionUID = 1000L;
    int cpaon = 1;
    double[] xsite = new double[0];
    double[][] xsitedni = new double[0][0];
    double[] xsiteOld = new double[0];
    double[] xsitedV = new double[0];
    double[] xsitedT = new double[0];
    double[] xsitedTdT = new double[0];

    public ComponentElectrolyteCPA(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.xsite = new double[this.numberOfAssociationSites];
        this.xsitedni = new double[this.numberOfAssociationSites][100];
        this.xsitedV = new double[this.numberOfAssociationSites];
        this.xsitedT = new double[this.numberOfAssociationSites];
        this.xsitedTdT = new double[this.numberOfAssociationSites];
        this.xsiteOld = new double[this.numberOfAssociationSites];
        if (this.numberOfAssociationSites != 0 && this.cpaon == 1) {
            int j = 0;
            while (j < this.getNumberOfAssociationSites()) {
                this.setXsite(j, 1.0);
                this.setXsiteOld(j, 1.0);
                this.setXsitedV(j, 0.0);
                this.setXsitedT(j, 0.0);
                ++j;
            }
            if (Math.abs(this.aCPA) > 1.0E-6 && this.cpaon == 1) {
                this.a = this.aCPA;
                this.b = this.bCPA;
            }
            this.setAttractiveTerm(0);
        }
    }

    public ComponentElectrolyteCPA(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
        this.xsite = new double[this.numberOfAssociationSites];
        this.xsitedni = new double[this.numberOfAssociationSites][100];
        this.xsitedV = new double[this.numberOfAssociationSites];
        this.xsitedT = new double[this.numberOfAssociationSites];
        this.xsitedTdT = new double[this.numberOfAssociationSites];
        this.xsiteOld = new double[this.numberOfAssociationSites];
        if (this.numberOfAssociationSites != 0 && this.cpaon == 1) {
            int j = 0;
            while (j < this.getNumberOfAssociationSites()) {
                this.setXsite(j, 1.0);
                this.setXsiteOld(j, 1.0);
                this.setXsitedV(j, 0.0);
                this.setXsitedT(j, 0.0);
                ++j;
            }
            if (Math.abs(this.aCPA) > 1.0E-6 && this.cpaon == 1) {
                a = this.aCPA;
                this.b = this.bCPA;
            }
            this.setAttractiveTerm(0);
        }
    }

    @Override
    public ComponentElectrolyteCPA clone() {
        ComponentElectrolyteCPA clonedComponent = null;
        try {
            clonedComponent = (ComponentElectrolyteCPA)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        clonedComponent.xsite = (double[])this.xsite.clone();
        System.arraycopy(this.xsite, 0, clonedComponent.xsite, 0, this.xsite.length);
        clonedComponent.xsiteOld = (double[])this.xsiteOld.clone();
        System.arraycopy(this.xsiteOld, 0, clonedComponent.xsiteOld, 0, this.xsiteOld.length);
        clonedComponent.xsitedV = (double[])this.xsitedV.clone();
        System.arraycopy(this.xsitedV, 0, clonedComponent.xsitedV, 0, this.xsitedV.length);
        clonedComponent.xsitedT = (double[])this.xsitedT.clone();
        System.arraycopy(this.xsitedT, 0, clonedComponent.xsitedT, 0, this.xsitedT.length);
        clonedComponent.xsitedTdT = (double[])this.xsitedTdT.clone();
        System.arraycopy(this.xsitedTdT, 0, clonedComponent.xsitedTdT, 0, this.xsitedTdT.length);
        clonedComponent.xsitedni = (double[][])this.xsitedni.clone();
        System.arraycopy(this.xsitedni, 0, clonedComponent.xsitedni, 0, this.xsitedni.length);
        return clonedComponent;
    }

    @Override
    public double getVolumeCorrection() {
        if (this.getRacketZCPA() < 1.0E-10 && this.cpaon == 1) {
            return 0.0;
        }
        this.setVolumeCorrectionT(this.getVolumeCorrectionT_CPA());
        this.setRacketZ(this.getRacketZCPA());
        return super.getVolumeCorrection();
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
    }

    @Override
    public void setAttractiveTerm(int i) {
        super.setAttractiveTerm(i);
        if (Math.abs(this.aCPA) > 1.0E-6 && this.cpaon == 1) {
            this.getAttractiveTerm().setm(this.mCPA);
        }
    }

    @Override
    public void seta(double a) {
        this.aCPA = a;
    }

    @Override
    public void setb(double a) {
        this.bCPA = a;
    }

    @Override
    public double calca() {
        if (Math.abs(this.aCPA) > 1.0E-6 && this.cpaon == 1) {
            return this.aCPA;
        }
        return super.calca();
    }

    @Override
    public double calcb() {
        if (Math.abs(this.aCPA) > 1.0E-6 && this.cpaon == 1) {
            return this.bCPA;
        }
        return super.calcb();
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double Fsup = super.dFdN(phase, numberOfComponents, temperature, pressure);
        double Fcpa = 0.0;
        if (((PhaseCPAInterface)phase).getTotalNumberOfAccociationSites() > 0) {
            Fcpa = this.dFCPAdN(phase, numberOfComponents, temperature, pressure);
        }
        return Fsup + (double)this.cpaon * Fcpa;
    }

    @Override
    public double dFdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        if (((PhaseCPAInterface)phase).getTotalNumberOfAccociationSites() > 0) {
            return super.dFdNdT(phase, numberOfComponents, temperature, pressure) + (double)this.cpaon * this.dFCPAdNdT(phase, numberOfComponents, temperature, pressure);
        }
        return super.dFdNdT(phase, numberOfComponents, temperature, pressure);
    }

    @Override
    public double dFdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        if (((PhaseCPAInterface)phase).getTotalNumberOfAccociationSites() > 0) {
            return super.dFdNdV(phase, numberOfComponents, temperature, pressure) + (double)this.cpaon * this.dFCPAdNdV(phase, numberOfComponents, temperature, pressure);
        }
        return super.dFdNdV(phase, numberOfComponents, temperature, pressure);
    }

    @Override
    public double dFdNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        if (((PhaseCPAInterface)phase).getTotalNumberOfAccociationSites() > 0) {
            return super.dFdNdN(j, phase, numberOfComponents, temperature, pressure) + (double)this.cpaon * this.dFCPAdNdN(j, phase, numberOfComponents, temperature, pressure);
        }
        return super.dFdNdN(j, phase, numberOfComponents, temperature, pressure);
    }

    public double dFCPAdNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double temp1 = 0.0;
        int i = 0;
        while (i < this.numberOfAssociationSites) {
            temp1 += 1.0 / this.getXsite()[i] * this.getXsitedni(i, j);
            ++i;
        }
        double tot2 = 0.0;
        int i2 = 0;
        while (i2 < phase.getComponent(j).getNumberOfAssociationSites()) {
            tot2 += this.calc_lngi(phase) * (1.0 - ((ComponentElectrolyteCPA)phase.getComponent(j)).getXsite()[i2]);
            ++i2;
        }
        double tot1 = 0.5 * tot2;
        double tot4 = 0.0;
        tot4 = 0.5 * ((PhaseCPAInterface)phase).getHcpatot() * this.calc_lngij(j, phase);
        double tot10 = 0.0;
        int kk = 0;
        while (kk < phase.getNumberOfComponents()) {
            int k = 0;
            while (k < phase.getComponent(kk).getNumberOfAssociationSites()) {
                tot10 += -phase.getComponent(kk).getNumberOfMolesInPhase() * ((ComponentElectrolyteCPA)phase.getComponent(kk)).getXsitedni(k, j);
                ++k;
            }
            ++kk;
        }
        double tot11 = tot10 / 2.0 * this.calc_lngi(phase);
        return temp1 - tot1 - tot4 - tot11;
    }

    public double dFCPAdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double xi = 0.0;
        int i = 0;
        while (i < this.numberOfAssociationSites) {
            xi += Math.log(this.xsite[i]);
            ++i;
        }
        return xi - ((PhaseCPAInterface)phase).getHcpatot() / 2.0 * this.calc_lngi(phase);
    }

    public double dFCPAdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double xi = 0.0;
        int i = 0;
        while (i < this.numberOfAssociationSites) {
            xi += 1.0 / this.xsite[i] * this.xsitedV[i];
            ++i;
        }
        double tot1 = 0.0;
        double tot2 = 0.0;
        int k = 0;
        while (k < phase.getNumberOfComponents()) {
            tot2 = 0.0;
            int i2 = 0;
            while (i2 < phase.getComponent(k).getNumberOfAssociationSites()) {
                tot2 -= this.calc_lngi(phase) * ((ComponentElectrolyteCPA)phase.getComponent(k)).getXsitedV()[i2];
                ++i2;
            }
            tot1 += 0.5 * tot2 * phase.getComponent(k).getNumberOfMolesInPhase();
            ++k;
        }
        double tot3 = 0.0;
        double tot4 = 0.0;
        int k2 = 0;
        while (k2 < phase.getNumberOfComponents()) {
            tot3 = 0.0;
            int i3 = 0;
            while (i3 < phase.getComponent(k2).getNumberOfAssociationSites()) {
                tot3 += (1.0 - ((ComponentElectrolyteCPA)phase.getComponent(k2)).getXsite()[i3]) * this.calc_lngidV(phase);
                ++i3;
            }
            tot4 += 0.5 * phase.getComponent(k2).getNumberOfMolesInPhase() * tot3;
            ++k2;
        }
        return xi - tot1 - tot4;
    }

    public double dFCPAdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double xi = 0.0;
        int i = 0;
        while (i < this.numberOfAssociationSites) {
            xi += 1.0 / this.xsite[i] * this.xsitedT[i];
            ++i;
        }
        double tot1 = 0.0;
        double tot2 = 0.0;
        int k = 0;
        while (k < phase.getNumberOfComponents()) {
            tot2 = 0.0;
            int i2 = 0;
            while (i2 < phase.getComponent(k).getNumberOfAssociationSites()) {
                tot2 -= ((ComponentElectrolyteCPA)phase.getComponent(k)).getXsitedT()[i2];
                ++i2;
            }
            tot1 += tot2 * phase.getComponent(k).getNumberOfMolesInPhase();
            ++k;
        }
        return xi - 0.5 * this.calc_lngi(phase) * tot1;
    }

    public double calc_hCPAdn() {
        double hdn = 0.0;
        int i = 0;
        while (i < this.getNumberOfAssociationSites()) {
            hdn = 1.0 - this.getXsite()[i];
            ++i;
        }
        return hdn;
    }

    @Override
    public double dFCPAdXi(int site, PhaseInterface phase) {
        return this.getNumberOfMolesInPhase() * (1.0 / this.xsite[site] - 0.5);
    }

    public double dFCPAdXidni(int site, PhaseInterface phase) {
        return 1.0 / this.xsite[site] - 0.5;
    }

    @Override
    public double dFCPAdXidXj(int sitei, int sitej, int compj, PhaseInterface phase) {
        double fact = 0.0;
        if (sitei == sitej && compj == this.componentNumber) {
            fact = 1.0;
        }
        return -this.getNumberOfMolesInPhase() / Math.pow(this.xsite[sitei], 2.0) * fact - this.getNumberOfMolesInPhase() * phase.getComponent(compj).getNumberOfMolesInPhase() * ((PhaseCPAInterface)phase).getCpamix().calcDelta(sitei, sitej, this.componentNumber, compj, phase, phase.getTemperature(), phase.getPressure(), phase.getNumberOfComponents());
    }

    @Override
    public double dFCPAdVdXi(int site, PhaseInterface phase) {
        return -1.0 / (2.0 * phase.getTotalVolume()) * (1.0 - phase.getTotalVolume() * ((PhaseCPAInterface)phase).getGcpav()) * this.getNumberOfMolesInPhase();
    }

    @Override
    public double dFCPAdNdXi(int site, PhaseInterface phase) {
        double xi = 1.0 / this.xsite[site];
        return xi + this.getNumberOfMolesInPhase() / 2.0 * this.calc_lngi(phase);
    }

    public double dFCPAdNdXidXdV(PhaseInterface phase) {
        double temp = 0.0;
        int i = 0;
        while (i < this.numberOfAssociationSites) {
            temp += this.dFCPAdNdXi(i, phase) * this.getXsitedV()[i];
            ++i;
        }
        return temp;
    }

    public double calc_lngi(PhaseInterface phase) {
        return 2.0 * this.getBi() * (10.0 * phase.getTotalVolume() - phase.getB()) / ((8.0 * phase.getTotalVolume() - phase.getB()) * (4.0 * phase.getTotalVolume() - phase.getB()));
    }

    public double calc_lngidV(PhaseInterface phase) {
        return 2.0 * this.getBi() * 10.0 / ((8.0 * phase.getTotalVolume() - phase.getB()) * (4.0 * phase.getTotalVolume() - phase.getB())) - 2.0 * this.getBi() * (10.0 * phase.getTotalVolume() - phase.getB()) * (64.0 * phase.getTotalVolume() - 12.0 * phase.getB()) / Math.pow((8.0 * phase.getTotalVolume() - phase.getB()) * (4.0 * phase.getTotalVolume() - phase.getB()), 2.0);
    }

    public double calc_lngij(int j, PhaseInterface phase) {
        return 2.0 * this.getBij(j) * (10.0 * phase.getTotalVolume() - phase.getB()) / ((8.0 * phase.getTotalVolume() - phase.getB()) * (4.0 * phase.getTotalVolume() - phase.getB()));
    }

    @Override
    public double[] getXsite() {
        return this.xsite;
    }

    public void setXsite(double[] xsite) {
        this.xsite = xsite;
    }

    @Override
    public void setXsite(int i, double xsite) {
        this.xsite[i] = xsite;
    }

    @Override
    public double[] getXsitedV() {
        return this.xsitedV;
    }

    @Override
    public void setXsitedV(int i, double xsitedV) {
        this.xsitedV[i] = xsitedV;
    }

    @Override
    public double[] getXsitedT() {
        return this.xsitedT;
    }

    @Override
    public double[] getXsitedTdT() {
        return this.xsitedTdT;
    }

    @Override
    public void setXsitedT(int i, double xsitedT) {
        this.xsitedT[i] = xsitedT;
    }

    @Override
    public void setXsitedTdT(int i, double xsitedTdT) {
        this.xsitedTdT[i] = xsitedTdT;
    }

    @Override
    public double[] getXsiteOld() {
        return this.xsiteOld;
    }

    public void setXsiteOld(double[] xsiteOld) {
        this.xsiteOld = xsiteOld;
    }

    @Override
    public void setXsiteOld(int i, double xsiteOld) {
        this.xsiteOld[i] = xsiteOld;
    }

    public double[][] getXsitedni() {
        return this.xsitedni;
    }

    public double getXsitedni(int xNumb, int compNumbi) {
        return this.xsitedni[xNumb][compNumbi];
    }

    public void setXsitedni(double[][] xsitedni) {
        this.xsitedni = xsitedni;
    }

    @Override
    public void setXsitedni(int xnumb, int compnumb, double val) {
        this.xsitedni[xnumb][compnumb] = val;
    }

    @Override
    public double getSurfaceTenisionInfluenceParameter(double temperature) {
        double AA = 0.0;
        double BB = 0.0;
        if (this.componentName.equals("water")) {
            double TR = 1.0 - temperature / this.getTC();
            AA = -2.2367E-16;
            BB = 2.83732E-16;
            double AAW1 = 2.2505E-16;
            double AAW2 = -1.3646E-16;
            return this.aT * 1.0E-5 * Math.pow(this.b * 1.0E-5, 0.6666666666666666) * (AAW1 + AAW2 * TR + 5.113E-17 * TR * TR);
        }
        if (this.componentName.equals("water2")) {
            double TR = 1.0 - temperature / this.getTC();
            AA = -2.2367E-16;
            BB = 2.83732E-16;
            return this.aT * 1.0E-5 * Math.pow(this.b * 1.0E-5, 0.6666666666666666) * (AA * TR + BB);
        }
        if (this.componentName.equals("MEG")) {
            return 1.04874809905393E-19;
        }
        if (this.componentName.equals("TEG")) {
            return 7.46824658716429E-19;
        }
        return super.getSurfaceTenisionInfluenceParameter(temperature);
    }
}

