/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import java.io.Serializable;
import neqsim.thermo.characterization.WaxModelInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaxCharacterise
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(WaxCharacterise.class);
    SystemInterface thermoSystem = null;
    String name = "";
    protected WaxModelInterface model = new PedersenWaxModel();

    public WaxCharacterise(SystemInterface system) {
        this.thermoSystem = system;
    }

    public WaxCharacterise clone() {
        WaxCharacterise clonedSystem = null;
        try {
            clonedSystem = (WaxCharacterise)super.clone();
            clonedSystem.model = this.model.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }

    public WaxModelInterface getModel(String name) {
        this.name = name;
        if (name.equals("PedersenWax")) {
            return new PedersenWaxModel();
        }
        return new PedersenWaxModel();
    }

    public void setModel(String name) {
        this.name = name;
        if (name.equals("PedersenWax")) {
            this.model = new PedersenWaxModel();
        }
        this.model = new PedersenWaxModel();
    }

    public WaxModelInterface getModel() {
        return this.model;
    }

    public void setModelName(String name) {
        this.name = name;
    }

    public class PedersenWaxModel
    extends WaxBaseModel {
        private static final long serialVersionUID = 1000L;

        public PedersenWaxModel() {
            this.parameterWax[0] = 1.074;
            this.parameterWax[1] = 6.584E-6;
            this.parameterWax[2] = 0.1915;
            this.parameterWaxHeatOfFusion[0] = 1.0;
            this.parameterWaxTriplePointTemperature[0] = 1.0;
        }

        public double calcTriplePointTemperature(int componentNumber) {
            return this.parameterWaxTriplePointTemperature[0] * (374.5 + (0.02617 * (WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(componentNumber).getMolarMass() * 1000.0) - 20172.0 / (WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(componentNumber).getMolarMass() * 1000.0)));
        }

        public double calcHeatOfFusion(int componentNumber) {
            return this.getParameterWaxHeatOfFusion()[0] * 0.1426 / 0.238845 * WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(componentNumber).getMolarMass() * 1000.0 * WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(componentNumber).getTriplePointTemperature();
        }

        public double calcParaffinDensity(int componentNumber) {
            return 0.3915 + 0.0675 * Math.log(WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(componentNumber).getMolarMass() * 1000.0);
        }

        public double calcPCwax(int componentNumber, String normalComponent) {
            return WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(normalComponent).getPC() * Math.pow(this.calcParaffinDensity(componentNumber) / WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(normalComponent).getNormalLiquidDensity(), 3.46);
        }

        @Override
        public void addTBPWax() {
            int numberOfCOmponents = WaxCharacterise.this.thermoSystem.getPhase(0).getNumberOfComponents();
            boolean hasWax = false;
            int i = 0;
            while (i < numberOfCOmponents) {
                if (WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getName().startsWith("wax")) {
                    hasWax = true;
                }
                ++i;
            }
            i = 0;
            while (i < numberOfCOmponents) {
                double C;
                double B;
                double A;
                if (hasWax && WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getName().startsWith("wax")) {
                    A = this.parameterWax[0];
                    B = this.parameterWax[1];
                    C = this.parameterWax[2];
                    String compName = WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getName().substring(3);
                    double densityLocal = this.calcParaffinDensity(i);
                    double molesChange = WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(compName).getNumberOfmoles() * (1.0 - (A + B * WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(compName).getMolarMass() * 1000.0) * Math.pow((WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(compName).getNormalLiquidDensity() - densityLocal) / densityLocal, C));
                    if (molesChange < 0.0) {
                        molesChange = 0.0;
                    }
                    WaxCharacterise.this.thermoSystem.addComponent(compName, -molesChange);
                    WaxCharacterise.this.thermoSystem.addComponent(WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getName(), molesChange);
                    int k = 0;
                    while (k < WaxCharacterise.this.thermoSystem.getNumberOfPhases()) {
                        WaxCharacterise.this.thermoSystem.getPhase(k).getComponent(i).setWaxFormer(true);
                        WaxCharacterise.this.thermoSystem.getPhase(k).getComponent(i).setHeatOfFusion(this.calcHeatOfFusion(i));
                        WaxCharacterise.this.thermoSystem.getPhase(k).getComponent(i).setTriplePointTemperature(this.calcTriplePointTemperature(i));
                        ++k;
                    }
                } else if (!hasWax && (WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).isIsTBPfraction() || WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).isIsPlusFraction())) {
                    A = this.parameterWax[0];
                    B = this.parameterWax[1];
                    C = this.parameterWax[2];
                    double densityLocal = this.calcParaffinDensity(i);
                    double molesChange = WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getNumberOfmoles() * (1.0 - (A + B * WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getMolarMass() * 1000.0) * Math.pow((WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getNormalLiquidDensity() - densityLocal) / densityLocal, C));
                    WaxCharacterise.this.thermoSystem.addComponent(WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getComponentName(), -molesChange);
                    WaxCharacterise.this.thermoSystem.addTBPfraction("wax" + WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getComponentName(), molesChange, WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getMolarMass(), WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getNormalLiquidDensity());
                    int cNumb = WaxCharacterise.this.thermoSystem.getPhase(0).getNumberOfComponents() - 1;
                    double waxPC = this.calcPCwax(cNumb, WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getComponentName());
                    int k = 0;
                    while (k < WaxCharacterise.this.thermoSystem.getNumberOfPhases()) {
                        WaxCharacterise.this.thermoSystem.getPhase(k).getComponent(cNumb).setWaxFormer(true);
                        WaxCharacterise.this.thermoSystem.getPhase(k).getComponent(cNumb).setHeatOfFusion(this.calcHeatOfFusion(cNumb));
                        WaxCharacterise.this.thermoSystem.getPhase(k).getComponent(cNumb).setTriplePointTemperature(this.calcTriplePointTemperature(cNumb));
                        WaxCharacterise.this.thermoSystem.getPhase(k).getComponent(cNumb).setPC(waxPC);
                        ++k;
                    }
                }
                ++i;
            }
        }

        @Override
        public void removeWax() {
            int i = 0;
            while (i < WaxCharacterise.this.thermoSystem.getPhase(0).getNumberOfComponents()) {
                if (WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getName().startsWith("wax")) {
                    String compName = WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getName().substring(3);
                    double moles = WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getNumberOfmoles();
                    WaxCharacterise.this.thermoSystem.addComponent(WaxCharacterise.this.thermoSystem.getPhase(0).getComponent(i).getComponentName(), -moles);
                    WaxCharacterise.this.thermoSystem.addComponent(compName, moles);
                }
                ++i;
            }
        }
    }

    public abstract class WaxBaseModel
    implements WaxModelInterface {
        private static final long serialVersionUID = 1000L;
        double[] parameterWax = new double[3];
        double[] parameterWaxHeatOfFusion = new double[1];
        double[] parameterWaxTriplePointTemperature = new double[1];

        @Override
        public WaxBaseModel clone() {
            WaxBaseModel clonedSystem = null;
            try {
                clonedSystem = (WaxBaseModel)super.clone();
            }
            catch (Exception ex) {
                logger.error("Cloning failed.", (Throwable)ex);
            }
            return clonedSystem;
        }

        @Override
        public void addTBPWax() {
        }

        @Override
        public void setWaxParameters(double[] parameters) {
            this.parameterWax = parameters;
        }

        @Override
        public void setWaxParameter(int i, double parameters) {
            this.parameterWax[i] = parameters;
        }

        @Override
        public void setParameterWaxHeatOfFusion(int i, double parameters) {
            this.parameterWaxHeatOfFusion[i] = parameters;
        }

        @Override
        public void setParameterWaxTriplePointTemperature(int i, double parameters) {
            this.parameterWaxTriplePointTemperature[i] = parameters;
        }

        @Override
        public double[] getWaxParameters() {
            return this.parameterWax;
        }

        @Override
        public double[] getParameterWaxHeatOfFusion() {
            return this.parameterWaxHeatOfFusion;
        }

        @Override
        public void setParameterWaxHeatOfFusion(double[] parameterWaxHeatOfFusion) {
            this.parameterWaxHeatOfFusion = parameterWaxHeatOfFusion;
        }

        @Override
        public double[] getParameterWaxTriplePointTemperature() {
            return this.parameterWaxTriplePointTemperature;
        }

        @Override
        public void setParameterWaxTriplePointTemperature(double[] parameterWaxTriplePointTemperature) {
            this.parameterWaxTriplePointTemperature = parameterWaxTriplePointTemperature;
        }
    }
}

