/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.thermo.characterization.CharacteriseInterface;
import neqsim.thermo.characterization.PlusCharacterize;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewtonSolveCDplus
implements Serializable {
    private static final long serialVersionUID = 1000L;
    int iter = 0;
    Matrix Jac;
    Matrix fvec;
    Matrix sol;
    Matrix dx;
    int numberOfComponents = 0;
    PlusCharacterize characterizeClass;
    static Logger logger = LogManager.getLogger(NewtonSolveCDplus.class);

    public NewtonSolveCDplus() {
    }

    public NewtonSolveCDplus(SystemInterface system, PlusCharacterize characterizeClass) {
        this.characterizeClass = characterizeClass;
        this.numberOfComponents = system.getPhase(0).getNumberOfComponents();
        this.Jac = new Matrix(3, 3);
        this.fvec = new Matrix(3, 1);
        this.sol = new Matrix(3, 1);
        this.sol.set(0, 0, characterizeClass.getCoef(0));
        this.sol.set(1, 0, characterizeClass.getCoef(1));
        this.sol.set(2, 0, characterizeClass.getCoef(2));
    }

    public void setfvec() {
        double zSum = 0.0;
        double mSum = 0.0;
        double densSum = 0.0;
        int i = this.characterizeClass.getFirstPlusFractionNumber();
        while (i < this.characterizeClass.getLastPlusFractionNumber()) {
            double ztemp = Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
            double M = CharacteriseInterface.PVTsimMolarMass[i - 6] / 1000.0;
            double dens = this.characterizeClass.getCoef(2) + this.characterizeClass.getCoef(3) * Math.log(i);
            zSum += ztemp;
            mSum += ztemp * M;
            densSum += ztemp * M / dens;
            ++i;
        }
        densSum = mSum / densSum;
        double lengthPlus = this.characterizeClass.getLastPlusFractionNumber() - this.characterizeClass.getFirstPlusFractionNumber();
        logger.info("diff " + lengthPlus);
        logger.info("zsum " + zSum);
        this.fvec.set(0, 0, zSum - this.characterizeClass.getZPlus());
        this.fvec.set(1, 0, mSum / zSum - this.characterizeClass.getMPlus());
        this.fvec.set(2, 0, densSum - this.characterizeClass.getDensPlus());
    }

    public void setJac() {
        this.Jac.timesEquals(0.0);
        double tempJ = 0.0;
        int j = 0;
        while (j < 3) {
            double nTot = 0.0;
            double nTot2 = 0.0;
            int i = this.characterizeClass.getFirstPlusFractionNumber();
            while (i < this.characterizeClass.getLastPlusFractionNumber()) {
                nTot += Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                nTot2 += (double)i * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                ++i;
            }
            tempJ = j == 0 ? nTot : (j == 1 ? nTot2 : 0.0);
            this.Jac.set(0, j, tempJ);
            ++j;
        }
        j = 0;
        while (j < 3) {
            double mTot1 = 0.0;
            double mTot2 = 0.0;
            double zSum2 = 0.0;
            double zSum = 0.0;
            double zSum3 = 0.0;
            int i = this.characterizeClass.getFirstPlusFractionNumber();
            while (i < this.characterizeClass.getLastPlusFractionNumber()) {
                mTot1 += CharacteriseInterface.PVTsimMolarMass[i - 6] / 1000.0 * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                mTot2 += (double)i * (CharacteriseInterface.PVTsimMolarMass[i - 6] / 1000.0) * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                zSum2 += Math.pow(Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i), 2.0);
                zSum += Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                zSum3 += (double)i * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                ++i;
            }
            tempJ = j == 0 ? (mTot1 * zSum - mTot1 * zSum) / zSum2 : (j == 1 ? (mTot2 * zSum - mTot1 * zSum3) / zSum2 : 0.0);
            this.Jac.set(1, j, tempJ);
            ++j;
        }
        j = 0;
        while (j < 3) {
            double A = 0.0;
            double B = 0.0;
            double Bpow2 = 0.0;
            double Ader1 = 0.0;
            double Bder1 = 0.0;
            double Ader2 = 0.0;
            double Bder2 = 0.0;
            double Bder3 = 0.0;
            double Bder4 = 0.0;
            int i = this.characterizeClass.getFirstPlusFractionNumber();
            while (i < this.characterizeClass.getLastPlusFractionNumber()) {
                double M = CharacteriseInterface.PVTsimMolarMass[i - 6] / 1000.0;
                double dens = this.characterizeClass.getCoef(2) + this.characterizeClass.getCoef(3) * Math.log(i);
                B += M * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) / dens;
                Bpow2 += Math.pow(M * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) / dens, 2.0);
                Ader1 = A += M * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                Bder1 += Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) * M / dens;
                Ader2 += (double)i * M * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                Bder2 += (double)i * M * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) / dens;
                Bder3 += -Math.pow(this.characterizeClass.getCoef(2) + this.characterizeClass.getCoef(3) * Math.log(i), -2.0) * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) * M;
                Bder4 += -Math.log(i) * Math.pow(this.characterizeClass.getCoef(2) + this.characterizeClass.getCoef(3) * Math.log(i), -2.0) * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) * M;
                ++i;
            }
            if (j == 0) {
                tempJ = (Ader1 * B - Bder1 * A) / Bpow2;
            } else if (j == 1) {
                tempJ = (Ader2 * B - Bder2 * A) / Bpow2;
            } else if (j == 2) {
                tempJ = -Bder3 * A / Bpow2;
            } else if (j == 3) {
                tempJ = -Bder4 * A / Bpow2;
            }
            this.Jac.set(2, j, tempJ);
            ++j;
        }
    }

    public void solve() {
        this.iter = 0;
        do {
            ++this.iter;
            this.setfvec();
            logger.info("fvec: ");
            this.fvec.print(10, 17);
            this.setJac();
            this.Jac.print(10, 6);
            this.dx = this.Jac.solve(this.fvec);
            logger.info("dx: ");
            this.dx.print(10, 3);
            if (this.iter < 10) {
                this.sol.minusEquals(this.dx.times((double)this.iter / ((double)this.iter + 5000.0)));
            } else {
                this.sol.minusEquals(this.dx.times((double)this.iter / ((double)this.iter + 50.0)));
            }
            this.characterizeClass.setCoefs(this.sol.transpose().copy().getArray()[0]);
        } while ((this.fvec.norm2() > 1.0E-6 || this.iter < 15) && this.iter < 3000);
        logger.info("ok char: ");
        this.sol.print(10, 10);
    }
}

