/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.atomElement;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Objects;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.component.ComponentGEUnifac;
import neqsim.thermo.phase.PhaseGEUnifac;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UNIFACgroup
implements ThermodynamicConstantsInterface,
Comparable<UNIFACgroup> {
    private static final long serialVersionUID = 1000L;
    double R = 0.0;
    double Q = 0.0;
    int n = 0;
    double xComp = 0.0;
    double QComp = 0.0;
    double QMix = 0.0;
    public double[] QMixdN = null;
    double[] lnGammaMixdn = new double[100];
    double lnGammaComp = 0.0;
    double lnGammaMix = 0.0;
    double lnGammaCompdT = 0.0;
    double lnGammaMixdT = 0.0;
    private double lnGammaCompdTdT = 0.0;
    private double lnGammaMixdTdT = 0.0;
    int groupIndex = 0;
    String groupName = "";
    int mainGroup = 0;
    int subGroup = 0;
    static Logger logger = LogManager.getLogger(UNIFACgroup.class);

    public double[] getQMixdN() {
        return this.QMixdN;
    }

    public void setQMixdN(double[] QMixdN) {
        this.QMixdN = QMixdN;
    }

    public UNIFACgroup() {
    }

    public UNIFACgroup(int groupNumber, int temp) {
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            ResultSet dataSet = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM unifacgroupparam WHERE Secondary=" + groupNumber);
                dataSet.next();
                dataSet.getClob("name");
            }
            catch (Exception ex) {
                dataSet.close();
                dataSet = database.getResultSet("SELECT * FROM unifacgroupparam WHERE Secondary=" + groupNumber);
                dataSet.next();
            }
            this.n = temp;
            this.R = Double.parseDouble(dataSet.getString("VolumeR"));
            this.Q = Double.parseDouble(dataSet.getString("SurfAreaQ"));
            this.mainGroup = Integer.parseInt(dataSet.getString("Main"));
            this.subGroup = Integer.parseInt(dataSet.getString("Secondary"));
            this.groupName = dataSet.getString("Name");
            dataSet.close();
            database.getConnection().close();
        }
        catch (Exception ex) {
            try {
                database.getConnection().close();
            }
            catch (Exception ex2) {
                logger.error(ex2);
            }
            logger.error(ex.toString());
        }
    }

    public double getR() {
        return this.R;
    }

    public void setR(double R) {
        this.R = R;
    }

    public double getQ() {
        return this.Q;
    }

    public void setQ(double Q) {
        this.Q = Q;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public int getMainGroup() {
        return this.mainGroup;
    }

    public void setMainGroup(int mainGroup) {
        this.mainGroup = mainGroup;
    }

    public int getSubGroup() {
        return this.subGroup;
    }

    public void setSubGroup(int subGroup) {
        this.subGroup = subGroup;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public int compareTo(UNIFACgroup o) {
        if (o.getSubGroup() < this.getSubGroup()) {
            return 1;
        }
        if (o.getSubGroup() == this.getSubGroup()) {
            return 0;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.QMixdN);
        result = 31 * result + Arrays.hashCode(this.lnGammaMixdn);
        result = 31 * result + Objects.hash(this.Q, this.QComp, this.QMix, this.R, this.groupIndex, this.groupName, this.lnGammaComp, this.lnGammaCompdT, this.lnGammaCompdTdT, this.lnGammaMix, this.lnGammaMixdT, this.lnGammaMixdTdT, this.mainGroup, this.n, this.subGroup, this.xComp);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UNIFACgroup other = (UNIFACgroup)obj;
        return this.subGroup == other.subGroup;
    }

    public double calcXComp(ComponentGEUnifac component) {
        double temp = 0.0;
        int i = 0;
        while (i < component.getNumberOfUNIFACgroups()) {
            temp += (double)component.getUnifacGroup(i).getN();
            ++i;
        }
        this.xComp = (double)this.getN() / temp;
        return this.xComp;
    }

    public double calcQComp(ComponentGEUnifac component) {
        double temp = 0.0;
        int i = 0;
        while (i < component.getNumberOfUNIFACgroups()) {
            temp += component.getUnifacGroup(i).getXComp() * component.getUnifacGroup(i).getQ();
            ++i;
        }
        this.QComp = this.getQ() * this.getXComp() / temp;
        if (this.getXComp() == 0.0) {
            this.QComp = 0.0;
        }
        return this.QComp;
    }

    public double calcQMix(PhaseGEUnifac phase) {
        double temp = 0.0;
        double temp2 = 0.0;
        int numberOfGrups = 0;
        int j = 0;
        while (j < phase.getNumberOfComponents()) {
            ComponentGEUnifac component = (ComponentGEUnifac)phase.getComponent(j);
            double numberOfMoles = component.getNumberOfMolesInPhase();
            numberOfGrups = component.getNumberOfUNIFACgroups();
            int i = 0;
            while (i < numberOfGrups) {
                UNIFACgroup unifacGroup = component.getUnifacGroup(i);
                double tempVar = numberOfMoles * (double)unifacGroup.getN() * unifacGroup.getQ();
                temp += tempVar;
                if (unifacGroup.getSubGroup() == this.subGroup) {
                    temp2 += tempVar;
                }
                ++i;
            }
            ++j;
        }
        this.QMix = temp2 / temp;
        return this.QMix;
    }

    public double[] calcQMixdN(PhaseGEUnifac phase) {
        this.setQMixdN(new double[phase.getNumberOfComponents()]);
        double tempVardn = 0.0;
        int k = 0;
        while (k < phase.getNumberOfComponents()) {
            double temp = 0.0;
            double temp2 = 0.0;
            double tempdn = 0.0;
            double temp2dn = 0.0;
            int j = 0;
            while (j < phase.getNumberOfComponents()) {
                ComponentGEUnifac component = (ComponentGEUnifac)phase.getComponent(j);
                int i = 0;
                while (i < component.getNumberOfUNIFACgroups()) {
                    UNIFACgroup unifacGroup = component.getUnifacGroup(i);
                    double tempVar = component.getNumberOfMolesInPhase() * (double)component.getUnifacGroup(i).getN() * component.getUnifacGroup(i).getQ();
                    temp += tempVar;
                    if (k == j) {
                        tempVardn = (double)unifacGroup.getN() * unifacGroup.getQ();
                        tempdn += tempVardn;
                    }
                    if (unifacGroup.getSubGroup() == this.subGroup) {
                        temp2 += tempVar;
                        if (k == j) {
                            temp2dn += tempVardn;
                        }
                    }
                    ++i;
                }
                ++j;
            }
            this.getQMixdN()[k] = (temp2dn * temp - temp2 * tempdn) / (temp * temp);
            ++k;
        }
        return this.getQMixdN();
    }

    public double getQMixdN(int comp) {
        return this.QMixdN[comp];
    }

    public double getXComp() {
        return this.xComp;
    }

    public void setXComp(double xComp) {
        this.xComp = xComp;
    }

    public double getQComp() {
        return this.QComp;
    }

    public void setQComp(double QComp) {
        this.QComp = QComp;
    }

    public double getQMix() {
        return this.QMix;
    }

    public void setQMix(double QMix) {
        this.QMix = QMix;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    public double getLnGammaComp() {
        return this.lnGammaComp;
    }

    public void setLnGammaComp(double lnGammaComp) {
        this.lnGammaComp = lnGammaComp;
    }

    public double getLnGammaMix() {
        return this.lnGammaMix;
    }

    public double getLnGammaMixdn(int compNumb) {
        return this.lnGammaMixdn[compNumb];
    }

    public void setLnGammaMixdn(double lnGammaMixdn1, int compNumb) {
        this.lnGammaMixdn[compNumb] = lnGammaMixdn1;
    }

    public void setLnGammaMix(double lnGammaMix) {
        this.lnGammaMix = lnGammaMix;
    }

    public double getLnGammaCompdT() {
        return this.lnGammaCompdT;
    }

    public void setLnGammaCompdT(double lnGammaCompdT) {
        this.lnGammaCompdT = lnGammaCompdT;
    }

    public double getLnGammaMixdT() {
        return this.lnGammaMixdT;
    }

    public void setLnGammaMixdT(double lnGammaMixdT) {
        this.lnGammaMixdT = lnGammaMixdT;
    }

    public double getLnGammaCompdTdT() {
        return this.lnGammaCompdTdT;
    }

    public void setLnGammaCompdTdT(double lnGammaCompdTdT) {
        this.lnGammaCompdTdT = lnGammaCompdTdT;
    }

    public double getLnGammaMixdTdT() {
        return this.lnGammaMixdTdT;
    }

    public void setLnGammaMixdTdT(double lnGammaMixdTdT) {
        this.lnGammaMixdTdT = lnGammaMixdTdT;
    }
}

