/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo;

import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThermodynamicModelTest
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    SystemInterface system;
    static Logger logger = LogManager.getLogger(ThermodynamicModelTest.class);

    public ThermodynamicModelTest() {
    }

    public ThermodynamicModelTest(SystemInterface system) {
        this.system = system;
    }

    public void runTest() {
        this.system.init(3);
        logger.info("testing fugacitycoefs..." + this.checkFugacityCoefficients());
        logger.info("testing fugacity der composition..." + this.checkFugacityCoefficientsDn());
        logger.info("testing fugacity der composition2..." + this.checkFugacityCoefficientsDn2());
        logger.info("testing fugacity der pressure..." + this.checkFugacityCoefficientsDP());
        logger.info("testing fugacity der temperature..." + this.checkFugacityCoefficientsDT());
        logger.info("comparing to numerical derivatives..." + this.checkNumerically());
    }

    public boolean checkFugacityCoefficients() {
        double temp1 = 0.0;
        int j = 0;
        while (j < this.system.getNumberOfPhases()) {
            int i = 0;
            while (i < this.system.getPhase(j).getNumberOfComponents()) {
                temp1 += this.system.getPhase(j).getComponents()[i].getNumberOfMolesInPhase() * Math.log(this.system.getPhase(j).getComponents()[i].getFugacityCoefficient());
                ++i;
            }
            temp1 -= this.system.getPhase(j).getGresTP() / (8.3144621 * this.system.getTemperature());
            ++j;
        }
        logger.info("Testing fugacity coefficients...................");
        double sum = Math.abs(temp1);
        return Math.abs(sum) < 1.0E-10;
    }

    public boolean checkFugacityCoefficientsDn() {
        double temp1 = 0.0;
        double sum = 0.0;
        int k = 0;
        while (k < this.system.getNumberOfPhases()) {
            int j = 0;
            while (j < this.system.getPhase(k).getNumberOfComponents()) {
                temp1 = 0.0;
                int i = 0;
                while (i < this.system.getPhase(k).getNumberOfComponents()) {
                    temp1 += this.system.getPhase(k).getComponents()[i].getNumberOfMolesInPhase() * this.system.getPhase(k).getComponents()[i].getdfugdn(j);
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        logger.info("Testing composition derivatives of fugacity coefficients...................");
        logger.info("Diffference : " + (sum += Math.abs(temp1)));
        return Math.abs(sum) < 1.0E-10;
    }

    public boolean checkFugacityCoefficientsDn2() {
        double temp1 = 0.0;
        double sum = 0.0;
        int k = 0;
        while (k < this.system.getNumberOfPhases()) {
            int j = 0;
            while (j < this.system.getPhase(k).getNumberOfComponents()) {
                temp1 = 0.0;
                int i = 0;
                while (i < this.system.getPhase(k).getNumberOfComponents()) {
                    temp1 += this.system.getPhase(k).getComponents()[i].getdfugdn(j) - this.system.getPhase(k).getComponents()[j].getdfugdn(i);
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        logger.info("Testing composition derivatives2 of fugacity coefficients...................");
        logger.info("Diffference : " + (sum += Math.abs(temp1)));
        return Math.abs(sum) < 1.0E-10;
    }

    public boolean checkFugacityCoefficientsDP() {
        double temp1 = 0.0;
        double temp2 = 0.0;
        double sum = 0.0;
        int j = 0;
        while (j < this.system.getNumberOfPhases()) {
            int i = 0;
            while (i < this.system.getPhase(j).getNumberOfComponents()) {
                temp1 += this.system.getPhase(j).getComponents()[i].getNumberOfMolesInPhase() * this.system.getPhase(j).getComponents()[i].getdfugdp();
                ++i;
            }
            temp1 -= (this.system.getPhase(j).getZ() - 1.0) * this.system.getPhase(j).getNumberOfMolesInPhase() / this.system.getPhase(j).getPressure();
            ++j;
        }
        sum = Math.abs(temp1) + Math.abs(temp2);
        logger.info("Testing pressure derivatives of fugacity coefficients...................");
        logger.info("Error : " + sum);
        return Math.abs(sum) < 1.0E-10;
    }

    public boolean checkFugacityCoefficientsDT() {
        double temp1 = 0.0;
        double sum = 0.0;
        int j = 0;
        while (j < this.system.getNumberOfPhases()) {
            int i = 0;
            while (i < this.system.getPhase(j).getNumberOfComponents()) {
                temp1 += this.system.getPhase(j).getComponents()[i].getNumberOfMolesInPhase() * this.system.getPhase(j).getComponents()[i].getdfugdt();
                ++i;
            }
            temp1 += this.system.getPhase(j).getHresTP() / (8.3144621 * Math.pow(this.system.getTemperature(), 2.0));
            ++j;
        }
        sum = Math.abs(temp1);
        logger.info("Testing temperature derivatives of fugacity coefficients...................");
        logger.info("Error : " + sum);
        return Math.abs(sum) < 1.0E-10;
    }

    public boolean checkNumerically() {
        double[][] gasfug = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][] liqfug = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][] gasnumericDfugdt = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][] liqnumericDfugdt = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][] gasnumericDfugdp = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][] liqnumericDfugdp = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][][] gasnumericDfugdn = new double[2][this.system.getPhases()[0].getNumberOfComponents()][this.system.getPhases()[0].getNumberOfComponents()];
        double[][][] liqnumericDfugdn = new double[2][this.system.getPhases()[0].getNumberOfComponents()][this.system.getPhases()[0].getNumberOfComponents()];
        this.system.init(3);
        int i = 0;
        while (i < this.system.getPhases()[0].getNumberOfComponents()) {
            gasnumericDfugdt[0][i] = this.system.getPhases()[0].getComponents()[i].getdfugdt();
            gasnumericDfugdp[0][i] = this.system.getPhases()[0].getComponents()[i].getdfugdp();
            liqnumericDfugdt[0][i] = this.system.getPhases()[1].getComponents()[i].getdfugdt();
            liqnumericDfugdp[0][i] = this.system.getPhases()[1].getComponents()[i].getdfugdp();
            int k = 0;
            while (k < this.system.getPhases()[0].getNumberOfComponents()) {
                gasnumericDfugdn[0][i][k] = this.system.getPhases()[0].getComponents()[i].getdfugdn(k);
                liqnumericDfugdn[0][i][k] = this.system.getPhases()[1].getComponents()[i].getdfugdn(k);
                ++k;
            }
            ++i;
        }
        double dt = this.system.getTemperature() / 100000.0;
        this.system.setTemperature(this.system.getTemperature() + dt);
        this.system.init(3);
        int i2 = 0;
        while (i2 < this.system.getPhases()[0].getNumberOfComponents()) {
            gasfug[0][i2] = Math.log(this.system.getPhases()[0].getComponents()[i2].getFugacityCoefficient());
            liqfug[0][i2] = Math.log(this.system.getPhases()[1].getComponents()[i2].getFugacityCoefficient());
            ++i2;
        }
        this.system.setTemperature(this.system.getTemperature() - 2.0 * dt);
        this.system.init(3);
        i2 = 0;
        while (i2 < this.system.getPhases()[0].getNumberOfComponents()) {
            gasfug[1][i2] = Math.log(this.system.getPhases()[0].getComponents()[i2].getFugacityCoefficient());
            liqfug[1][i2] = Math.log(this.system.getPhases()[1].getComponents()[i2].getFugacityCoefficient());
            ++i2;
        }
        i2 = 0;
        while (i2 < this.system.getPhases()[0].getNumberOfComponents()) {
            logger.info("dt: gas phase comp " + i2 + "  % error " + ((gasfug[0][i2] - gasfug[1][i2]) / (2.0 * dt) - gasnumericDfugdt[0][i2]) / gasnumericDfugdt[0][i2] * 100.0);
            logger.info("dt: liq phase comp " + i2 + "  % error " + ((liqfug[0][i2] - liqfug[1][i2]) / (2.0 * dt) - liqnumericDfugdt[0][i2]) / liqnumericDfugdt[0][i2] * 100.0);
            ++i2;
        }
        this.system.setTemperature(this.system.getTemperature() + dt);
        this.system.init(3);
        double dp = this.system.getPressure() / 100000.0;
        this.system.setPressure(this.system.getPressure() + dp);
        this.system.init(3);
        int i3 = 0;
        while (i3 < this.system.getPhases()[0].getNumberOfComponents()) {
            gasfug[0][i3] = Math.log(this.system.getPhases()[0].getComponents()[i3].getFugacityCoefficient());
            liqfug[0][i3] = Math.log(this.system.getPhases()[1].getComponents()[i3].getFugacityCoefficient());
            ++i3;
        }
        this.system.setPressure(this.system.getPressure() - 2.0 * dp);
        this.system.init(3);
        i3 = 0;
        while (i3 < this.system.getPhases()[0].getNumberOfComponents()) {
            gasfug[1][i3] = Math.log(this.system.getPhases()[0].getComponents()[i3].getFugacityCoefficient());
            liqfug[1][i3] = Math.log(this.system.getPhases()[1].getComponents()[i3].getFugacityCoefficient());
            ++i3;
        }
        i3 = 0;
        while (i3 < this.system.getPhases()[0].getNumberOfComponents()) {
            logger.info("dp: gas phase comp " + i3 + "  % error " + ((gasfug[0][i3] - gasfug[1][i3]) / (2.0 * dp) - gasnumericDfugdp[0][i3]) / gasnumericDfugdp[0][i3] * 100.0);
            logger.info("dp: liq phase comp " + i3 + "  % error " + ((liqfug[0][i3] - liqfug[1][i3]) / (2.0 * dp) - liqnumericDfugdp[0][i3]) / liqnumericDfugdp[0][i3] * 100.0);
            ++i3;
        }
        this.system.setPressure(this.system.getPressure() + dp);
        this.system.init(3);
        int phase = 0;
        while (phase < 2) {
            int k = 0;
            while (k < this.system.getPhases()[0].getNumberOfComponents()) {
                double dn = this.system.getPhases()[phase].getComponents()[k].getNumberOfMolesInPhase() / 100000.0;
                logger.info("component name " + this.system.getPhases()[phase].getComponents()[k].getComponentName());
                logger.info("dn " + dn);
                if (dn < 1.0E-12) {
                    dn = 1.0E-12;
                }
                this.system.addComponent(k, dn, phase);
                this.system.init_x_y();
                this.system.init(3);
                int i4 = 0;
                while (i4 < this.system.getPhases()[0].getNumberOfComponents()) {
                    liqfug[0][i4] = Math.log(this.system.getPhases()[phase].getComponents()[i4].getFugacityCoefficient());
                    ++i4;
                }
                this.system.addComponent(k, -2.0 * dn, phase);
                this.system.init_x_y();
                this.system.init(3);
                i4 = 0;
                while (i4 < this.system.getPhases()[0].getNumberOfComponents()) {
                    liqfug[1][i4] = Math.log(this.system.getPhases()[phase].getComponents()[i4].getFugacityCoefficient());
                    ++i4;
                }
                i4 = 0;
                while (i4 < this.system.getPhases()[0].getNumberOfComponents()) {
                    if (phase == 0) {
                        logger.info("dn: gas phase comp " + i4 + "  % error " + ((liqfug[0][i4] - liqfug[1][i4]) / (2.0 * dn) - gasnumericDfugdn[0][i4][k]) / gasnumericDfugdn[0][i4][k] * 100.0);
                    }
                    if (phase == 1) {
                        logger.info("dn: liq phase comp " + i4 + "  % error " + ((liqfug[0][i4] - liqfug[1][i4]) / (2.0 * dn) - liqnumericDfugdn[0][i4][k]) / liqnumericDfugdn[0][i4][k] * 100.0);
                    }
                    ++i4;
                }
                this.system.addComponent(k, dn, phase);
                this.system.init_x_y();
                this.system.init(3);
                ++k;
            }
            ++phase;
        }
        return true;
    }
}

