/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemPrEos;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Fluid {
    static Logger logger = LogManager.getLogger(Fluid.class);
    SystemInterface fluid = null;
    private boolean hasWater = false;
    private boolean autoSelectModel = false;
    private String thermoModel = "srk";
    private String thermoMixingRule = "classic";

    public SystemInterface getFluid() {
        return this.fluid;
    }

    private void setThermoModel() {
        this.fluid = this.thermoModel.equals("srk") ? new SystemSrkEos() : (this.thermoModel.equals("pr") ? new SystemPrEos() : (this.thermoModel.equals("cpa") ? new SystemSrkCPAstatoil() : new SystemSrkEos()));
    }

    public SystemInterface create2(String[] componentNames) {
        double[] comp = new double[componentNames.length];
        int i = 0;
        while (i < componentNames.length) {
            comp[i] = 1.0;
            ++i;
        }
        return this.create2(componentNames, comp, "mol/sec");
    }

    public SystemInterface create2(String[] componentNames, double[] flowrate, String unit) {
        this.setThermoModel();
        this.createFluid(componentNames, flowrate, unit);
        if (this.isHasWater()) {
            this.fluid.addComponent("water", 0.1);
        }
        this.fluid.createDatabase(true);
        this.fluid.setMixingRule(this.fluid.getMixingRule());
        if (this.isHasWater()) {
            this.fluid.setMultiPhaseCheck(true);
        }
        if (this.isAutoSelectModel()) {
            this.fluid = this.fluid.autoSelectModel();
        }
        this.fluid.init(0);
        return this.fluid;
    }

    public SystemInterface create(String fluidType) {
        String[] compNames = null;
        double[] flowrate = null;
        this.setThermoModel();
        if (fluidType.equals("water")) {
            compNames = new String[]{"water"};
            flowrate = new double[]{1.0};
            this.createFluid(compNames, flowrate, "mole/sec");
        }
        if (fluidType.equals("dry gas")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane"};
            flowrate = new double[]{0.01, 0.02, 0.82, 0.11, 0.05, 0.01, 0.012};
            this.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("rich gas")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane", "n-heptane", "n-octane", "n-nonane", "nC10"};
            flowrate = new double[]{0.01, 0.02, 0.82, 0.11, 0.05, 0.01, 0.012, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01};
            this.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("air")) {
            compNames = new String[]{"nitrogen", "oxygen"};
            flowrate = new double[]{0.78, 0.22};
            this.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("combustion air")) {
            compNames = new String[]{"nitrogen", "oxygen", "CO2", "water"};
            flowrate = new double[]{0.78084, 0.20946, 0.033, 0.1};
            this.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("gas condensate")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane", "n-heptane", "n-octane", "n-nonane", "nC10"};
            flowrate = new double[]{0.01, 0.02, 0.32, 0.05, 0.03, 0.01, 0.012, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01};
            this.createFluid(compNames, flowrate, "mole/sec");
            String[] charNames = new String[]{"C10-C15", "C16-C19", "C20-C30", "C31-C50"};
            double[] charFlowrate = new double[]{0.1, 0.08, 0.05, 0.01};
            double[] molarMass = new double[]{0.2, 0.3, 0.36, 0.4};
            double[] density2 = new double[]{0.7, 0.81, 0.88, 0.92};
            this.getFluid().addCharacterized(charNames, charFlowrate, molarMass, density2);
        } else if (fluidType.equals("petrol")) {
            compNames = new String[]{"n-pentane", "n-hexane", "n-heptane", "n-octane", "n-nonane", "nC10", "nC11", "nC12"};
            flowrate = new double[]{0.1, 0.1, 0.1, 0.1, 0.3, 0.1, 0.1, 0.1};
            this.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("diesel")) {
            compNames = new String[]{"n-heptane", "n-octane", "n-nonane", "nC10", "nC11", "nC12", "nC13", "nC14"};
            flowrate = new double[]{0.1, 0.1, 0.1, 0.3, 0.1, 0.1, 0.1, 0.1};
            this.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("light oil")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane", "n-heptane", "n-octane", "n-nonane", "nC10"};
            flowrate = new double[]{0.01, 0.02, 0.52, 0.11, 0.05, 0.01, 0.012, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01};
            this.createFluid(compNames, flowrate, "mole/sec");
            String[] charNames = new String[]{"C10-C15", "C16-C19", "C20-C30", "C31-C50"};
            double[] charFlowrate = new double[]{0.2, 0.1, 0.05, 0.01};
            double[] molarMass = new double[]{0.2, 0.3, 0.36, 0.4};
            double[] density3 = new double[]{0.7, 0.81, 0.88, 0.92};
            this.getFluid().addCharacterized(charNames, charFlowrate, molarMass, density3);
        } else if (fluidType.equals("black oil")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane"};
            flowrate = new double[]{0.01, 0.02, 0.22, 0.11, 0.05, 0.01, 0.012, 0.01, 0.01, 0.01};
            this.createFluid(compNames, flowrate, "mole/sec");
            String[] charNames = new String[]{"C10-C15", "C16-C19", "C20-C30", "C31-C50", "C51-C80"};
            double[] charFlowrate = new double[]{0.2, 0.1, 0.1, 0.05, 0.01};
            double[] molarMass = new double[]{0.2, 0.25, 0.3, 0.36, 0.4};
            double[] density4 = new double[]{0.7, 0.75, 0.81, 0.88, 0.92};
            this.getFluid().addCharacterized(charNames, charFlowrate, molarMass, density4);
        } else if (fluidType.equals("black oil with water")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane"};
            flowrate = new double[]{0.01, 0.02, 0.22, 0.11, 0.05, 0.01, 0.012, 0.01, 0.01, 0.01};
            this.createFluid(compNames, flowrate, "mole/sec");
            String[] charNames = new String[]{"C10-C15", "C16-C19", "C20-C30", "C31-C50", "C51-C80"};
            double[] charFlowrate = new double[]{0.2, 0.1, 0.1, 0.05, 0.01};
            double[] molarMass = new double[]{0.2, 0.25, 0.3, 0.36, 0.4};
            double[] density5 = new double[]{0.7, 0.75, 0.81, 0.88, 0.92};
            this.getFluid().addCharacterized(charNames, charFlowrate, molarMass, density5);
            this.setHasWater(true);
        } else if (fluidType.equals("heavy oil")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane"};
            flowrate = new double[]{0.01, 0.01, 0.12, 0.11, 0.05, 0.01, 0.012, 0.01, 0.01, 0.01};
            this.createFluid(compNames, flowrate, "mole/sec");
            String[] charNames = new String[]{"C10-C15", "C16-C19", "C20-C30", "C31-C50", "C51-C80"};
            double[] charFlowrate = new double[]{0.2, 0.2, 0.2, 0.1, 0.1};
            double[] molarMass = new double[]{0.2, 0.25, 0.3, 0.36, 0.4};
            double[] density6 = new double[]{0.7, 0.75, 0.81, 0.88, 0.92};
            this.getFluid().addCharacterized(charNames, charFlowrate, molarMass, density6);
        } else if (NeqSimDataBase.hasComponent(fluidType)) {
            compNames = new String[]{fluidType};
            flowrate = new double[]{1.0};
            this.createFluid(compNames, flowrate, "mole/sec");
        } else {
            return null;
        }
        if (this.isHasWater()) {
            this.fluid.addComponent("water", 0.1);
        }
        this.fluid.createDatabase(true);
        this.fluid.setMixingRule(this.fluid.getMixingRule());
        if (this.isHasWater()) {
            this.fluid.setMultiPhaseCheck(true);
        }
        if (this.isAutoSelectModel()) {
            this.fluid = this.fluid.autoSelectModel();
        }
        this.fluid.init(0);
        return this.fluid;
    }

    public SystemInterface createFluid(String[] componentNames, double[] flowrate, String unit) {
        this.setThermoModel();
        if (componentNames.length != flowrate.length) {
            logger.error("component names and mole fractions need to be same length...");
        }
        int i = 0;
        while (i < componentNames.length) {
            this.fluid.addComponent(componentNames[i], flowrate[i], unit);
            ++i;
        }
        return this.fluid;
    }

    public void addComponment(String name) {
        this.fluid.addComponent(name, 1.0);
        this.fluid.createDatabase(true);
        this.fluid.setMixingRule(2);
        if (this.isHasWater()) {
            this.fluid.setMultiPhaseCheck(true);
        }
    }

    public static void main(String[] args) {
        Fluid fluidCreator = new Fluid();
        SystemInterface fluid = fluidCreator.create("petrol");
        fluid.display();
        SystemInterface fluid2 = fluidCreator.create("dry gas");
        fluid2.display();
        fluid2.getNumberOfComponents();
        SystemInterface fluid3 = fluidCreator.create("black oil with water");
        fluid3.display();
        fluid3.getNumberOfComponents();
    }

    public boolean isHasWater() {
        return this.hasWater;
    }

    public void setHasWater(boolean hasWater) {
        this.hasWater = hasWater;
    }

    public boolean isAutoSelectModel() {
        return this.autoSelectModel;
    }

    public void setAutoSelectModel(boolean autoSelectModel) {
        this.autoSelectModel = autoSelectModel;
    }

    public String getThermoModel() {
        return this.thermoModel;
    }

    public void setThermoModel(String thermoModel) {
        this.thermoModel = thermoModel;
    }

    public String getThermoMixingRule() {
        return this.thermoMixingRule;
    }

    public void setThermoMixingRule(String thermoMixingRule) {
        this.thermoMixingRule = thermoMixingRule;
    }
}

