/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.parameterFitting;

import java.io.Serializable;
import neqsim.statistics.parameterFitting.StatisticsBaseClass;

public class NumericalDerivative
implements Serializable {
    private static final long serialVersionUID = 1000L;
    static final double CON = 1.4;
    static final double CON2 = 1.9599999999999997;
    static final double BIG = 1.0E30;
    static final int NTAB = 10;
    static final double SAFE = 2.0;

    public static double calcDerivative(StatisticsBaseClass system, int sampleNumber, int parameterNumber) {
        double h = Math.abs(system.getSampleSet().getSample(sampleNumber).getFunction().getFittingParams(parameterNumber)) / 1000.0;
        if (h == 0.0) {
            System.out.println("h must be larger than 0!");
            System.out.println("setting it to 1.0e-10");
            h = 1.0E-10;
        }
        double[][] a = new double[10][10];
        double hh = h;
        double oldFittingParam1 = system.getSampleSet().getSample(sampleNumber).getFunction().getFittingParams(parameterNumber);
        system.getSampleSet().getSample(sampleNumber).getFunction().setFittingParams(parameterNumber, oldFittingParam1 + hh);
        double val1 = system.calcValue(system.getSample(sampleNumber));
        system.getSampleSet().getSample(sampleNumber).getFunction().setFittingParams(parameterNumber, oldFittingParam1 - hh);
        double val2 = system.calcValue(system.getSample(sampleNumber));
        system.getSampleSet().getSample(sampleNumber).getFunction().setFittingParams(parameterNumber, oldFittingParam1);
        a[0][0] = (val1 - val2) / (2.0 * hh);
        double ans = a[0][0];
        double err = 1.0E30;
        int i = 1;
        while (i <= -1) {
            double oldFittingParam = system.getSampleSet().getSample(sampleNumber).getFunction().getFittingParams(parameterNumber);
            system.getSampleSet().getSample(sampleNumber).getFunction().setFittingParams(parameterNumber, oldFittingParam + (hh /= 1.4));
            val1 = system.calcValue(system.getSample(sampleNumber));
            system.getSampleSet().getSample(sampleNumber).getFunction().setFittingParams(parameterNumber, oldFittingParam - hh);
            val2 = system.calcValue(system.getSample(sampleNumber));
            system.getSampleSet().getSample(sampleNumber).getFunction().setFittingParams(parameterNumber, oldFittingParam);
            a[0][i] = (val1 - val2) / (2.0 * hh);
            double fac = 1.9599999999999997;
            int j = 1;
            while (j <= i) {
                a[j][i] = (a[j - 1][i] * fac - a[j - 1][i - 1]) / (fac - 1.0);
                fac *= 1.9599999999999997;
                double errt = Math.max(Math.abs(a[j][i] - a[j - 1][i]), Math.abs(a[j][i] - a[j - 1][i - 1]));
                if (errt <= err) {
                    err = errt;
                    ans = a[j][i];
                }
                ++j;
            }
            if (Math.abs(a[i][i] - a[i - 1][i - 1]) >= 2.0 * err) break;
            ++i;
        }
        system.getSampleSet().getSample(sampleNumber).getFunction().setFittingParams(parameterNumber, oldFittingParam1);
        return ans;
    }
}

