/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.dataAnalysis.dataSmoothing;

import Jama.Matrix;

public class DataSmoothor {
    double[] nonSmoothedNumbers;
    double[] smoothedNumbers;
    double[] cCoef;
    int nl = 0;
    int nr = 0;
    int ld = 0;
    int m = 0;
    int mm = 0;
    int imj = 0;
    int kk = 0;
    int[] index;
    double[][] a;
    double[] b;
    double sum = 0.0;
    double fac = 0.0;

    public DataSmoothor() {
    }

    public DataSmoothor(double[] nonSmoothedNumbers, int nl, int nr, int ld, int m) {
        this.nonSmoothedNumbers = new double[nonSmoothedNumbers.length];
        this.smoothedNumbers = new double[nonSmoothedNumbers.length];
        this.cCoef = new double[nonSmoothedNumbers.length];
        this.nonSmoothedNumbers = nonSmoothedNumbers;
        System.arraycopy(nonSmoothedNumbers, 0, this.smoothedNumbers, 0, nonSmoothedNumbers.length);
        this.nl = nl;
        this.nr = nr;
        this.ld = ld;
        this.m = m;
    }

    public void runSmoothing() {
        this.findCoefs();
        this.setSmoothedNumbers();
    }

    public void findCoefs() {
        if (this.nonSmoothedNumbers.length < this.nl + this.nr + 1 || this.nl < 0 || this.nr < 0 || this.ld > this.m || this.nl + this.nr < this.m) {
            System.err.println("Wrong input to DataSmoothor!");
        }
        this.index = new int[this.m + 1];
        this.a = new double[this.m + 1][this.m + 1];
        this.b = new double[this.m + 1];
        int i = 0;
        while (i < this.m + 1) {
            this.index[i] = 1;
            this.b[i] = 1.0;
            int j = 0;
            while (j < this.m + 1) {
                this.a[j][j] = 1.0;
                ++j;
            }
            ++i;
        }
        int ipj = 0;
        while (ipj <= this.m << 1) {
            this.sum = ipj != 0 ? 0.0 : 1.0;
            int k = 1;
            while (k <= this.nr) {
                this.sum += Math.pow(k, ipj);
                ++k;
            }
            k = 1;
            while (k <= this.nl) {
                this.sum += Math.pow(-k, ipj);
                ++k;
            }
            this.mm = Math.min(ipj, 2 * this.m - ipj);
            this.imj = -this.mm;
            while (this.imj <= this.mm) {
                this.a[(ipj + this.imj) / 2][(ipj - this.imj) / 2] = this.sum;
                this.imj += 2;
            }
            ++ipj;
        }
        int j = 0;
        while (j < this.m + 1) {
            this.b[j] = 0.0;
            ++j;
        }
        this.b[this.ld] = 1.0;
        Matrix amatrix = new Matrix(this.a);
        Matrix bmatrix = new Matrix(this.b, 1);
        bmatrix = amatrix.solve(bmatrix.transpose());
        this.b = bmatrix.transpose().getArray()[0];
        int kk = 0;
        while (kk < this.nonSmoothedNumbers.length) {
            this.cCoef[kk] = 0.0;
            ++kk;
        }
        int k = -this.nl;
        while (k <= this.nr) {
            this.sum = this.b[0];
            this.fac = 1.0;
            this.mm = 0;
            while (this.mm < this.m) {
                this.sum += this.b[this.mm + 1] * (this.fac *= (double)k);
                ++this.mm;
            }
            this.kk = (this.nonSmoothedNumbers.length - k) % this.nonSmoothedNumbers.length;
            this.cCoef[this.kk] = this.sum;
            ++k;
        }
    }

    public void setSmoothedNumbers() {
        int i = this.nl;
        while (i < this.nonSmoothedNumbers.length - this.nr) {
            this.smoothedNumbers[i] = 0.0;
            this.smoothedNumbers[i] = this.cCoef[0] * this.nonSmoothedNumbers[i];
            int j = 0;
            while (j < this.nl) {
                int n = i;
                this.smoothedNumbers[n] = this.smoothedNumbers[n] + this.cCoef[this.nonSmoothedNumbers.length - 1 - j] * this.nonSmoothedNumbers[i - j - 1];
                ++j;
            }
            j = 0;
            while (j < this.nr) {
                int n = i;
                this.smoothedNumbers[n] = this.smoothedNumbers[n] + this.cCoef[j + 1] * this.nonSmoothedNumbers[i + j - 1];
                ++j;
            }
            ++i;
        }
    }

    public double[] getSmoothedNumbers() {
        return this.smoothedNumbers;
    }

    public static void main(String[] args) {
        double[] numbers = new double[]{10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.5, 15.0, 19.0, 14.0, 14.0, 13.0, 12.0, 12.0, 11.0, 10.0, 9.0, 8.0};
        DataSmoothor test = new DataSmoothor(numbers, 3, 3, 0, 4);
        Matrix data = new Matrix(test.getSmoothedNumbers(), 1);
        data.print(10, 2);
        test.runSmoothing();
        data = new Matrix(test.getSmoothedNumbers(), 1);
        data.print(10, 2);
    }
}

