/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.util.monitor;

import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.util.monitor.Fluid;

public class StreamResponse {
    public String name;
    public Fluid fluid;
    public Double temperature;
    public Double pressure;
    public Double volumeFlow;
    public Double molarMass;
    public Double massDensity;
    public Double massflow;
    public Double massflowGas;
    public Double massflowOil;
    public Double massflowAqueous;

    public StreamResponse() {
    }

    public StreamResponse(StreamInterface inputStream) {
        this.name = inputStream.getName();
        this.fluid = new Fluid(inputStream.getFluid());
        this.temperature = inputStream.getTemperature("C");
        this.pressure = inputStream.getPressure("bara");
        this.molarMass = inputStream.getFluid().getMolarMass();
        this.massDensity = inputStream.getFluid().getDensity("kg/m3");
        this.massflow = inputStream.getFluid().getFlowRate("kg/hr");
        this.volumeFlow = inputStream.getFluid().getFlowRate("m3/hr");
        this.massflowGas = inputStream.getFluid().hasPhaseType("gas") ? Double.valueOf(inputStream.getFluid().getPhase("gas").getFlowRate("kg/hr")) : Double.valueOf(0.0);
        this.massflowAqueous = inputStream.getFluid().hasPhaseType("aqueous") ? Double.valueOf(inputStream.getFluid().getPhase("aqueous").getFlowRate("kg/hr")) : Double.valueOf(0.0);
        this.massflowOil = inputStream.getFluid().hasPhaseType("oil") ? Double.valueOf(inputStream.getFluid().getPhase("oil").getFlowRate("kg/hr")) : Double.valueOf(0.0);
    }

    public void print() {
    }
}

