/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.util.monitor;

import neqsim.processSimulation.processEquipment.pump.Pump;

public class PumpResponse {
    public String name = "test";
    public Double suctionTemperature;
    public Double dischargeTemperature;
    public Double suctionPressure;
    public Double dischargePressure;
    public Double power;
    public Double suctionVolumeFlow;
    public Double internalVolumeFlow;
    public Double dischargeVolumeFlow;
    public Double molarMass;
    public Double suctionMassDensity;
    public Double dischargeMassDensity;
    public Double massflow;
    public Integer speed;

    public PumpResponse() {
    }

    public PumpResponse(Pump inputPump) {
        this.name = inputPump.getName();
        this.molarMass = inputPump.getInletStream().getFluid().getMolarMass();
        this.suctionMassDensity = inputPump.getInletStream().getFluid().getDensity("kg/m3");
        this.dischargeMassDensity = inputPump.getOutletStream().getFluid().getDensity("kg/m3");
        this.massflow = inputPump.getInletStream().getFluid().getFlowRate("kg/hr");
        this.suctionVolumeFlow = inputPump.getInletStream().getFluid().getFlowRate("m3/hr");
        this.dischargeVolumeFlow = inputPump.getOutletStream().getFluid().getFlowRate("m3/hr");
        this.suctionPressure = inputPump.getInletStream().getPressure("bara");
        this.suctionTemperature = inputPump.getInletStream().getTemperature("C");
        this.dischargeTemperature = inputPump.getOutletStream().getTemperature("C");
        this.dischargePressure = inputPump.getOutletStream().getPressure("bara");
        this.power = inputPump.getPower("W");
    }
}

