/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.util.monitor;

import java.util.HashMap;
import java.util.Map;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.NamedBaseClass;

public class Fluid
extends NamedBaseClass {
    private static final long serialVersionUID = 1L;
    public Double volumeFlow;
    public Double molarMass;
    public Double massDensity;
    public Double massflow;
    public Map<String, Double> compProp;
    public Map<String, Map<String, Double>> definedComponent = new HashMap<String, Map<String, Double>>();
    public Map<String, Map<String, Double>> oilComponent = new HashMap<String, Map<String, Double>>();

    @Deprecated
    public Fluid() {
        this("Fluid");
    }

    public Fluid(SystemInterface inputFluid) {
        this(inputFluid.getFluidName(), inputFluid);
    }

    public Fluid(String name) {
        super(name);
    }

    public Fluid(String name, SystemInterface inputFluid) {
        this(name);
        int i = 0;
        while (i < inputFluid.getNumberOfComponents()) {
            this.compProp = new HashMap<String, Double>();
            if (inputFluid.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.compProp.put("molFraction", inputFluid.getPhase(0).getComponent(i).getz());
                this.compProp.put("massFlow", inputFluid.getPhase(0).getComponent(i).getFlowRate("kg/hr"));
                this.compProp.put("molarMass", inputFluid.getPhase(0).getComponent(i).getMolarMass());
                this.compProp.put("normalLiquidDensity", inputFluid.getPhase(0).getComponent(i).getNormalLiquidDensity());
                this.oilComponent.put(inputFluid.getPhase(0).getComponent(i).getComponentName(), this.compProp);
            } else {
                this.compProp.put("molFraction", inputFluid.getPhase(0).getComponent(i).getz());
                this.compProp.put("massFlow", inputFluid.getPhase(0).getComponent(i).getFlowRate("kg/hr"));
                this.definedComponent.put(inputFluid.getPhase(0).getComponent(i).getComponentName().replaceAll("-", ""), this.compProp);
            }
            ++i;
        }
        this.molarMass = inputFluid.getMolarMass();
        this.massDensity = inputFluid.getDensity("kg/m3");
        this.massflow = inputFluid.getFlowRate("kg/hr");
        this.volumeFlow = inputFluid.getFlowRate("m3/hr");
    }

    SystemInterface getNeqSimFluid() {
        SystemSrkEos tempFluid = new SystemSrkEos();
        this.definedComponent.keySet().forEach(key -> tempFluid.addComponent((String)key, (double)this.definedComponent.get(key).get("molFraction")));
        this.oilComponent.keySet().forEach(key -> tempFluid.addTBPfraction((String)key, this.definedComponent.get(key).get("molFraction"), this.definedComponent.get(key).get("molarMass"), this.definedComponent.get(key).get("normalLiquidDensity")));
        tempFluid.setMixingRule(2);
        return tempFluid;
    }

    public void print() {
    }
}

