/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processSystem.processModules;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.heatExchanger.Heater;
import neqsim.processSimulation.processEquipment.mixer.Mixer;
import neqsim.processSimulation.processEquipment.pump.Pump;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processEquipment.valve.ThrottlingValve;
import neqsim.processSimulation.processSystem.ProcessModuleBaseClass;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MEGReclaimerModule
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(MEGReclaimerModule.class);
    protected StreamInterface streamToReclaimer = null;
    protected StreamInterface streamToWaterRemoval = null;
    protected StreamInterface streamFromBoosterCompressor = null;
    protected StreamInterface streamWithWaste = null;
    ThrottlingValve inletValve = null;
    Mixer inletMixer = null;
    protected Separator flashSeparator = null;
    Pump MEGRecircPump = null;
    Heater MEGrecircHeater = null;
    ThrottlingValve recircValve = null;
    Heater vacumCooler = null;
    double reclaimerPressure = 0.17;

    public MEGReclaimerModule(String name) {
        super(name);
    }

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("streamToReclaimer")) {
            this.streamToReclaimer = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        if (streamName.equals("streamToWaterRemoval")) {
            return this.streamToWaterRemoval;
        }
        return null;
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
        try {
            this.streamToWaterRemoval = (Stream)this.streamToReclaimer.clone();
            this.streamToWaterRemoval.setName("Desalted MEG stream");
            this.streamFromBoosterCompressor = (Stream)this.streamToReclaimer.clone();
            this.streamFromBoosterCompressor.setName("Stream from Booster Compressor");
            this.streamWithWaste = (Stream)this.streamToReclaimer.clone();
            this.streamWithWaste.setName("Reclaimer Waste Stream");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    @Override
    public void initializeModule() {
        this.isInitializedModule = true;
        this.inletValve = new ThrottlingValve("inletValve", this.streamToReclaimer);
        this.inletValve.setOutletPressure(this.reclaimerPressure);
        this.inletValve.setIsoThermal(true);
        this.inletMixer = new Mixer("inletMixer");
        this.inletMixer.addStream(this.inletValve.getOutletStream());
        this.flashSeparator = new Separator("flashSeparator", this.inletMixer.getOutletStream());
        this.MEGRecircPump = new Pump("MEGRecircPump", this.flashSeparator.getLiquidOutStream());
        this.MEGRecircPump.setMolarFlow(50.0);
        this.MEGRecircPump.setOutletPressure(5.0);
        this.MEGrecircHeater = new Heater("MEGrecircHeater", this.MEGRecircPump.getOutletStream());
        this.MEGrecircHeater.setOutTemperature(341.9);
        this.recircValve = new ThrottlingValve("recircValve", this.MEGrecircHeater.getOutletStream());
        this.recircValve.setOutletPressure(this.reclaimerPressure);
        this.recircValve.setIsoThermal(true);
        this.inletMixer.addStream(this.recircValve.getOutletStream());
        this.vacumCooler = new Heater("vacumCooler", this.flashSeparator.getGasOutStream());
        this.getOperations().add(this.streamToReclaimer);
        this.getOperations().add(this.inletValve);
        this.getOperations().add(this.inletMixer);
        this.getOperations().add(this.flashSeparator);
        this.getOperations().add(this.MEGRecircPump);
        this.getOperations().add(this.MEGrecircHeater);
        this.getOperations().add(this.recircValve);
    }

    @Override
    public void run(UUID id) {
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        int i = 0;
        while (i < 2) {
            this.getOperations().run(id);
            this.flashSeparator.displayResult();
            System.out.println("flow to vacuum separator " + this.inletMixer.getOutletStream().getThermoSystem().getTotalNumberOfMoles());
            ++i;
        }
        this.streamToWaterRemoval = this.flashSeparator.getGasOutStream();
        this.setCalculationIdentifier(id);
    }

    public void setOperationPressure(double pressure) {
        this.reclaimerPressure = pressure;
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(303.15, 10.0);
        testSystem.addComponent("methane", 0.001);
        testSystem.addComponent("CO2", 0.001);
        testSystem.addComponent("MEG", 0.3);
        testSystem.addComponent("water", 0.7);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        Stream inletStream = new Stream("inletStream", testSystem);
        inletStream.run();
        inletStream.displayResult();
        MEGReclaimerModule reclaimer = new MEGReclaimerModule("reclaimer");
        reclaimer.addInputStream("streamToReclaimer", inletStream);
        reclaimer.setOperationPressure(0.17);
        reclaimer.run();
    }

    @Override
    public void calcDesign() {
    }

    @Override
    public void setDesign() {
    }
}

