/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import java.util.UUID;
import neqsim.processSimulation.measurementDevice.MultiPhaseMeter;
import neqsim.processSimulation.processEquipment.TwoPortEquipment;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GORfitter
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(GORfitter.class);
    double pressure = 1.01325;
    double temperature = 15.0;
    private String referenceConditions = "standard";
    private boolean fitAsGVF = false;
    private double GOR = 120.0;
    private double GVF;
    String unitT = "C";
    String unitP = "bara";

    @Deprecated
    public GORfitter() {
        super("GOR fitter");
    }

    @Deprecated
    public GORfitter(StreamInterface stream) {
        this("GORfitter", stream);
    }

    public GORfitter(String name, StreamInterface stream) {
        super(name, stream);
    }

    public double getGFV() {
        return this.GVF;
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inStream = inletStream;
        try {
            this.outStream = inletStream.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    @Override
    public double getPressure() {
        return this.pressure;
    }

    public void setPressure(double pressure, String unitP) {
        this.pressure = pressure;
        this.unitP = unitP;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature, String unitT) {
        this.temperature = temperature;
        this.unitT = unitT;
    }

    @Override
    public void run(UUID id) {
        SystemInterface tempFluid = this.inStream.getThermoSystem().clone();
        double flow = tempFluid.getFlowRate("kg/sec");
        if (this.GOR < 1.0E-15) {
            this.outStream.setThermoSystem(tempFluid);
            return;
        }
        if (flow < 1.0E-6) {
            this.outStream.setThermoSystem(tempFluid);
            return;
        }
        if (this.GOR == 0.0 && tempFluid.hasPhaseType("gas")) {
            tempFluid.removePhase(0);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
            try {
                thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
            this.outStream.setThermoSystem(tempFluid);
            return;
        }
        if (!this.getReferenceConditions().equals("actual")) {
            tempFluid.setTemperature(15.0, "C");
            tempFluid.setPressure(1.01325, "bara");
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
        try {
            thermoOps.TPflash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        if (!tempFluid.hasPhaseType("gas") || !tempFluid.hasPhaseType("oil")) {
            this.outStream = this.inStream.clone();
            return;
        }
        tempFluid.initPhysicalProperties("density");
        double currGOR = tempFluid.getPhase("gas").getCorrectedVolume() / tempFluid.getPhase("oil").getCorrectedVolume();
        if (this.fitAsGVF) {
            this.GOR = tempFluid.getPhase("oil").getCorrectedVolume() * this.getGOR() / (tempFluid.getPhase("oil").getCorrectedVolume() - tempFluid.getPhase("oil").getCorrectedVolume() * this.getGOR());
        }
        double dev = this.getGOR() / currGOR;
        double[] moleChange = new double[tempFluid.getNumberOfComponents()];
        int i = 0;
        while (i < tempFluid.getNumberOfComponents()) {
            moleChange[i] = (dev - 1.0) * tempFluid.getPhase("gas").getComponent(i).getNumberOfMolesInPhase();
            ++i;
        }
        tempFluid.init(0);
        i = 0;
        while (i < tempFluid.getNumberOfComponents()) {
            tempFluid.addComponent(i, moleChange[i]);
            ++i;
        }
        tempFluid.setPressure(this.inStream.getThermoSystem().getPressure());
        tempFluid.setTemperature(this.inStream.getThermoSystem().getTemperature());
        tempFluid.setTotalFlowRate(flow, "kg/sec");
        try {
            thermoOps.TPflash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        this.outStream.setThermoSystem(tempFluid);
        this.GVF = !tempFluid.hasPhaseType("gas") ? 0.0 : (tempFluid.hasPhaseType("gas") && tempFluid.hasPhaseType("oil") ? tempFluid.getPhase("gas").getCorrectedVolume() / (tempFluid.getPhase("oil").getCorrectedVolume() + tempFluid.getPhase("gas").getCorrectedVolume()) : Double.NaN);
        this.outStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }

    public static void main(String[] args) {
        SystemSrkEos testFluid = new SystemSrkEos(338.15, 50.0);
        testFluid.addComponent("nitrogen", 1.205);
        testFluid.addComponent("CO2", 1.34);
        testFluid.addComponent("methane", 87.974);
        testFluid.addComponent("ethane", 5.258);
        testFluid.addComponent("propane", 3.283);
        testFluid.addComponent("i-butane", 0.082);
        testFluid.addComponent("n-butane", 0.487);
        testFluid.addComponent("i-pentane", 0.056);
        testFluid.addComponent("n-pentane", 1.053);
        testFluid.addComponent("nC10", 4.053);
        testFluid.setMixingRule(2);
        testFluid.setMultiPhaseCheck(true);
        testFluid.setTemperature(90.0, "C");
        testFluid.setPressure(60.0, "bara");
        testFluid.setTotalFlowRate(1000000.0, "kg/hr");
        Stream stream_1 = new Stream("Stream1", testFluid);
        MultiPhaseMeter multiPhaseMeter = new MultiPhaseMeter("test", stream_1);
        multiPhaseMeter.setTemperature(90.0, "C");
        multiPhaseMeter.setPressure(60.0, "bara");
        GORfitter gORFItter = new GORfitter("test", stream_1);
        gORFItter.setTemperature(15.0, "C");
        gORFItter.setPressure(1.01325, "bara");
        gORFItter.setReferenceConditions("actual");
        gORFItter.setGOR(10.1);
        Stream stream_2 = new Stream("stream_2", gORFItter.getOutletStream());
        MultiPhaseMeter multiPhaseMeter2 = new MultiPhaseMeter("test", stream_2);
        multiPhaseMeter2.setTemperature(90.0, "C");
        multiPhaseMeter2.setPressure(60.0, "bara");
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(multiPhaseMeter);
        operations.add(gORFItter);
        operations.add(stream_2);
        operations.add(multiPhaseMeter2);
        operations.run();
        System.out.println("GOR " + multiPhaseMeter.getMeasuredValue("GOR"));
        System.out.println("GOR_std " + multiPhaseMeter.getMeasuredValue("GOR_std"));
        System.out.println("GOR2 " + multiPhaseMeter2.getMeasuredValue("GOR"));
        System.out.println("GOR2_std " + multiPhaseMeter2.getMeasuredValue("GOR_std"));
        System.out.println("stream_2 flow " + stream_2.getFlowRate("kg/hr"));
    }

    public double getGOR() {
        return this.GOR;
    }

    public void setGOR(double gOR) {
        this.fitAsGVF = false;
        this.GOR = gOR;
    }

    public void setGVF(double gvf) {
        this.fitAsGVF = true;
        this.GOR = gvf;
    }

    public String getReferenceConditions() {
        return this.referenceConditions;
    }

    public void setReferenceConditions(String referenceConditions) {
        this.referenceConditions = referenceConditions;
    }

    public boolean isFitAsGVF() {
        return this.fitAsGVF;
    }

    public void setFitAsGVF(boolean fitAsGVF) {
        this.fitAsGVF = fitAsGVF;
    }
}

