/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.stream;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.standards.gasQuality.Standard_ISO6976;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Stream
extends ProcessEquipmentBaseClass
implements StreamInterface,
Cloneable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Stream.class);
    protected SystemInterface thermoSystem;
    protected int streamNumber = 0;
    protected static int numberOfStreams = 0;
    private double gasQuality = 0.5;
    protected StreamInterface stream = null;

    @Deprecated
    public Stream() {
        super("Stream");
    }

    @Deprecated
    public Stream(StreamInterface stream) {
        this("Stream", stream);
    }

    @Deprecated
    public Stream(SystemInterface thermoSystem) {
        this("Stream", thermoSystem);
    }

    public Stream(String name) {
        super(name);
    }

    public Stream(String name, StreamInterface stream) {
        super(name);
        this.setStream(stream);
        this.thermoSystem = stream.getThermoSystem();
        this.streamNumber = ++numberOfStreams;
    }

    public Stream(String name, SystemInterface thermoSystem) {
        super(name);
        this.thermoSystem = thermoSystem;
        this.streamNumber = ++numberOfStreams;
    }

    public double getGasQuality() {
        return this.gasQuality;
    }

    public void setGasQuality(double gasQuality) {
        this.gasQuality = gasQuality;
    }

    @Override
    public double getHydrateEquilibriumTemperature() {
        if (!this.thermoSystem.getPhase(0).hasComponent("water")) {
            System.out.println("ny hydrate: no water in stream: " + this.name);
            return 0.0;
        }
        try {
            SystemInterface copySystem = this.thermoSystem.clone();
            copySystem.setHydrateCheck(true);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(copySystem);
            thermoOps.hydrateFormationTemperature();
            return copySystem.getTemperature();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return 0.0;
        }
    }

    public double getSolidFormationTemperature(String solidName) {
        SystemInterface copySystem = this.thermoSystem.clone();
        try {
            if (solidName.equals("hydrate")) {
                copySystem.setHydrateCheck(true);
                ThermodynamicOperations thermoOps = new ThermodynamicOperations(copySystem);
                thermoOps.hydrateFormationTemperature();
            } else {
                copySystem.setSolidPhaseCheck(false);
                copySystem.setSolidPhaseCheck(solidName);
                ThermodynamicOperations thermoOps = new ThermodynamicOperations(copySystem);
                thermoOps.freezingPointTemperatureFlash();
            }
            return copySystem.getTemperature();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return 0.0;
        }
    }

    @Override
    public Stream clone() {
        Stream clonedSystem = null;
        try {
            clonedSystem = (Stream)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.stream != null) {
            clonedSystem.setStream((Stream)this.stream.clone());
        }
        clonedSystem.thermoSystem = this.getThermoSystem().clone();
        return clonedSystem;
    }

    @Override
    public double getTemperature() {
        return this.thermoSystem.getTemperature();
    }

    @Override
    public double getTemperature(String unit) {
        return this.getFluid().getTemperature(unit);
    }

    @Override
    public double getPressure() {
        return this.thermoSystem.getPressure();
    }

    @Override
    public double getPressure(String unit) {
        return this.getFluid().getPressure(unit);
    }

    @Override
    public double getMolarRate() {
        return this.thermoSystem.getTotalNumberOfMoles();
    }

    @Override
    public void setThermoSystem(SystemInterface thermoSystem) {
        this.thermoSystem = thermoSystem;
        if (this.stream != null) {
            this.stream.setThermoSystem(thermoSystem);
        }
    }

    @Override
    public void setFluid(SystemInterface fluid) {
        this.setThermoSystem(fluid);
    }

    @Override
    public void setThermoSystemFromPhase(SystemInterface thermoSystem, String phaseTypeName) {
        if (phaseTypeName.equals("liquid")) {
            if (thermoSystem.hasPhaseType("oil") && thermoSystem.hasPhaseType("aqueous")) {
                this.thermoSystem = thermoSystem.phaseToSystem(thermoSystem.getPhaseNumberOfPhase("oil"), thermoSystem.getPhaseNumberOfPhase("aqueous"));
            } else if (thermoSystem.hasPhaseType("oil")) {
                this.thermoSystem = thermoSystem.phaseToSystem(thermoSystem.getPhaseNumberOfPhase("oil"));
            } else if (thermoSystem.hasPhaseType("aqueous")) {
                this.thermoSystem = thermoSystem.phaseToSystem(thermoSystem.getPhaseNumberOfPhase("aqueous"));
            } else {
                System.out.println("no phase of type " + phaseTypeName);
                System.out.println("...returning empty system ");
                this.setEmptyThermoSystem(thermoSystem);
            }
            return;
        }
        if (thermoSystem.hasPhaseType(phaseTypeName)) {
            this.thermoSystem = thermoSystem.phaseToSystem(phaseTypeName);
        } else {
            System.out.println("no phase of type " + phaseTypeName);
            System.out.println("...returning empty system ");
            this.setEmptyThermoSystem(thermoSystem);
        }
    }

    @Override
    public void setEmptyThermoSystem(SystemInterface thermoSystem) {
        this.thermoSystem = thermoSystem.getEmptySystemClone();
        this.thermoSystem.setNumberOfPhases(0);
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    @Override
    public void setFlowRate(double flowrate, String unit) {
        this.getFluid().setTotalFlowRate(flowrate, unit);
    }

    @Override
    public void setPressure(double pressure, String unit) {
        this.getFluid().setPressure(pressure, unit);
    }

    @Override
    public void setTemperature(double temperature, String unit) {
        this.getFluid().setTemperature(temperature, unit);
    }

    @Override
    public double getFlowRate(String unit) {
        return this.getFluid().getFlowRate(unit);
    }

    @Override
    public void runTPflash() {
        if (this.stream != null) {
            this.thermoSystem = this.stream.getThermoSystem().clone();
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.TPflash();
        this.thermoSystem.initProperties();
    }

    @Override
    public void run(UUID id) {
        if (this.stream != null) {
            this.thermoSystem = this.stream.getThermoSystem().clone();
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        if (this.stream != null && this.getThermoSystem().getNumberOfComponents() == 1 && this.getSpecification().equals("TP")) {
            this.setSpecification("PH");
        }
        if (this.getSpecification().equals("TP")) {
            thermoOps.TPflash();
        } else if (this.getSpecification().equals("dewP")) {
            try {
                thermoOps.dewPointTemperatureFlash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                thermoOps.TPflash();
            }
        } else if (this.getSpecification().equals("dewT")) {
            try {
                thermoOps.dewPointPressureFlash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                thermoOps.TPflash();
            }
        } else if (this.getSpecification().equals("gas quality")) {
            try {
                this.thermoSystem.init(0);
                this.thermoSystem.init(2);
                double gasEnthalpy = this.thermoSystem.getPhase(0).getEnthalpy();
                double liquidEnthalpy = this.thermoSystem.getPhase(1).getEnthalpy();
                double enthalpySpec = this.getGasQuality() * gasEnthalpy + (1.0 - this.getGasQuality()) * liquidEnthalpy;
                thermoOps.PHflash(enthalpySpec);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                thermoOps.TPflash();
            }
        } else if (this.getSpecification().equals("bubP")) {
            try {
                thermoOps.bubblePointTemperatureFlash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                thermoOps.TPflash();
            }
        } else if (this.getSpecification().equals("bubT")) {
            try {
                thermoOps.bubblePointPressureFlash(false);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                thermoOps.TPflash();
            }
        } else if (this.getSpecification().equals("PH")) {
            try {
                thermoOps.PHflash(this.getThermoSystem().getEnthalpy(), 0);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                thermoOps.TPflash();
            }
        } else {
            thermoOps.TPflash();
        }
        this.thermoSystem.initProperties();
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.thermoSystem.display(this.name);
    }

    @Override
    public String[][] getResultTable() {
        return this.thermoSystem.getResultTable();
    }

    @Override
    public void runTransient(double dt, UUID id) {
        if (this.hasController) {
            this.runController(dt, id);
            this.setFlowRate(this.getController().getResponse(), "kg/hr");
        }
        this.run(id);
        this.increaseTime(dt);
    }

    public void runController(double dt, UUID id) {
        if (this.hasController) {
            this.getController().runTransient(this.getFlowRate("kg/hr"), dt, id);
        }
    }

    @Override
    public void flashStream() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.thermoSystem);
        ops.TPflash();
    }

    public void phaseEnvelope() {
        SystemInterface localSyst = this.thermoSystem.clone();
        ThermodynamicOperations ops = new ThermodynamicOperations(localSyst);
        ops.setRunAsThread(true);
        ops.calcPTphaseEnvelope(true);
        ops.waitAndCheckForFinishedCalculation(10000);
        ops.displayResult();
    }

    @Override
    public double CCB(String unit) {
        SystemInterface localSyst = this.thermoSystem.clone();
        ThermodynamicOperations ops = new ThermodynamicOperations(localSyst);
        ops.setRunAsThread(true);
        ops.calcPTphaseEnvelope(true);
        ops.waitAndCheckForFinishedCalculation(10000);
        if (unit.equals("bara") || unit.equals("bar")) {
            return ops.get("cricondenbar")[1];
        }
        if (unit.equals("C")) {
            return ops.get("cricondenbar")[0] - 273.15;
        }
        return ops.get("cricondenbar")[0];
    }

    @Override
    public double CCT(String unit) {
        SystemInterface localSyst = this.thermoSystem.clone();
        ThermodynamicOperations ops = new ThermodynamicOperations(localSyst);
        ops.setRunAsThread(true);
        ops.calcPTphaseEnvelope(true);
        ops.waitAndCheckForFinishedCalculation(10000);
        if (unit.equals("bara") || unit.equals("bar")) {
            return ops.get("cricondentherm")[1];
        }
        if (unit.equals("C")) {
            return ops.get("cricondentherm")[0] - 273.15;
        }
        return ops.get("cricondentherm")[0];
    }

    @Override
    public double TVP(double temperature, String unit) {
        SystemInterface localSyst = this.thermoSystem.clone();
        localSyst.setTemperature(temperature, unit);
        ThermodynamicOperations ops = new ThermodynamicOperations(localSyst);
        try {
            ops.bubblePointPressureFlash(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localSyst.getPressure(unit);
    }

    @Override
    public String[][] reportResults() {
        return this.thermoSystem.getResultTable();
    }

    public Object getProperty(String propertyName, String unit, String phase, String component) {
        return null;
    }

    @Override
    public double GCV() {
        Standard_ISO6976 standard = new Standard_ISO6976(this.thermoSystem.clone(), 0.0, 15.55, "volume");
        standard.setReferenceState("real");
        standard.calculate();
        return standard.getValue("GCV") * 1000.0;
    }

    @Override
    public double LCV() {
        Standard_ISO6976 standard = new Standard_ISO6976(this.thermoSystem.clone(), 0.0, 15.55, "volume");
        standard.setReferenceState("real");
        standard.calculate();
        return standard.getValue("InferiorCalorificValue") * 1000.0;
    }

    public void setStream(StreamInterface stream) {
        this.stream = stream;
    }
}

