/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.splitter;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.splitter.SplitterInterface;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Splitter
extends ProcessEquipmentBaseClass
implements SplitterInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Splitter.class);
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    StreamInterface inletStream;
    StreamInterface[] splitStream;
    protected int splitNumber = 1;
    double[] splitFactor = new double[1];
    double[] flowRates;
    String flowUnit = "mole/sec";

    public Splitter() {
        super("Splitter");
    }

    @Deprecated
    public Splitter(StreamInterface inletStream) {
        this();
        this.setInletStream(inletStream);
    }

    public Splitter(String name) {
        super(name);
    }

    public Splitter(String name, StreamInterface inStream) {
        this(name);
        this.setInletStream(inStream);
    }

    public Splitter(String name, StreamInterface inletStream, int i) {
        this(name);
        this.setSplitNumber(i);
        this.setInletStream(inletStream);
    }

    @Override
    public void setSplitNumber(int i) {
        this.splitNumber = i;
        this.splitFactor = new double[this.splitNumber];
        this.splitFactor[0] = 1.0;
        this.setInletStream(this.inletStream);
    }

    public void setSplitFactors(double[] splitFact) {
        double sum = 0.0;
        int i = 0;
        while (i < splitFact.length) {
            if (splitFact[i] < 0.0) {
                splitFact[i] = 0.0;
            }
            sum += splitFact[i];
            ++i;
        }
        this.splitFactor = new double[splitFact.length];
        i = 0;
        while (i < splitFact.length) {
            this.splitFactor[i] = splitFact[i] / sum;
            ++i;
        }
        this.splitNumber = splitFact.length;
        this.setInletStream(this.inletStream);
    }

    public void setFlowRates(double[] flowRates, String flowUnit) {
        if (flowRates.length != this.splitNumber) {
            this.setInletStream(this.inletStream);
        }
        this.flowRates = flowRates;
        this.flowUnit = flowUnit;
        double sum = 0.0;
        int i = 0;
        while (i < flowRates.length) {
            if (flowRates[i] > -0.1) {
                sum += flowRates[i];
            }
            ++i;
        }
        i = 0;
        while (i < flowRates.length) {
            if (flowRates[i] < -0.1) {
                flowRates[i] = this.inletStream.getFlowRate(flowUnit) - sum;
            }
            ++i;
        }
        this.splitFactor = new double[flowRates.length];
        i = 0;
        while (i < flowRates.length) {
            this.splitFactor[i] = flowRates[i] / sum;
            ++i;
        }
        this.splitNumber = this.splitFactor.length;
        this.setInletStream(this.inletStream);
    }

    public void calcSplitFactors() {
        double sum = 0.0;
        int i = 0;
        while (i < this.splitNumber) {
            if (this.flowRates[i] > -0.1) {
                this.splitFactor[i] = this.flowRates[i] / this.inletStream.getFlowRate(this.flowUnit);
                sum += this.splitFactor[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.splitNumber) {
            if (this.flowRates[i] < -0.1) {
                this.splitFactor[i] = 1.0 - sum;
            }
            ++i;
        }
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        if (this.splitStream == null || this.splitStream.length != this.splitNumber) {
            this.splitStream = new Stream[this.splitNumber];
            try {
                int i = 0;
                while (i < this.splitNumber) {
                    this.splitStream[i] = new Stream("Split Stream", inletStream.getThermoSystem().clone());
                    ++i;
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
        }
    }

    @Override
    public StreamInterface getSplitStream(int i) {
        return this.splitStream[i];
    }

    @Override
    public void run(UUID id) {
        double totSplit = 0.0;
        if (this.flowRates != null) {
            this.calcSplitFactors();
        }
        int i = 0;
        while (i < this.splitNumber) {
            if (this.splitFactor[i] < 0.0) {
                logger.debug("split factor negative = " + this.splitFactor[i]);
                this.splitFactor[i] = 0.0;
            }
            totSplit += this.splitFactor[i];
            ++i;
        }
        if (Math.abs(totSplit - 1.0) > 1.0E-10) {
            logger.debug("total split factor different from 0 in splitter - totsplit = " + totSplit);
            logger.debug("setting first split to = " + (1.0 - totSplit));
            this.splitFactor[0] = 1.0 - totSplit;
        }
        i = 0;
        while (i < this.splitNumber) {
            this.thermoSystem = this.inletStream.getThermoSystem().clone();
            this.thermoSystem.init(0);
            this.splitStream[i].setThermoSystem(this.thermoSystem);
            int j = 0;
            while (j < this.inletStream.getThermoSystem().getPhase(0).getNumberOfComponents()) {
                int index = this.inletStream.getThermoSystem().getPhase(0).getComponent(j).getComponentNumber();
                double moles = this.inletStream.getThermoSystem().getPhase(0).getComponent(j).getNumberOfmoles();
                this.splitStream[i].getThermoSystem().addComponent(index, moles * this.splitFactor[i] - moles);
                ++j;
            }
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.splitStream[i].getThermoSystem());
            thermoOps.TPflash();
            ++i;
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
    }
}

