/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.splitter;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentSplitter
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ComponentSplitter.class);
    SystemInterface thermoSystem;
    StreamInterface inletStream;
    StreamInterface[] splitStream;
    protected int splitNumber = 1;
    double[] splitFactor = new double[1];

    public ComponentSplitter() {
        super("Component Splitter");
    }

    public ComponentSplitter(String name) {
        super(name);
    }

    public ComponentSplitter(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
    }

    public void setSplitFactors(double[] factors) {
        this.splitFactor = factors;
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.splitStream = new Stream[2];
        try {
            int i = 0;
            while (i < this.splitStream.length) {
                this.splitStream[i] = new Stream("Split Stream", inletStream.getThermoSystem().clone());
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    public StreamInterface getSplitStream(int i) {
        return this.splitStream[i];
    }

    @Override
    public void run(UUID id) {
        int i = 0;
        while (i < 2) {
            int k;
            this.thermoSystem = this.inletStream.getThermoSystem().clone();
            this.thermoSystem.setEmptyFluid();
            if (i == 0) {
                k = 0;
                while (k < this.thermoSystem.getNumberOfComponents()) {
                    this.thermoSystem.addComponent(k, this.inletStream.getThermoSystem().getComponent(k).getNumberOfmoles() * this.splitFactor[k]);
                    ++k;
                }
            } else {
                k = 0;
                while (k < this.thermoSystem.getNumberOfComponents()) {
                    this.thermoSystem.addComponent(k, this.inletStream.getThermoSystem().getComponent(k).getNumberOfmoles() * (1.0 - this.splitFactor[k]));
                    ++k;
                }
            }
            this.thermoSystem.init(0);
            this.splitStream[i].setThermoSystem(this.thermoSystem);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.splitStream[i].getThermoSystem());
            thermoOps.TPflash();
            ++i;
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
    }
}

