/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.reservoir;

import java.util.ArrayList;
import java.util.UUID;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.pipeline.AdiabaticTwoPhasePipe;
import neqsim.processSimulation.processEquipment.reservoir.Well;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class SimpleReservoir
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    double oilVolume = 0.0;
    double gasVolume = 0.0;
    double waterVolume = 0.0;
    ArrayList<Well> gasProducer = new ArrayList();
    ArrayList<Well> oilProducer = new ArrayList();
    ArrayList<Well> gasInjector = new ArrayList();
    ArrayList<Well> waterInjector = new ArrayList();
    double gasProductionTotal = 0.0;
    double oilProductionTotal = 0.0;
    double OOIP = 0.0;
    double OGIP = 0.0;
    double reservoirVolume = 0.0;
    double lowPressureLimit = 50.0;

    @Deprecated
    public SimpleReservoir() {
        this("SimpleReservoir");
    }

    public SimpleReservoir(String name) {
        super(name);
    }

    public SystemInterface getReservoirFluid() {
        return this.thermoSystem;
    }

    public StreamInterface addGasProducer(String name) {
        Well newWell = new Well(name);
        this.gasProducer.add(newWell);
        Stream gasOutStream = new Stream("gasOutStream");
        gasOutStream.setFluid(this.thermoSystem.phaseToSystem("gas"));
        gasOutStream.getFluid().setTotalFlowRate(0.1, "kg/sec");
        newWell.setStream(gasOutStream);
        return newWell.getStream();
    }

    public StreamInterface addOilProducer(String name) {
        Well newWell = new Well(name);
        this.oilProducer.add(newWell);
        Stream oilOutStream = new Stream("oilOutStream");
        oilOutStream.setFluid(this.thermoSystem.phaseToSystem("oil"));
        oilOutStream.getFluid().setTotalFlowRate(0.1, "kg/sec");
        newWell.setStream(oilOutStream);
        return newWell.getStream();
    }

    public StreamInterface addWaterInjector(String name) {
        Well newWell = new Well(name);
        this.waterInjector.add(newWell);
        Stream waterInStream = new Stream("waterInStream");
        waterInStream.setFluid(this.thermoSystem.phaseToSystem("aqueous"));
        waterInStream.getFluid().setTotalFlowRate(0.1, "kg/sec");
        newWell.setStream(waterInStream);
        return newWell.getStream();
    }

    public StreamInterface addGasInjector(String name) {
        Well newWell = new Well(name);
        this.gasInjector.add(newWell);
        Stream gasInStream = new Stream("gasInStream");
        gasInStream.setFluid(this.thermoSystem.phaseToSystem("gas"));
        gasInStream.getFluid().setTotalFlowRate(0.1, "kg/sec");
        newWell.setStream(gasInStream);
        return newWell.getStream();
    }

    public double getGasInPlace(String unit) {
        SystemInterface locStream = this.thermoSystem.clone();
        locStream.setTemperature(288.15);
        locStream.setPressure(1.01325);
        ThermodynamicOperations ops = new ThermodynamicOperations(locStream);
        ops.TPflash();
        locStream.initProperties();
        double volume = Double.NaN;
        if (locStream.hasPhaseType("gas")) {
            volume = locStream.getPhase("gas").getVolume("m3");
        }
        if (unit.equals("GSm3")) {
            return volume / 1.0E9;
        }
        return volume;
    }

    public double getOilInPlace(String unit) {
        SystemInterface locStream = this.thermoSystem.clone();
        locStream.setTemperature(288.15);
        locStream.setPressure(1.01325);
        ThermodynamicOperations ops = new ThermodynamicOperations(locStream);
        ops.TPflash();
        locStream.initProperties();
        double volume = Double.NaN;
        if (locStream.hasPhaseType("oil")) {
            volume = locStream.getPhase("oil").getVolume("m3");
        }
        if (unit.equals("MSm3")) {
            return volume / 1000000.0;
        }
        return volume;
    }

    public Well getGasProducer(int i) {
        return this.gasProducer.get(i);
    }

    public Well getOilProducer(int i) {
        return this.oilProducer.get(i);
    }

    public Well getOilProducer(String name) {
        int i = 0;
        while (i < this.oilProducer.size()) {
            if (this.oilProducer.get(i).getName().equals(name)) {
                return this.oilProducer.get(i);
            }
            ++i;
        }
        return null;
    }

    public Well getWaterInjector(int i) {
        return this.waterInjector.get(i);
    }

    public Well getGasInjector(int i) {
        return this.gasInjector.get(i);
    }

    public void setReservoirFluid(SystemInterface thermoSystem, double gasVolume, double oilVolume, double waterVolume) {
        this.thermoSystem = thermoSystem;
        this.oilVolume = oilVolume;
        this.gasVolume = gasVolume;
        this.waterVolume = waterVolume;
        ThermodynamicOperations ops = new ThermodynamicOperations(thermoSystem);
        ops.TPflash();
        SystemInterface thermoSystem2 = thermoSystem.clone();
        thermoSystem.setEmptyFluid();
        int j = 0;
        while (j < thermoSystem.getNumberOfPhases()) {
            double relFact = gasVolume / (thermoSystem2.getPhase(j).getVolume() * 1.0E-5);
            if (j >= 1) {
                if (j == 1) {
                    relFact = oilVolume / (thermoSystem2.getPhase(j).getVolume() * 1.0E-5);
                } else if (j == 2) {
                    relFact = waterVolume / (thermoSystem2.getPhase(j).getVolume() * 1.0E-5);
                }
            }
            int i = 0;
            while (i < thermoSystem.getPhase(j).getNumberOfComponents()) {
                thermoSystem.addComponent(thermoSystem.getPhase(j).getComponent(i).getComponentNumber(), relFact * thermoSystem2.getPhase(j).getComponent(i).getNumberOfMolesInPhase(), j);
                ++i;
            }
            ++j;
        }
        ThermodynamicOperations ops2 = new ThermodynamicOperations(thermoSystem);
        ops2.TPflash();
        thermoSystem.initProperties();
        this.reservoirVolume = gasVolume + oilVolume + waterVolume;
        this.OOIP = this.getOilInPlace("Sm3");
        this.OGIP = this.getGasInPlace("Sm3");
        this.lowPressureLimit = 50.0;
    }

    @Override
    public void run(UUID id) {
        System.out.println("gas volume " + this.thermoSystem.getPhase("gas").getVolume("m3"));
        System.out.println("oil volume " + this.thermoSystem.getPhase("oil").getVolume("m3"));
        System.out.println("water volume " + this.thermoSystem.getPhase("aqueous").getVolume("m3"));
        int i = 0;
        while (i < this.gasProducer.size()) {
            this.gasProducer.get(i).getStream().run(id);
            ++i;
        }
        i = 0;
        while (i < this.oilProducer.size()) {
            this.oilProducer.get(i).getStream().run(id);
            ++i;
        }
        i = 0;
        while (i < this.waterInjector.size()) {
            this.waterInjector.get(i).getStream().run(id);
            ++i;
        }
        i = 0;
        while (i < this.gasInjector.size()) {
            this.gasInjector.get(i).getStream().run(id);
            ++i;
        }
        this.setCalculationIdentifier(id);
    }

    public double GORprodution() {
        double GOR2 = 0.0;
        double flow = 0.0;
        int i = 0;
        while (i < this.gasProducer.size()) {
            flow += this.gasProducer.get(i).getStream().getFluid().getNumberOfMoles();
            GOR2 += this.gasProducer.get(i).getGOR() * this.gasProducer.get(i).getStream().getFluid().getNumberOfMoles();
            ++i;
        }
        i = 0;
        while (i < this.oilProducer.size()) {
            flow += this.oilProducer.get(i).getStream().getFluid().getNumberOfMoles();
            GOR2 += this.oilProducer.get(i).getGOR() * this.oilProducer.get(i).getStream().getFluid().getNumberOfMoles();
            ++i;
        }
        return GOR2 / flow;
    }

    public double getGasProdution(String unit) {
        double volume = 0.0;
        int i = 0;
        while (i < this.gasProducer.size()) {
            volume += this.gasProducer.get(i).getStdGasProduction();
            ++i;
        }
        i = 0;
        while (i < this.oilProducer.size()) {
            volume += this.oilProducer.get(i).getStdGasProduction();
            ++i;
        }
        if (!unit.equals("Sm3/sec") && unit.equals("Sm3/day")) {
            volume = volume * 60.0 * 60.0 * 24.0;
        }
        return volume;
    }

    public double getOilProdution(String unit) {
        double volume = 0.0;
        int i = 0;
        while (i < this.gasProducer.size()) {
            volume += this.gasProducer.get(i).getStdOilProduction();
            ++i;
        }
        i = 0;
        while (i < this.oilProducer.size()) {
            volume += this.oilProducer.get(i).getStdOilProduction();
            ++i;
        }
        if (!unit.equals("Sm3/sec") && unit.equals("Sm3/day")) {
            volume = volume * 60.0 * 60.0 * 24.0;
        }
        return volume;
    }

    @Override
    public void runTransient(double dt, UUID id) {
        int k;
        this.increaseTime(dt);
        if (this.thermoSystem.getPressure("bara") < this.lowPressureLimit) {
            System.out.println("low pressure reservoir limit reached");
            this.setCalculationIdentifier(id);
            return;
        }
        this.gasProductionTotal += this.getGasProdution("Sm3/sec") * dt;
        this.oilProductionTotal += this.getOilProdution("Sm3/sec") * dt;
        this.thermoSystem.init(0);
        int i = 0;
        while (i < this.thermoSystem.getPhase(0).getNumberOfComponents()) {
            k = 0;
            while (k < this.gasProducer.size()) {
                this.thermoSystem.addComponent(i, -this.gasProducer.get(k).getStream().getFluid().getComponent(i).getNumberOfmoles() * dt);
                ++k;
            }
            k = 0;
            while (k < this.oilProducer.size()) {
                this.thermoSystem.addComponent(i, -this.oilProducer.get(k).getStream().getFluid().getComponent(i).getNumberOfmoles() * dt);
                ++k;
            }
            k = 0;
            while (k < this.waterInjector.size()) {
                this.thermoSystem.addComponent(i, this.waterInjector.get(k).getStream().getFluid().getComponent(i).getNumberOfmoles() * dt);
                ++k;
            }
            k = 0;
            while (k < this.gasInjector.size()) {
                this.thermoSystem.addComponent(i, this.gasInjector.get(k).getStream().getFluid().getComponent(i).getNumberOfmoles() * dt);
                ++k;
            }
            ++i;
        }
        ThermodynamicOperations ops = new ThermodynamicOperations(this.thermoSystem);
        ops.TVflash(this.reservoirVolume, "m3");
        this.thermoSystem.initProperties();
        if (this.thermoSystem.hasPhaseType("gas")) {
            k = 0;
            while (k < this.gasProducer.size()) {
                this.gasProducer.get(k).getStream().getFluid().setMolarComposition(this.thermoSystem.getPhase("gas").getMolarComposition());
                this.gasProducer.get(k).getStream().run(id);
                ++k;
            }
        }
        if (this.thermoSystem.hasPhaseType("oil")) {
            k = 0;
            while (k < this.oilProducer.size()) {
                this.oilProducer.get(k).getStream().getFluid().setMolarComposition(this.thermoSystem.getPhase("oil").getMolarComposition());
                this.oilProducer.get(k).getStream().run(id);
                ++k;
            }
        }
        k = 0;
        while (k < this.waterInjector.size()) {
            this.waterInjector.get(k).getStream().run(id);
            ++k;
        }
        k = 0;
        while (k < this.gasInjector.size()) {
            this.gasInjector.get(k).getStream().run(id);
            ++k;
        }
        k = 0;
        while (k < this.gasProducer.size()) {
            this.gasProducer.get(k).getStream().getFluid().setPressure(this.thermoSystem.getPressure());
            ++k;
        }
        k = 0;
        while (k < this.oilProducer.size()) {
            this.oilProducer.get(k).getStream().getFluid().setPressure(this.thermoSystem.getPressure());
            ++k;
        }
        k = 0;
        while (k < this.waterInjector.size()) {
            this.waterInjector.get(k).getStream().setPressure(this.thermoSystem.getPressure());
            ++k;
        }
        k = 0;
        while (k < this.gasInjector.size()) {
            this.gasInjector.get(k).getStream().setPressure(this.thermoSystem.getPressure());
            ++k;
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.thermoSystem.display();
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(373.15, 200.0);
        testSystem.addComponent("nitrogen", 0.1);
        testSystem.addComponent("methane", 30.0);
        testSystem.addComponent("ethane", 1.0);
        testSystem.addComponent("propane", 1.0);
        testSystem.addComponent("i-butane", 1.0);
        testSystem.addComponent("n-butane", 1.0);
        testSystem.addComponent("n-hexane", 0.1);
        testSystem.addComponent("n-heptane", 0.1);
        testSystem.addComponent("n-nonane", 1.0);
        testSystem.addComponent("nC10", 1.0);
        testSystem.addComponent("nC12", 3.0);
        testSystem.addComponent("nC15", 3.0);
        testSystem.addComponent("nC20", 3.0);
        testSystem.addComponent("water", 11.0);
        testSystem.setMixingRule(2);
        testSystem.setMultiPhaseCheck(true);
        SimpleReservoir reservoirOps = new SimpleReservoir("Well 1 reservoir");
        reservoirOps.setReservoirFluid(testSystem, 5.0E7, 5.52E8, 1.0E7);
        StreamInterface producedOilStream = reservoirOps.addOilProducer("oilproducer_1");
        StreamInterface injectorGasStream = reservoirOps.addGasInjector("gasproducer_1");
        StreamInterface producedGasStream = reservoirOps.addGasProducer("SLP_A32562G");
        StreamInterface waterInjectorStream = reservoirOps.addWaterInjector("SLP_WI32562O");
        ProcessSystem operations = new ProcessSystem();
        operations.add(reservoirOps);
        operations.save("c:/temp/resmode1.neqsim");
        System.out.println("gas in place (GIP) " + reservoirOps.getGasInPlace("GSm3") + " GSm3");
        System.out.println("oil in place (OIP) " + reservoirOps.getOilInPlace("MSm3") + " MSm3");
        producedGasStream.setFlowRate(0.01, "MSm3/day");
        injectorGasStream.setFlowRate(0.01, "MSm3/day");
        producedOilStream.setFlowRate(5.0E7, "kg/day");
        waterInjectorStream.setFlowRate(1.21E7, "kg/day");
        reservoirOps.run();
        reservoirOps.runTransient(259200.0);
        int i = 0;
        while (i < 1) {
            reservoirOps.runTransient(1296000.0);
            System.out.println("water volume" + reservoirOps.getReservoirFluid().getPhase("aqueous").getVolume("m3") / 1000000.0);
            System.out.println("oil production  total" + reservoirOps.getOilProductionTotal("Sm3") + " Sm3");
            System.out.println("total produced  " + reservoirOps.getProductionTotal("MSm3 oe") + " MSm3 oe");
            if (reservoirOps.getFluid().getPressure() < 50.0) break;
            ++i;
        }
        System.out.println("GOR gas  " + reservoirOps.getGasProducer(0).getGOR());
        System.out.println("GOR production " + reservoirOps.GORprodution());
        System.out.println("gas production  " + reservoirOps.getGasProdution("Sm3/day") + " Sm3/day");
        System.out.println("oil production  " + reservoirOps.getOilProdution("Sm3/day") + " Sm3/day");
        System.out.println("oil production  total" + reservoirOps.getOilProductionTotal("Sm3") + " Sm3");
        System.out.println("gas production  total" + reservoirOps.getGasProductionTotal("GSm3") + " GSm3");
        System.out.println("oil production  total" + reservoirOps.getOilProductionTotal("MSm3") + " MSm3");
        System.out.println("gas in place (GIP) " + reservoirOps.getGasInPlace("GSm3") + " GSm3");
        System.out.println("oil in place (OIP) " + reservoirOps.getOilInPlace("MSm3") + " MSm3");
        System.out.println("original oil in place (OOIP) " + reservoirOps.getOOIP("MSm3") + " MSm3");
        System.out.println("original gas in place (OGIP) " + reservoirOps.getOGIP("GSm3") + " GSm3");
        i = 0;
        while (i < 300) {
            ++i;
        }
        System.out.println("oil flow " + producedOilStream.getFlowRate("kg/hr"));
        AdiabaticTwoPhasePipe testPipe = new AdiabaticTwoPhasePipe("testPipe", producedOilStream);
        testPipe.setLength(3300.0);
        testPipe.setInletElevation(0.0);
        testPipe.setOutletElevation(2200.0);
        testPipe.setDiameter(2.69);
        testPipe.setPressureOutLimit(80.0);
        testPipe.setFlowLimit(producedOilStream.getFlowRate("kg/hr") * 0.4, "kg/hr");
        testPipe.setOutTemperature(323.15);
        testPipe.run();
        System.out.println(" flow limit " + producedOilStream.getFlowRate("kg/hr") * 0.4);
        System.out.println("oil flow " + producedOilStream.getFlowRate("kg/hr"));
        int i2 = 0;
        while (i2 < 60) {
            reservoirOps.runTransient(2160000.0);
            testPipe.run();
            System.out.println("oil flow " + producedOilStream.getFlowRate("kg/hr") + " pressure " + producedOilStream.getPressure("bara") + " pipe out pres " + testPipe.getOutletStream().getFluid().getPressure());
            ++i2;
        }
    }

    public double getGasProductionTotal(String unit) {
        if (unit.equals("MSm3")) {
            return this.gasProductionTotal / 1000000.0;
        }
        if (unit.equals("GSm3")) {
            return this.gasProductionTotal / 1.0E9;
        }
        return this.gasProductionTotal;
    }

    public double getOilProductionTotal(String unit) {
        if (unit.equals("MSm3")) {
            return this.oilProductionTotal / 1000000.0;
        }
        return this.oilProductionTotal;
    }

    public double getProductionTotal(String unit) {
        double prod = this.getOilProductionTotal("Sm3") + this.getGasProductionTotal("Sm3") / 1000.0;
        if (unit.equals("MSm3 oe")) {
            return prod / 1000000.0;
        }
        return prod;
    }

    public double getOOIP(String unit) {
        if (unit.equals("MSm3")) {
            return this.OOIP / 1000000.0;
        }
        return this.OOIP;
    }

    public double getOGIP(String unit) {
        if (unit.equals("GSm3")) {
            return this.OGIP / 1.0E9;
        }
        return this.OGIP;
    }

    @Override
    public double getTime() {
        return this.time;
    }
}

