/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.compressor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SurgeCurve
implements Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SurgeCurve.class);
    double[] flow;
    double[] head;
    double[] chartConditions = null;
    private boolean isActive = false;
    final WeightedObservedPoints flowFitter = new WeightedObservedPoints();
    PolynomialFunction flowFitterFunc = null;

    public SurgeCurve() {
    }

    public SurgeCurve(double[] flow, double[] head) {
        this.flow = flow;
        this.head = head;
    }

    public void setCurve(double[] chartConditions, double[] flow, double[] head) {
        this.flow = flow;
        this.head = head;
        this.chartConditions = chartConditions;
        int i = 0;
        while (i < flow.length) {
            this.flowFitter.add(head[i], flow[i]);
            ++i;
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create(2);
        this.flowFitterFunc = new PolynomialFunction(fitter.fit(this.flowFitter.toList()));
        this.isActive = true;
    }

    public double getSurgeFlow(double head) {
        return this.flowFitterFunc.value(head);
    }

    public boolean isSurge(double head, double flow) {
        return this.getSurgeFlow(head) > flow;
    }

    boolean isActive() {
        return this.isActive;
    }

    void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.chartConditions);
        result = 31 * result + Arrays.hashCode(this.flow);
        result = 31 * result + Arrays.hashCode(this.head);
        result = 31 * result + Objects.hash(this.flowFitterFunc, this.isActive);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SurgeCurve other = (SurgeCurve)obj;
        return Arrays.equals(this.chartConditions, other.chartConditions) && Arrays.equals(this.flow, other.flow) && Objects.equals(this.flowFitterFunc, other.flowFitterFunc) && Arrays.equals(this.head, other.head) && this.isActive == other.isActive;
    }
}

