/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.mechanicalDesign.designStandards;

import java.sql.ResultSet;
import neqsim.processSimulation.mechanicalDesign.MechanicalDesign;
import neqsim.processSimulation.mechanicalDesign.designStandards.DesignStandard;
import neqsim.processSimulation.processEquipment.separator.SeparatorInterface;
import neqsim.util.database.NeqSimTechnicalDesignDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SeparatorDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SeparatorDesignStandard.class);
    double gasLoadFactor = 0.11;
    private double Fg = 0.8;
    private double volumetricDesignFactor = 1.0;

    public double getFg() {
        return this.Fg;
    }

    public void setFg(double Fg) {
        this.Fg = Fg;
    }

    public SeparatorDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
        NeqSimTechnicalDesignDatabase database = new NeqSimTechnicalDesignDatabase();
        ResultSet dataSet = null;
        try {
            try {
                try {
                    dataSet = database.getResultSet("SELECT * FROM technicalrequirements_process WHERE EQUIPMENTTYPE='Separator' AND Company='" + this.standardName + "'");
                    while (dataSet.next()) {
                        String specName = dataSet.getString("SPECIFICATION");
                        if (specName.equals("GasLoadFactor")) {
                            this.gasLoadFactor = (Double.parseDouble(dataSet.getString("MAXVALUE")) + Double.parseDouble(dataSet.getString("MINVALUE"))) / 2.0;
                        }
                        if (specName.equals("Fg")) {
                            this.Fg = (Double.parseDouble(dataSet.getString("MAXVALUE")) + Double.parseDouble(dataSet.getString("MINVALUE"))) / 2.0;
                        }
                        if (!specName.equals("VolumetricDesignFactor")) continue;
                        this.volumetricDesignFactor = (Double.parseDouble(dataSet.getString("MAXVALUE")) + Double.parseDouble(dataSet.getString("MINVALUE"))) / 2.0;
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception ex2) {
                    System.out.println("error closing database.....GasScrubberDesignStandard");
                    logger.error(ex2.getMessage());
                }
            }
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception ex) {
                System.out.println("error closing database.....GasScrubberDesignStandard");
                logger.error(ex.getMessage());
            }
        }
    }

    public double getGasLoadFactor() {
        if (this.standardName.equals("StatoilTR")) {
            return this.gasLoadFactor;
        }
        return this.gasLoadFactor;
    }

    public double getVolumetricDesignFactor() {
        if (this.standardName.equals("StatoilTR")) {
            return this.volumetricDesignFactor;
        }
        return this.volumetricDesignFactor;
    }

    public void setVolumetricDesignFactor(double volumetricDesignFactor) {
        this.volumetricDesignFactor = volumetricDesignFactor;
    }

    public double getLiquidRetentionTime(String name, MechanicalDesign equipmentInn) {
        double retTime = 90.0;
        double dens = ((SeparatorInterface)((Object)equipmentInn.getProcessEquipment())).getThermoSystem().getPhase(1).getPhysicalProperties().getDensity() / 1000.0;
        if (name.equals("API12J")) {
            if (dens < 0.85) {
                retTime = 60.0;
            } else if (dens > 0.93) {
                retTime = 180.0;
            }
        }
        return retTime;
    }
}

