/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.mechanicalDesign.designStandards;

import java.sql.ResultSet;
import neqsim.processSimulation.mechanicalDesign.MechanicalDesign;
import neqsim.processSimulation.mechanicalDesign.designStandards.DesignStandard;
import neqsim.util.database.NeqSimTechnicalDesignDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PipelineDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PipelineDesignStandard.class);
    double safetyFactor = 1.0;

    public PipelineDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
        NeqSimTechnicalDesignDatabase database = new NeqSimTechnicalDesignDatabase();
        ResultSet dataSet = null;
        try {
            try {
                try {
                    dataSet = database.getResultSet("SELECT * FROM technicalrequirements_process WHERE EQUIPMENTTYPE='Pipeline' AND Company='" + this.standardName + "'");
                    while (dataSet.next()) {
                        String specName = dataSet.getString("SPECIFICATION");
                        if (!specName.equals("safetyFactor")) continue;
                        this.safetyFactor = Double.parseDouble(dataSet.getString("MAXVALUE"));
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception ex2) {
                    System.out.println("error closing database.....GasScrubberDesignStandard");
                    logger.error(ex2.getMessage());
                }
            }
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception ex) {
                System.out.println("error closing database.....GasScrubberDesignStandard");
                logger.error(ex.getMessage());
            }
        }
    }

    public double calcPipelineWallThickness() {
        if (this.standardName.equals("StatoilTR")) {
            return 0.11 * this.safetyFactor;
        }
        return 0.01;
    }
}

