/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.mechanicalDesign.designStandards;

import java.sql.ResultSet;
import neqsim.processSimulation.mechanicalDesign.MechanicalDesign;
import neqsim.processSimulation.mechanicalDesign.designStandards.DesignStandard;
import neqsim.util.database.NeqSimTechnicalDesignDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaterialPipeDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(MaterialPipeDesignStandard.class);
    String grade = "";
    String specName = "";
    String specificationNumber = "";
    private double minimumYeildStrength = 241.31650515;
    private double designFactor = 0.8;
    private double Efactor = 1.0;
    private double temperatureDeratingFactor = 1.0;

    public MaterialPipeDesignStandard() {
    }

    public MaterialPipeDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
        this.readMaterialDesignStandard("Carbon Steel Pipe", "A25");
    }

    public double getDesignFactor() {
        return this.designFactor;
    }

    public void setDesignFactor(double designFactor) {
        this.designFactor = designFactor;
    }

    public double getEfactor() {
        return this.Efactor;
    }

    public void setEfactor(double Efactor) {
        this.Efactor = Efactor;
    }

    public double getTemperatureDeratingFactor() {
        return this.temperatureDeratingFactor;
    }

    public void setTemperatureDeratingFactor(double temperatureDeratingFactor) {
        this.temperatureDeratingFactor = temperatureDeratingFactor;
    }

    public double getMinimumYeildStrength() {
        return this.minimumYeildStrength;
    }

    public void setMinimumYeildStrength(double minimumYeildStrength) {
        this.minimumYeildStrength = minimumYeildStrength;
    }

    public void readMaterialDesignStandard(String specNo, String grade) {
        this.grade = grade;
        this.specificationNumber = specNo;
        NeqSimTechnicalDesignDatabase database = new NeqSimTechnicalDesignDatabase();
        ResultSet dataSet = null;
        try {
            try {
                try {
                    dataSet = database.getResultSet("SELECT * FROM materialpipeproperties WHERE specificationNumber='" + this.specificationNumber + "' AND grade='" + grade + "'");
                    while (dataSet.next()) {
                        this.minimumYeildStrength = Double.parseDouble(dataSet.getString("minimumYeildStrength")) * 0.00689475729;
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception ex2) {
                    System.out.println("error closing database.....GasScrubberDesignStandard");
                    logger.error(ex2.getMessage());
                }
            }
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception ex) {
                System.out.println("error closing database.....GasScrubberDesignStandard");
                logger.error(ex.getMessage());
            }
        }
    }
}

