/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.mechanicalDesign.designStandards;

import java.sql.ResultSet;
import neqsim.processSimulation.mechanicalDesign.MechanicalDesign;
import neqsim.processSimulation.mechanicalDesign.designStandards.DesignStandard;
import neqsim.util.database.NeqSimTechnicalDesignDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdsorptionDehydrationDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(AdsorptionDehydrationDesignStandard.class);
    private double molecularSieveWaterCapacity = 20.0;

    public AdsorptionDehydrationDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
        NeqSimTechnicalDesignDatabase database = new NeqSimTechnicalDesignDatabase();
        ResultSet dataSet = null;
        try {
            try {
                try {
                    dataSet = database.getResultSet("SELECT * FROM technicalrequirements_process WHERE EQUIPMENTTYPE='Adsorber Dehydration' AND Company='" + this.standardName + "'");
                    while (dataSet.next()) {
                        String specName = dataSet.getString("SPECIFICATION");
                        if (!specName.equals("MolecularSieve3AWaterCapacity")) continue;
                        this.molecularSieveWaterCapacity = Double.parseDouble(dataSet.getString("MAXVALUE"));
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception ex2) {
                    System.out.println("error closing database.....GasScrubberDesignStandard");
                    logger.error(ex2.getMessage());
                }
            }
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception ex) {
                System.out.println("error closing database.....GasScrubberDesignStandard");
                logger.error(ex.getMessage());
            }
        }
    }

    public double getMolecularSieveWaterCapacity() {
        return this.molecularSieveWaterCapacity;
    }

    public void setMolecularSieveWaterCapacity(double molecularSieveWaterCapacity) {
        this.molecularSieveWaterCapacity = molecularSieveWaterCapacity;
    }
}

