/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.mechanicalDesign.compressor;

import java.awt.BorderLayout;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.processSimulation.costEstimation.compressor.CompressorCostEstimate;
import neqsim.processSimulation.mechanicalDesign.MechanicalDesign;
import neqsim.processSimulation.mechanicalDesign.designStandards.CompressorDesignStandard;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.compressor.Compressor;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.separator.SeparatorInterface;

public class CompressorMechanicalDesign
extends MechanicalDesign {
    private static final long serialVersionUID = 1000L;
    double compressorFactor = 0.0;

    public CompressorMechanicalDesign(ProcessEquipmentInterface equipment) {
        super(equipment);
        this.costEstimate = new CompressorCostEstimate(this);
    }

    @Override
    public void readDesignSpecifications() {
        super.readDesignSpecifications();
        if (this.getDesignStandard().containsKey("compressor design codes")) {
            System.out.println("compressor code standard: " + this.getDesignStandard().get("compressor design codes").getStandardName());
            this.compressorFactor = ((CompressorDesignStandard)this.getDesignStandard().get("compressor design codes")).getCompressorFactor();
        } else {
            System.out.println("no pressure vessel code standard specified......");
        }
    }

    @Override
    public void displayResults() {
        JFrame dialog = new JFrame("Unit design " + this.getProcessEquipment().getName());
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[]{"Name", "Value", "Unit"};
        Object[][] table = new String[16][3];
        table[1][0] = "Separator Inner Diameter";
        table[1][1] = Double.toString(this.getInnerDiameter());
        table[1][2] = "m";
        table[2][0] = "Separator TanTan Length";
        table[2][1] = Double.toString(this.getTantanLength());
        table[2][2] = "m";
        table[3][0] = "Wall thickness";
        table[3][1] = Double.toString(this.getWallThickness());
        table[3][2] = "m";
        table[4][0] = "Empty Vessel Weight Weight";
        table[4][1] = Double.toString(this.getWeigthVesselShell());
        table[4][2] = "kg";
        table[5][0] = "Internals+Nozzle Weight";
        table[5][1] = Double.toString(this.getWeigthInternals());
        table[5][2] = "kg";
        table[8][0] = "Module Length";
        table[8][1] = Double.toString(this.getModuleLength());
        table[8][2] = "m";
        table[9][0] = "Module Height";
        table[9][1] = Double.toString(this.getModuleHeight());
        table[9][2] = "m";
        table[10][0] = "Module Width";
        table[10][1] = Double.toString(this.getModuleWidth());
        table[10][2] = "m";
        table[11][0] = "Module Total Weight";
        table[11][1] = Double.toString(this.getWeightTotal());
        table[11][2] = "kg";
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.setSize(800, 600);
        dialog.setVisible(true);
    }

    @Override
    public void calcDesign() {
        super.calcDesign();
        Compressor compressor = (Compressor)this.getProcessEquipment();
        double Fg = 1.0;
        double emptyVesselWeight = 0.0;
        double internalsWeight = 0.0;
        double externalNozzelsWeight = 0.0;
        double pipingWeight = 0.0;
        double structualWeight = 0.0;
        double electricalWeight = 0.0;
        double totalSkidWeight = 0.0;
        double materialsCost = 0.0;
        double maxGasVelocity = 1.0;
        this.innerDiameter = Math.sqrt(4.0 * this.getMaxDesignVolumeFlow() / (3.14159265 * maxGasVelocity * Fg));
        this.tantanLength = this.innerDiameter * 5.0;
        System.out.println("inner Diameter " + this.innerDiameter);
        double Ar = 1.0;
        double Daim = Math.sqrt(Ar / 4.0);
        double Length2 = 4.0 * Daim;
        if (Daim > this.innerDiameter) {
            this.innerDiameter = Daim;
            this.tantanLength = Length2;
        }
        emptyVesselWeight = 0.032 * this.getWallThickness() * 1000.0 * this.innerDiameter * 1000.0 * this.tantanLength;
        System.out.println("internal weight " + internalsWeight);
        externalNozzelsWeight = 0.0;
        double Wv = emptyVesselWeight + internalsWeight + externalNozzelsWeight;
        pipingWeight = Wv * 0.4;
        structualWeight = Wv * 0.1;
        electricalWeight = Wv * 0.08;
        totalSkidWeight = Wv + pipingWeight + structualWeight + electricalWeight;
        materialsCost = totalSkidWeight / 1000.0 * 6000.0 / 1000.0;
        this.moduleWidth = this.innerDiameter * 2.0;
        this.moduleLength = this.innerDiameter * 2.5;
        this.moduleLength = this.tantanLength * 1.5;
        this.moduleHeight = this.innerDiameter * 2.0;
        this.setOuterDiameter(this.innerDiameter + 2.0 * this.getWallThickness());
        System.out.println("wall thickness: " + compressor.getName() + " " + this.getWallThickness() + " m");
        System.out.println("separator dry weigth: " + emptyVesselWeight + " kg");
        System.out.println("total skid weigth: " + totalSkidWeight + " kg");
        System.out.println("foot print: width:" + this.moduleWidth + " length " + this.moduleLength + " height " + this.moduleHeight + " meter.");
        System.out.println("mechanical price: " + materialsCost + " kNOK");
        this.setWeigthVesselShell(emptyVesselWeight);
        this.tantanLength = this.innerDiameter * 5.0;
        this.setInnerDiameter(this.innerDiameter);
        this.setWeightElectroInstrument(electricalWeight);
        this.setWeightNozzle(externalNozzelsWeight);
        this.setWeightPiping(pipingWeight);
        this.setWeightStructualSteel(structualWeight);
        this.setWeightTotal(totalSkidWeight);
        this.setWeigthInternals(internalsWeight);
        this.setWallThickness(this.wallThickness);
        this.setModuleHeight(this.moduleHeight);
        this.setModuleWidth(this.moduleWidth);
        this.setModuleLength(this.moduleLength);
    }

    @Override
    public void setDesign() {
        ((SeparatorInterface)((Object)this.getProcessEquipment())).setInternalDiameter(this.innerDiameter);
        ((Separator)this.getProcessEquipment()).setSeparatorLength(this.tantanLength);
    }

    @Override
    public double getOuterDiameter() {
        return this.outerDiameter;
    }

    @Override
    public double getWallThickness() {
        return this.wallThickness;
    }

    @Override
    public void setWallThickness(double wallThickness) {
        this.wallThickness = wallThickness;
    }

    @Override
    public void setOuterDiameter(double outerDiameter) {
        this.outerDiameter = outerDiameter;
    }
}

