/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.measurementDevice.simpleFlowRegime;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class FluidSevereSlug {
    private double liqDensity = 1000.0;
    private double liqVisc = 0.001;
    private double molecularWeight = 0.029;
    private double gasConstant = 8314.0 / this.molecularWeight * 1000.0;
    private double oilDensity = 0.0;
    private double waterDensity = 0.0;
    private double waterWtFraction = 0.0;
    private double oilViscosity = 0.0;
    private double waterViscosity = 0.0;
    private double oilWtFraction = 0.0;
    private int phaseNumber;

    FluidSevereSlug(SystemInterface fluid) {
        ThermodynamicOperations ops = new ThermodynamicOperations(fluid);
        ops.TPflash();
        fluid.initProperties();
        if (fluid.getNumberOfPhases() < 2) {
            System.out.println("There is only one phase");
        }
        if (fluid.hasPhaseType("oil")) {
            this.phaseNumber = fluid.getPhaseNumberOfPhase("oil");
            this.oilDensity = fluid.getPhase("oil").getDensity("kg/m3");
            this.oilViscosity = fluid.getPhase("oil").getViscosity("kg/msec");
            this.oilWtFraction = fluid.getWtFraction(this.phaseNumber) * 100.0;
        }
        if (fluid.hasPhaseType("aqueous")) {
            this.phaseNumber = fluid.getPhaseNumberOfPhase("aqueous");
            this.waterDensity = fluid.getPhase("aqueous").getDensity("kg/m3");
            this.waterViscosity = fluid.getPhase("aqueous").getViscosity("kg/msec");
            this.waterWtFraction = fluid.getWtFraction(this.phaseNumber) * 100.0;
        }
        this.liqDensity = this.waterWtFraction / 100.0 * this.waterDensity + this.oilWtFraction / 100.0 * this.oilDensity;
        this.liqVisc = this.waterWtFraction / 100.0 * this.waterViscosity + this.oilWtFraction / 100.0 * this.oilViscosity;
        this.molecularWeight = fluid.getPhase("gas").getMolarMass();
    }

    FluidSevereSlug(double liqDensity, double liqVisc, double molecularWeight) {
        this.setLiqDensity(liqDensity);
        this.setLiqVisc(liqVisc);
        this.setMolecularWeight(molecularWeight);
        this.gasConstant = 8314.0 / (molecularWeight * 1000.0);
    }

    public void setLiqDensity(double liqDensity) {
        this.liqDensity = liqDensity;
    }

    public double getLiqDensity() {
        return this.liqDensity;
    }

    public void setLiqVisc(double liqVisc) {
        this.liqVisc = liqVisc;
    }

    public double getliqVisc() {
        return this.liqVisc;
    }

    public void setMolecularWeight(double molecularWeight) {
        this.molecularWeight = molecularWeight;
    }

    public double getMolecularWeight() {
        return this.molecularWeight;
    }

    public double getGasConstant() {
        return this.gasConstant;
    }
}

