/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.measurementDevice;

import neqsim.processSimulation.measurementDevice.MeasurementDeviceBaseClass;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.processSimulation.util.monitor.WellAllocatorResponse;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;

public class WellAllocator
extends MeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1L;
    protected StreamInterface wellStream = null;
    protected StreamInterface exportGasStream = null;
    protected StreamInterface exportOilStream = null;

    public WellAllocator() {
        this.name = "Well Allocator";
    }

    public WellAllocator(StreamInterface stream) {
        this.name = "Well Allocator";
        this.wellStream = stream;
    }

    public WellAllocator(String streamname, StreamInterface stream) {
        this(stream);
        this.name = streamname;
    }

    public void setExportGasStream(StreamInterface stream) {
        this.exportGasStream = stream;
    }

    public void setExportOilStream(StreamInterface stream) {
        this.exportOilStream = stream;
    }

    @Override
    public double getMeasuredValue() {
        return this.wellStream.getThermoSystem().getFlowRate("kg/hr");
    }

    @Override
    public double getMeasuredValue(String measurement) {
        int numberOfComps = this.wellStream.getThermoSystem().getNumberOfComponents();
        double[] splitFactors = new double[numberOfComps];
        double gasExportFlow = 0.0;
        double oilExportFlow = 0.0;
        int i = 0;
        while (i < numberOfComps) {
            splitFactors[i] = this.exportGasStream.getFluid().getComponent(i).getFlowRate("kg/hr") / (this.exportGasStream.getFluid().getComponent(i).getFlowRate("kg/hr") + this.exportOilStream.getFluid().getComponent(i).getFlowRate("kg/hr"));
            gasExportFlow += this.wellStream.getFluid().getComponent(i).getTotalFlowRate("kg/hr") * splitFactors[i];
            oilExportFlow += this.wellStream.getFluid().getComponent(i).getTotalFlowRate("kg/hr") * (1.0 - splitFactors[i]);
            ++i;
        }
        if (measurement.equals("gas export rate")) {
            return gasExportFlow;
        }
        if (measurement.equals("oil export rate")) {
            return oilExportFlow;
        }
        if (measurement.equals("total export rate")) {
            return this.wellStream.getFluid().getFlowRate("kg/hr");
        }
        return 0.0;
    }

    public static void main(String[] args) {
        SystemSrkEos testFluid = new SystemSrkEos(338.15, 50.0);
        testFluid.addComponent("nitrogen", 1.205);
        testFluid.addComponent("CO2", 1.34);
        testFluid.addComponent("methane", 87.974);
        testFluid.addComponent("ethane", 5.258);
        testFluid.addComponent("propane", 3.283);
        testFluid.addComponent("i-butane", 0.082);
        testFluid.addComponent("n-butane", 0.487);
        testFluid.addComponent("i-pentane", 0.056);
        testFluid.addComponent("n-pentane", 1.053);
        testFluid.addComponent("nC10", 14.053);
        testFluid.setMixingRule(2);
        testFluid.setTemperature(24.0, "C");
        testFluid.setPressure(48.0, "bara");
        testFluid.setTotalFlowRate(2500.0, "kg/hr");
        Stream stream_1 = new Stream("Stream1", testFluid);
        SystemInterface testFluid2 = testFluid.clone();
        Stream stream_2 = new Stream("Stream2", testFluid2);
        Separator sep1 = new Separator("sep1", stream_1);
        sep1.addStream(stream_2);
        Stream stream_gasExp = new Stream("gasexp", sep1.getGasOutStream());
        Stream stream_oilExp = new Stream("gasexp", sep1.getLiquidOutStream());
        WellAllocator wellAlloc = new WellAllocator("alloc", stream_1);
        wellAlloc.setExportGasStream(stream_gasExp);
        wellAlloc.setExportOilStream(stream_oilExp);
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(stream_2);
        operations.add(sep1);
        operations.add(stream_gasExp);
        operations.add(stream_oilExp);
        operations.add(wellAlloc);
        operations.run();
        WellAllocatorResponse responsAl = new WellAllocatorResponse(wellAlloc);
        System.out.println("name " + responsAl.name);
        System.out.println("gas flow " + responsAl.gasExportRate);
        System.out.println("oil flow " + responsAl.oilExportRate);
        System.out.println("total flow " + responsAl.totalExportRate);
    }
}

