/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompViscosity.linearLiquidModel;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompViscosity.linearLiquidModel.ViscosityFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.database.NeqSimExperimentDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestViscosityFit {
    static Logger logger = LogManager.getLogger(TestViscosityFit.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimExperimentDatabase database = new NeqSimExperimentDatabase();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ResultSet dataSet = database.getResultSet("SELECT * FROM purecomponentviscosity WHERE ComponentName='MEG' ORDER BY Temperature");){
                while (dataSet.next()) {
                    ViscosityFunction function = new ViscosityFunction();
                    double[] guess = new double[]{-10.14, 3868.803, -0.00550507};
                    function.setInitialGuess(guess);
                    SystemSrkEos testSystem = new SystemSrkEos(280.0, 0.001);
                    testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                    testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                    testSystem.createDatabase(true);
                    testSystem.setMixingRule(2);
                    double temp = Double.parseDouble(dataSet.getString("Temperature"));
                    testSystem.setTemperature(temp);
                    testSystem.init(0);
                    double[] sample1 = new double[]{temp};
                    double[] standardDeviation1 = new double[]{0.1};
                    SampleValue sample = new SampleValue(Double.parseDouble(dataSet.getString("Viscosity")), Double.parseDouble(dataSet.getString("StdDev")), sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sampleList.add(sample);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.setMaxNumberOfIterations(100);
        optim.solve();
        optim.displayCurveFit();
    }
}

