/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompDensity.pureComponentRacketVolumeCorrectionParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompDensity.pureComponentRacketVolumeCorrectionParameterFitting.RacketFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestRacketFit {
    static Logger logger = LogManager.getLogger(TestRacketFit.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ResultSet dataSet = database.getResultSet("SELECT * FROM purecomponentdensity WHERE ComponentName='MEG'");){
                logger.info("adding....");
                while (dataSet.next()) {
                    RacketFunction function = new RacketFunction();
                    double[] guess = new double[]{0.3211};
                    function.setInitialGuess(guess);
                    SystemSrkEos testSystem = new SystemSrkEos(280.0, 0.001);
                    testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                    testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                    testSystem.init(0);
                    testSystem.setMixingRule(2);
                    double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                    double[] standardDeviation1 = new double[]{0.1};
                    SampleValue sample = new SampleValue(Double.parseDouble(dataSet.getString("Density")), Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sampleList.add(sample);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToTextFile("c:/testFit.txt");
    }
}

