/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.conductivity;

import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.LiquidPhysicalPropertyMethod;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.ConductivityInterface;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Conductivity
extends LiquidPhysicalPropertyMethod
implements ConductivityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Conductivity.class);
    double conductivity = 0.0;
    public double[] pureComponentConductivity;

    public Conductivity() {
    }

    public Conductivity(PhysicalPropertiesInterface liquidPhase) {
        super(liquidPhase);
        this.pureComponentConductivity = new double[liquidPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public Conductivity clone() {
        Conductivity properties = null;
        try {
            properties = (Conductivity)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    @Override
    public double calcConductivity() {
        this.calcPureComponentConductivity();
        this.conductivity = 0.0;
        int i = 0;
        while (i < this.liquidPhase.getPhase().getNumberOfComponents()) {
            int j = 0;
            while (j < this.liquidPhase.getPhase().getNumberOfComponents()) {
                ++j;
            }
            double wigthFraci = this.liquidPhase.getPhase().getWtFrac(i);
            this.conductivity += wigthFraci * this.pureComponentConductivity[i];
            ++i;
        }
        return this.conductivity;
    }

    public void calcPureComponentConductivity() {
        int i = 0;
        while (i < this.liquidPhase.getPhase().getNumberOfComponents()) {
            this.pureComponentConductivity[i] = this.liquidPhase.getPhase().getComponents()[i].getLiquidConductivityParameter(0) + this.liquidPhase.getPhase().getComponents()[i].getLiquidConductivityParameter(1) * this.liquidPhase.getPhase().getTemperature() + this.liquidPhase.getPhase().getComponents()[i].getLiquidConductivityParameter(2) * Math.pow(this.liquidPhase.getPhase().getTemperature(), 2.0);
            if (this.pureComponentConductivity[i] < 0.0) {
                this.pureComponentConductivity[i] = 1.0E-10;
            }
            ++i;
        }
    }
}

