/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties.diffusivity;

import neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties.GasPhysicalPropertyMethod;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.DiffusivityInterface;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Diffusivity
extends GasPhysicalPropertyMethod
implements DiffusivityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Diffusivity.class);
    double[][] binaryDiffusionCoefficients;
    double[][] binaryLennardJonesOmega;
    double[] effectiveDiffusionCoefficient;

    public Diffusivity() {
    }

    public Diffusivity(PhysicalPropertiesInterface gasPhase) {
        super(gasPhase);
        this.binaryDiffusionCoefficients = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        this.binaryLennardJonesOmega = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        this.effectiveDiffusionCoefficient = new double[gasPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public Diffusivity clone() {
        Diffusivity properties = null;
        try {
            properties = (Diffusivity)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        properties.binaryDiffusionCoefficients = (double[][])this.binaryDiffusionCoefficients.clone();
        int i = 0;
        while (i < this.gasPhase.getPhase().getNumberOfComponents()) {
            System.arraycopy(this.binaryDiffusionCoefficients[i], 0, properties.binaryDiffusionCoefficients[i], 0, this.gasPhase.getPhase().getNumberOfComponents());
            ++i;
        }
        return properties;
    }

    @Override
    public double calcBinaryDiffusionCoefficient(int i, int j, int method) {
        double A2 = 1.06036;
        double B2 = 0.1561;
        double C2 = 0.193;
        double D2 = 0.47635;
        double E2 = 1.03587;
        double F2 = 1.52996;
        double G2 = 1.76474;
        double H2 = 3.89411;
        double tempVar2 = this.gasPhase.getPhase().getTemperature() / this.binaryEnergyParameter[i][j];
        this.binaryLennardJonesOmega[i][j] = A2 / Math.pow(tempVar2, B2) + C2 / Math.exp(D2 * tempVar2) + E2 / Math.exp(F2 * tempVar2) + G2 / Math.exp(H2 * tempVar2);
        this.binaryDiffusionCoefficients[i][j] = 0.00266 * Math.pow(this.gasPhase.getPhase().getTemperature(), 1.5) / (this.gasPhase.getPhase().getPressure() * Math.sqrt(this.binaryMolecularMass[i][j]) * Math.pow(this.binaryMolecularDiameter[i][j], 2.0) * this.binaryLennardJonesOmega[i][j]);
        double[] dArray = this.binaryDiffusionCoefficients[i];
        int n = j;
        double d = dArray[n] * 1.0E-4;
        dArray[n] = d;
        return d;
    }

    @Override
    public double[][] calcDiffusionCoefficients(int binaryDiffusionCoefficientMethod, int multicomponentDiffusionMethod) {
        int i = 0;
        while (i < this.gasPhase.getPhase().getNumberOfComponents()) {
            int j = i;
            while (j < this.gasPhase.getPhase().getNumberOfComponents()) {
                this.binaryDiffusionCoefficients[i][j] = this.calcBinaryDiffusionCoefficient(i, j, binaryDiffusionCoefficientMethod);
                this.binaryDiffusionCoefficients[j][i] = this.binaryDiffusionCoefficients[i][j];
                ++j;
            }
            ++i;
        }
        if (multicomponentDiffusionMethod != 0) {
            // empty if block
        }
        return this.binaryDiffusionCoefficients;
    }

    @Override
    public void calcEffectiveDiffusionCoefficients() {
        double sum = 0.0;
        int i = 0;
        while (i < this.gasPhase.getPhase().getNumberOfComponents()) {
            sum = 0.0;
            int j = 0;
            while (j < this.gasPhase.getPhase().getNumberOfComponents()) {
                if (i != j) {
                    sum += this.gasPhase.getPhase().getComponents()[j].getx() / this.binaryDiffusionCoefficients[i][j];
                }
                ++j;
            }
            this.effectiveDiffusionCoefficient[i] = (1.0 - this.gasPhase.getPhase().getComponents()[i].getx()) / sum;
            ++i;
        }
    }

    @Override
    public double getFickBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }

    @Override
    public double getEffectiveDiffusionCoefficient(int i) {
        return this.effectiveDiffusionCoefficient[i];
    }

    @Override
    public double getMaxwellStefanBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }
}

