/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties.density;

import neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties.GasPhysicalPropertyMethod;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.DensityInterface;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Density
extends GasPhysicalPropertyMethod
implements DensityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Density.class);

    public Density() {
    }

    public Density(PhysicalPropertiesInterface gasPhase) {
        this.gasPhase = gasPhase;
    }

    @Override
    public Density clone() {
        Density properties = null;
        try {
            properties = (Density)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    @Override
    public double calcDensity() {
        double tempVar = 0.0;
        if (this.gasPhase.getPhase().useVolumeCorrection()) {
            int i = 0;
            while (i < this.gasPhase.getPhase().getNumberOfComponents()) {
                tempVar += this.gasPhase.getPhase().getComponents()[i].getx() * this.gasPhase.getPhase().getComponents()[i].getVolumeCorrection();
                ++i;
            }
        }
        return 1.0 / (this.gasPhase.getPhase().getMolarVolume() - tempVar) * this.gasPhase.getPhase().getMolarMass() * 100000.0;
    }
}

