/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.viscosity;

import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.CommonPhysicalPropertyMethod;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.ViscosityInterface;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class Viscosity
extends CommonPhysicalPropertyMethod
implements ViscosityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Viscosity.class);
    public double[] pureComponentViscosity;

    public Viscosity() {
    }

    public Viscosity(PhysicalPropertiesInterface phase) {
        super(phase);
        this.pureComponentViscosity = new double[phase.getPhase().getNumberOfComponents()];
    }

    public void calcPureComponentViscosity() {
        this.pureComponentViscosity = new double[this.phase.getPhase().getNumberOfComponents()];
        int i = 0;
        while (i < this.phase.getPhase().getNumberOfComponents()) {
            if (this.phase.getPhase().getTemperature() > this.phase.getPhase().getComponents()[i].getTC()) {
                this.pureComponentViscosity[i] = 0.5;
            } else if (this.phase.getPhase().getComponents()[i].getLiquidViscosityModel() == 1) {
                this.pureComponentViscosity[i] = this.phase.getPhase().getComponents()[i].getLiquidViscosityParameter(0) * Math.pow(this.phase.getPhase().getTemperature(), this.phase.getPhase().getComponents()[i].getLiquidViscosityParameter(1));
            } else if (this.phase.getPhase().getComponents()[i].getLiquidViscosityModel() != 2) {
                this.pureComponentViscosity[i] = this.phase.getPhase().getComponents()[i].getLiquidViscosityModel() == 3 ? Math.exp(this.phase.getPhase().getComponents()[i].getLiquidViscosityParameter(0) + this.phase.getPhase().getComponents()[i].getLiquidViscosityParameter(1) / this.phase.getPhase().getTemperature() + this.phase.getPhase().getComponents()[i].getLiquidViscosityParameter(2) * this.phase.getPhase().getTemperature() + this.phase.getPhase().getComponents()[i].getLiquidViscosityParameter(3) * Math.pow(this.phase.getPhase().getTemperature(), 2.0)) : (this.phase.getPhase().getComponents()[i].getLiquidViscosityModel() == 4 ? Math.pow(10.0, this.phase.getPhase().getComponents()[i].getLiquidViscosityParameter(0) * (1.0 / this.phase.getPhase().getTemperature() - 1.0 / this.phase.getPhase().getComponents()[i].getLiquidViscosityParameter(1))) : 0.7);
            }
            int n = i;
            this.pureComponentViscosity[n] = this.pureComponentViscosity[n] * ((this.getViscosityPressureCorrection(i) + 1.0) / 2.0);
            ++i;
        }
    }

    public double getViscosityPressureCorrection(int i) {
        double TR = this.phase.getPhase().getTemperature() / this.phase.getPhase().getComponent(i).getTC();
        if (TR > 1.0) {
            return 1.0;
        }
        double deltaPr = (this.phase.getPhase().getPressure() - 0.0) / this.phase.getPhase().getComponent(i).getPC();
        double A = 0.9991 - 4.674000000000001E-4 / (1.0523 * Math.pow(TR, -0.03877) - 1.0513);
        double D = 0.3257 / Math.pow(1.0039 - Math.pow(TR, 2.573), 0.2906) - 0.2086;
        double C = -0.07921 + 2.1616 * TR - 13.404 * TR * TR + 44.1706 * Math.pow(TR, 3.0) - 84.8291 * Math.pow(TR, 4.0) + 96.1209 * Math.pow(TR, 5.0) - 59.8127 * Math.pow(TR, 6.0) + 15.6719 * Math.pow(TR, 7.0);
        return (1.0 + D * Math.pow(deltaPr / 2.118, A)) / (1.0 + C * this.phase.getPhase().getComponent(i).getAcentricFactor() * deltaPr);
    }

    @Override
    public double getPureComponentViscosity(int i) {
        return this.pureComponentViscosity[i];
    }

    @Override
    public Viscosity clone() {
        Viscosity properties = null;
        try {
            properties = (Viscosity)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }
}

