/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.diffusivity;

import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.CommonPhysicalPropertyMethod;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.DiffusivityInterface;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Diffusivity
extends CommonPhysicalPropertyMethod
implements DiffusivityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Diffusivity.class);
    double[][] binaryDiffusionCoefficients;
    double[][] binaryLennardJonesOmega;
    double[] effectiveDiffusionCoefficient;

    public Diffusivity() {
    }

    public Diffusivity(PhysicalPropertiesInterface phase) {
        super(phase);
        this.binaryDiffusionCoefficients = new double[phase.getPhase().getNumberOfComponents()][phase.getPhase().getNumberOfComponents()];
        this.binaryLennardJonesOmega = new double[phase.getPhase().getNumberOfComponents()][phase.getPhase().getNumberOfComponents()];
        this.effectiveDiffusionCoefficient = new double[phase.getPhase().getNumberOfComponents()];
    }

    @Override
    public Diffusivity clone() {
        Diffusivity properties = null;
        try {
            properties = (Diffusivity)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    @Override
    public double calcBinaryDiffusionCoefficient(int i, int j, int method) {
        return 1.0E-6;
    }

    @Override
    public double[][] calcDiffusionCoefficients(int binaryDiffusionCoefficientMethod, int multicomponentDiffusionMethod) {
        int i = 0;
        while (i < this.phase.getPhase().getNumberOfComponents()) {
            int j = 0;
            while (j < this.phase.getPhase().getNumberOfComponents()) {
                this.binaryDiffusionCoefficients[i][j] = this.calcBinaryDiffusionCoefficient(i, j, binaryDiffusionCoefficientMethod);
                ++j;
            }
            ++i;
        }
        if (multicomponentDiffusionMethod != 0) {
            // empty if block
        }
        return this.binaryDiffusionCoefficients;
    }

    @Override
    public void calcEffectiveDiffusionCoefficients() {
        double sum = 0.0;
        int i = 0;
        while (i < this.phase.getPhase().getNumberOfComponents()) {
            sum = 0.0;
            int j = 0;
            while (j < this.phase.getPhase().getNumberOfComponents()) {
                if (i != j) {
                    sum += this.phase.getPhase().getComponents()[j].getx() / this.binaryDiffusionCoefficients[i][j];
                }
                ++j;
            }
            this.effectiveDiffusionCoefficient[i] = (1.0 - this.phase.getPhase().getComponents()[i].getx()) / sum;
            ++i;
        }
    }

    @Override
    public double getFickBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }

    @Override
    public double getEffectiveDiffusionCoefficient(int i) {
        return this.effectiveDiffusionCoefficient[i];
    }

    @Override
    public double getMaxwellStefanBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }
}

