/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.interfaceProperties.surfaceTension;

import neqsim.physicalProperties.interfaceProperties.surfaceTension.SurfaceTension;
import neqsim.thermo.system.SystemInterface;

public class LGTSurfaceTension
extends SurfaceTension {
    private static final long serialVersionUID = 1000L;
    int ite_step = 200;
    SystemInterface localSystem = null;
    double[][] den_interface = null;
    double[] z_step = null;
    double[] pressure_interface = null;

    public LGTSurfaceTension() {
    }

    public LGTSurfaceTension(SystemInterface system) {
        super(system);
    }

    @Override
    public double calcSurfaceTension(int interface1, int interface2) {
        double surdenstemp = 0.0;
        this.localSystem = this.system.clone();
        int referenceComponentNumber = this.getComponentWithHighestBoilingpoint();
        double pressure_equi = 100000.0 * this.system.getPressure();
        this.den_interface = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()];
        this.pressure_interface = new double[this.ite_step];
        this.pressure_interface[0] = pressure_equi;
        double[] del_den_interface = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        double[] del_den_interface_old = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        double[] mu_equi = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        double[][][] dmudn = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()][this.localSystem.getPhase(0).getNumberOfComponents()];
        double[][] mu_inter = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()];
        double[] mu_times_den = new double[this.ite_step];
        this.z_step = new double[this.ite_step];
        int i = 0;
        while (i < this.localSystem.getPhase(0).getNumberOfComponents()) {
            mu_equi[i] = this.system.getPhase(interface1).getComponent(i).getChemicalPotential(this.system.getPhase(interface1));
            this.den_interface[0][i] = 100000.0 * this.system.getPhase(interface1).getComponent(i).getx() / this.system.getPhase(interface1).getMolarVolume();
            this.den_interface[this.ite_step - 1][i] = 100000.0 * this.system.getPhase(interface2).getComponent(i).getx() / this.system.getPhase(interface2).getMolarVolume();
            del_den_interface[i] = (100000.0 * this.system.getPhase(interface2).getComponent(i).getx() / this.system.getPhase(interface2).getMolarVolume() - 100000.0 * this.system.getPhase(interface1).getComponent(i).getx() / this.system.getPhase(interface1).getMolarVolume()) / ((double)this.ite_step * 1.0);
            del_den_interface_old[i] = 0.0;
            this.localSystem.addComponent(this.localSystem.getPhase(0).getComponent(i).getName(), -this.system.getPhase(0).getComponent(i).getNumberOfmoles());
            this.localSystem.addComponent(this.localSystem.getPhase(0).getComponent(i).getName(), this.system.getPhase(interface1).getComponent(i).getx() / this.system.getPhase(interface1).getMolarVolume());
            ++i;
        }
        this.localSystem.init(0);
        this.localSystem.setUseTVasIndependentVariables(true);
        this.localSystem.setNumberOfPhases(1);
        this.localSystem.getPhase(0).setTotalVolume(1.0);
        this.localSystem.useVolumeCorrection(false);
        this.localSystem.initBeta();
        this.localSystem.init_x_y();
        this.localSystem.init(3);
        int j = 1;
        while (j < this.ite_step) {
            int i2 = 0;
            while (i2 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                del_den_interface[i2] = (100000.0 * this.system.getPhase(interface2).getComponent(i2).getx() / this.system.getPhase(interface2).getMolarVolume() - 100000.0 * this.system.getPhase(interface1).getComponent(i2).getx() / this.system.getPhase(interface1).getMolarVolume()) / ((double)this.ite_step * 1.0);
                del_den_interface_old[i2] = 0.0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                this.den_interface[j][i2] = this.den_interface[j - 1][i2] + del_den_interface[i2];
                this.localSystem.addComponent(this.localSystem.getPhase(0).getComponent(i2).getName(), (del_den_interface[i2] - del_den_interface_old[i2]) / 100000.0);
                del_den_interface_old[i2] = del_den_interface[i2];
                ++i2;
            }
            this.localSystem.init_x_y();
            this.localSystem.init(3);
            i2 = 0;
            while (i2 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                mu_inter[j][i2] = this.localSystem.getPhase(0).getComponent(i2).getChemicalPotential(this.localSystem.getPhase(0));
                int k = 0;
                while (k < this.localSystem.getPhase(0).getNumberOfComponents()) {
                    dmudn[j][i2][k] = this.localSystem.getPhase(0).getComponent(i2).getChemicalPotentialdNTV(k, this.localSystem.getPhase(0));
                    ++k;
                }
                ++i2;
            }
            this.pressure_interface[j] = 100000.0 * this.localSystem.getPhase(0).getPressure();
            mu_times_den[j] = 0.0;
            double kappa = 0.0;
            double kappai = 0.0;
            double kappak = 0.0;
            double interact = 1.0;
            int i3 = 0;
            while (i3 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                double infli = this.localSystem.getPhase(0).getComponent(i3).getSurfaceTenisionInfluenceParameter(this.localSystem.getPhase(0).getTemperature());
                kappai = i3 == referenceComponentNumber ? 1.0 : del_den_interface[i3] / del_den_interface[referenceComponentNumber];
                int n = j;
                mu_times_den[n] = mu_times_den[n] + this.den_interface[j][i3] * (mu_inter[j][i3] - mu_equi[i3]);
                int k = 0;
                while (k < this.localSystem.getPhase(0).getNumberOfComponents()) {
                    interact = (this.localSystem.getPhase(0).getComponent(i3).getName().equals("water") || this.localSystem.getPhase(0).getComponent(k).getName().equals("water")) && i3 != k ? ((this.localSystem.getPhase(0).getComponent(i3).getName().equals("MEG") || this.localSystem.getPhase(0).getComponent(k).getName().equals("MEG")) && i3 != k ? 0.2 : 0.35) : 0.0;
                    double inflk = this.localSystem.getPhase(0).getComponent(k).getSurfaceTenisionInfluenceParameter(this.localSystem.getPhase(0).getTemperature());
                    kappak = k == referenceComponentNumber ? 1.0 : del_den_interface[k] / del_den_interface[referenceComponentNumber];
                    kappa += Math.sqrt(infli * inflk) * kappai * kappak * (1.0 - interact);
                    ++k;
                }
                ++i3;
            }
            int n = j;
            mu_times_den[n] = mu_times_den[n] + -(this.pressure_interface[j] - pressure_equi);
            this.z_step[j] = this.z_step[j - 1] + Math.sqrt(kappa / (2.0 * mu_times_den[j])) * del_den_interface[referenceComponentNumber];
            if (Double.isNaN(this.z_step[j])) break;
            surdenstemp += Math.sqrt(2.0 * kappa * mu_times_den[j]) * del_den_interface[referenceComponentNumber];
            ++j;
        }
        j = 0;
        while (j < this.ite_step) {
            ++j;
        }
        return Math.abs(surdenstemp);
    }

    public double[] getMolarDensity(int compnum) {
        double[] temp = new double[this.ite_step];
        int i = 0;
        while (i < this.ite_step) {
            temp[i] = this.den_interface[i][compnum];
            ++i;
        }
        return temp;
    }

    public double[] getMolarDensityTotal() {
        double[] temp = new double[this.ite_step];
        int i = 0;
        while (i < this.ite_step) {
            int j = 0;
            while (j < this.system.getPhase(0).getNumberOfComponents()) {
                int n = i;
                temp[n] = temp[n] + this.den_interface[i][j];
                ++j;
            }
            ++i;
        }
        return temp;
    }

    public double[] getz() {
        return this.z_step;
    }

    public double[] getPressure() {
        return this.pressure_interface;
    }
}

