/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.interfaceProperties.surfaceTension;

import Jama.Matrix;
import neqsim.physicalProperties.interfaceProperties.surfaceTension.SurfaceTension;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GTSurfaceTensionSimple
extends SurfaceTension {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(GTSurfaceTensionSimple.class);
    int ite_step = 200;
    SystemInterface localSystem = null;
    double[][] den_interface = null;
    double[] z_step = null;
    double[] pressure_interface = null;
    boolean calcInfluenceParameter = true;
    double[] influenceParam;
    private double[][][] dmudn2 = null;

    public GTSurfaceTensionSimple() {
    }

    public GTSurfaceTensionSimple(SystemInterface system) {
        super(system);
    }

    public void calcInfluenceParameters() {
        this.influenceParam = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        int i = 0;
        while (i < this.localSystem.getPhase(0).getNumberOfComponents()) {
            this.influenceParam[i] = this.localSystem.getPhase(0).getComponent(i).getSurfaceTenisionInfluenceParameter(this.localSystem.getPhase(0).getTemperature());
            ++i;
        }
    }

    @Override
    public double calcSurfaceTension(int interface1, int interface2) {
        this.localSystem = this.system.clone();
        double surdenstemp = 0.0;
        int referenceComponentNumber = this.getComponentWithHighestBoilingpoint();
        double[] del_den_interface = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        double[] del_den_interface_old = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        double[] mu_equi = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        double[][][] dmudn = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()][this.localSystem.getPhase(0).getNumberOfComponents()];
        this.dmudn2 = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()][this.localSystem.getPhase(0).getNumberOfComponents()];
        double[][] mu_inter = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()];
        double[] mu_times_den = new double[this.ite_step];
        double[][] fmatrix = new double[this.localSystem.getPhase(0).getNumberOfComponents() - 1][this.localSystem.getPhase(0).getNumberOfComponents() - 1];
        double[] bmatrix = new double[this.localSystem.getPhase(0).getNumberOfComponents() - 1];
        Matrix ans = null;
        this.z_step = new double[this.ite_step];
        this.den_interface = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()];
        this.pressure_interface = new double[this.ite_step];
        this.pressure_interface[0] = 100000.0 * this.system.getPressure();
        if (this.calcInfluenceParameter) {
            this.calcInfluenceParameters();
        }
        int i = 0;
        while (i < this.localSystem.getPhase(0).getNumberOfComponents()) {
            mu_equi[i] = this.system.getPhase(interface1).getComponent(i).getChemicalPotential(this.system.getPhase(interface1));
            this.den_interface[0][i] = 100000.0 * this.system.getPhase(interface1).getComponent(i).getx() / this.system.getPhase(interface1).getMolarVolume();
            this.localSystem.addComponent(this.localSystem.getPhase(0).getComponent(i).getName(), -this.system.getPhase(0).getComponent(i).getNumberOfmoles());
            this.localSystem.addComponent(this.localSystem.getPhase(0).getComponent(i).getName(), this.system.getPhase(interface1).getComponent(i).getx() / this.system.getPhase(interface1).getMolarVolume());
            ++i;
        }
        del_den_interface[referenceComponentNumber] = (100000.0 * this.system.getPhase(interface2).getComponent(referenceComponentNumber).getx() / this.system.getPhase(interface2).getMolarVolume() - 100000.0 * this.system.getPhase(interface1).getComponent(referenceComponentNumber).getx() / this.system.getPhase(interface1).getMolarVolume()) / ((double)this.ite_step * 1.0);
        this.localSystem.init(0);
        this.localSystem.setUseTVasIndependentVariables(true);
        this.localSystem.setNumberOfPhases(1);
        this.localSystem.getPhase(0).setTotalVolume(1.0);
        this.localSystem.useVolumeCorrection(false);
        this.localSystem.init_x_y();
        this.localSystem.init(3);
        int j = 1;
        while (j < this.ite_step) {
            int i2 = 0;
            while (i2 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                mu_inter[j][i2] = this.localSystem.getPhase(0).getComponent(i2).getChemicalPotential(this.localSystem.getPhase(0));
                int k = 0;
                while (k < this.localSystem.getPhase(0).getNumberOfComponents()) {
                    dmudn[j][i2][k] = this.localSystem.getPhase(0).getComponent(i2).getChemicalPotentialdNTV(k, this.localSystem.getPhase(0));
                    ++k;
                }
                ++i2;
            }
            int ii = 0;
            int kk = 0;
            int i3 = 0;
            while (i3 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                if (i3 != referenceComponentNumber) {
                    bmatrix[ii] = Math.sqrt(this.influenceParam[referenceComponentNumber]) * dmudn[j][i3][referenceComponentNumber] - Math.sqrt(this.influenceParam[i3]) * dmudn[j][referenceComponentNumber][referenceComponentNumber];
                    kk = 0;
                    int k = 0;
                    while (k < this.localSystem.getPhase(0).getNumberOfComponents()) {
                        if (k != referenceComponentNumber) {
                            fmatrix[ii][kk] = Math.sqrt(this.influenceParam[i3]) * dmudn[j][referenceComponentNumber][k] - Math.sqrt(this.influenceParam[referenceComponentNumber]) * dmudn[j][i3][k];
                            ++kk;
                        }
                        ++k;
                    }
                    ++ii;
                }
                ++i3;
            }
            if (this.localSystem.getPhase(0).getNumberOfComponents() > 1) {
                Matrix fmatrixJama = new Matrix(fmatrix);
                Matrix bmatrixJama = new Matrix(bmatrix, this.localSystem.getPhase(0).getNumberOfComponents() - 1);
                try {
                    ans = fmatrixJama.solveTranspose(bmatrixJama.transpose());
                }
                catch (Exception ex) {
                    logger.error("error", (Throwable)ex);
                }
            }
            int pp = 0;
            int i4 = 0;
            while (i4 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                if (i4 != referenceComponentNumber) {
                    del_den_interface[i4] = ans.get(pp, 0) * del_den_interface[referenceComponentNumber];
                    if (Math.abs(ans.get(pp, 0)) * del_den_interface[referenceComponentNumber] / this.den_interface[j - 1][i4] > 0.1) {
                        del_den_interface[i4] = Math.signum(ans.get(pp, 0)) * this.den_interface[j - 1][i4];
                    }
                    ++pp;
                }
                del_den_interface_old[i4] = 0.0;
                ++i4;
            }
            double interact = 1.0;
            double err = 1.0;
            int iterations = 0;
            while (err > 1.0E-15 && iterations < 1200) {
                int k;
                ++iterations;
                double totalDens = 0.0;
                int i5 = 0;
                while (i5 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                    this.den_interface[j][i5] = this.den_interface[j - 1][i5] + del_den_interface[i5];
                    totalDens += this.den_interface[j][i5];
                    this.localSystem.addComponent(this.localSystem.getPhase(0).getComponent(i5).getName(), (del_den_interface[i5] - del_den_interface_old[i5]) / 100000.0);
                    del_den_interface_old[i5] = del_den_interface[i5];
                    ++i5;
                }
                this.localSystem.init_x_y();
                this.localSystem.init(3);
                i5 = 0;
                while (i5 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                    mu_inter[j][i5] = this.localSystem.getPhase(0).getComponent(i5).getChemicalPotential(this.localSystem.getPhase(0));
                    k = 0;
                    while (k < this.localSystem.getPhase(0).getNumberOfComponents()) {
                        dmudn[j][i5][k] = this.localSystem.getPhase(0).getComponent(i5).getChemicalPotentialdNTV(k, this.localSystem.getPhase(0));
                        this.dmudn2[j][i5][k] = dmudn[j][i5][k];
                        ++k;
                    }
                    ++i5;
                }
                ii = 0;
                i5 = 0;
                while (i5 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                    if (i5 != referenceComponentNumber) {
                        bmatrix[ii] = -Math.sqrt(this.influenceParam[i5]) * (mu_equi[referenceComponentNumber] - mu_inter[j][referenceComponentNumber]) + Math.sqrt(this.influenceParam[referenceComponentNumber]) * (mu_equi[i5] - mu_inter[j][i5]);
                        kk = 0;
                        k = 0;
                        while (k < this.localSystem.getPhase(0).getNumberOfComponents()) {
                            if (k != referenceComponentNumber) {
                                fmatrix[ii][kk] = -Math.sqrt(this.influenceParam[i5]) * dmudn[j][referenceComponentNumber][k] + Math.sqrt(this.influenceParam[referenceComponentNumber]) * dmudn[j][i5][k];
                                ++kk;
                            }
                            ++k;
                        }
                        ++ii;
                    }
                    ++i5;
                }
                RealMatrix ans2 = null;
                Array2DRowRealMatrix bRealMatrix = new Array2DRowRealMatrix(bmatrix);
                if (this.localSystem.getPhase(0).getNumberOfComponents() > 1) {
                    Array2DRowRealMatrix fmatrixJama = new Array2DRowRealMatrix(fmatrix);
                    try {
                        DecompositionSolver solver1 = new LUDecomposition(fmatrixJama).getSolver();
                        ans2 = solver1.solve(bRealMatrix);
                    }
                    catch (Exception ex) {
                        logger.error("error", (Throwable)ex);
                    }
                }
                pp = 0;
                err = 0.0;
                int i6 = 0;
                while (i6 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                    if (i6 != referenceComponentNumber) {
                        err += Math.abs(ans2.getEntry(pp, 0) * 100000.0) / totalDens;
                        int n = i6;
                        del_den_interface[n] = del_den_interface[n] + 100000.0 * ans2.getEntry(pp, 0);
                        ++pp;
                    }
                    ++i6;
                }
            }
            this.pressure_interface[j] = 100000.0 * this.localSystem.getPhase(0).getPressure();
            mu_times_den[j] = 0.0;
            double kappa = 0.0;
            double kappai = 0.0;
            double kappak = 0.0;
            int i7 = 0;
            while (i7 < this.localSystem.getPhase(0).getNumberOfComponents()) {
                double infli = this.influenceParam[i7];
                kappai = del_den_interface[i7] / del_den_interface[referenceComponentNumber];
                int n = j;
                mu_times_den[n] = mu_times_den[n] + this.den_interface[j][i7] * (mu_inter[j][i7] - mu_equi[i7]);
                int k = 0;
                while (k < this.localSystem.getPhase(0).getNumberOfComponents()) {
                    interact = (this.localSystem.getPhase(0).getComponent(i7).getName().equals("water") || this.localSystem.getPhase(0).getComponent(k).getName().equals("water")) && i7 != k ? 0.0 : 0.0;
                    double inflk = this.influenceParam[k];
                    kappak = del_den_interface[k] / del_den_interface[referenceComponentNumber];
                    kappa += Math.sqrt(infli * inflk) * kappai * kappak * (1.0 - interact);
                    ++k;
                }
                ++i7;
            }
            int n = j;
            mu_times_den[n] = mu_times_den[n] + -(this.pressure_interface[j] - this.pressure_interface[0]);
            this.z_step[j] = this.z_step[j - 1] + Math.sqrt(kappa / (2.0 * mu_times_den[j])) * del_den_interface[referenceComponentNumber];
            if (Double.isNaN(this.z_step[j])) break;
            surdenstemp += Math.sqrt(2.0 * kappa * mu_times_den[j]) * del_den_interface[referenceComponentNumber];
            ++j;
        }
        j = 0;
        while (j < this.ite_step) {
            ++j;
        }
        return Math.abs(surdenstemp);
    }

    public double[] getMolarDensity(int compnum) {
        double[] temp = new double[this.ite_step];
        int i = 0;
        while (i < this.ite_step) {
            temp[i] = this.den_interface[i][compnum];
            ++i;
        }
        return temp;
    }

    public double[] getMolarDensityTotal() {
        double[] temp = new double[this.ite_step];
        int i = 0;
        while (i < this.ite_step) {
            int j = 0;
            while (j < this.system.getPhase(0).getNumberOfComponents()) {
                int n = i;
                temp[n] = temp[n] + this.den_interface[i][j];
                ++j;
            }
            ++i;
        }
        return temp;
    }

    public double[] getz() {
        return this.z_step;
    }

    public double[] getPressure() {
        return this.pressure_interface;
    }

    public double getInfluenceParameter(double interfaceTension, int componentNumber) {
        double oldInfluenceParameter = this.influenceParam[componentNumber];
        double calcVal = 0.0;
        double oldCalcVal = 0.0;
        double dSurfTensdinfluence = 0.0;
        int iter = 0;
        this.calcInfluenceParameter = true;
        calcVal = this.calcSurfaceTension(0, 1) - interfaceTension;
        do {
            oldCalcVal = calcVal;
            this.calcInfluenceParameter = false;
            if (++iter > 1) {
                int n = componentNumber;
                this.influenceParam[n] = this.influenceParam[n] - calcVal / dSurfTensdinfluence;
            } else {
                int n = componentNumber;
                this.influenceParam[n] = this.influenceParam[n] * 1.01;
            }
            calcVal = this.calcSurfaceTension(0, 1) - interfaceTension;
            dSurfTensdinfluence = (calcVal - oldCalcVal) / (this.influenceParam[componentNumber] - oldInfluenceParameter);
            oldInfluenceParameter = this.influenceParam[componentNumber];
        } while (Math.abs(calcVal / interfaceTension) > 1.0E-8 && iter < 100);
        this.calcInfluenceParameter = true;
        return this.influenceParam[componentNumber];
    }

    public double[][][] getDmudn2() {
        return this.dmudn2;
    }

    public void setDmudn2(double[][][] dmudn2) {
        this.dmudn2 = dmudn2;
    }
}

