/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.twoPhaseFlowVisualization.twoPhasePipeFlowVisualization;

import neqsim.fluidMechanics.flowSystem.FlowSystem;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowNodeVisualization.twoPhaseFlowNodeVisualization.TwoPhaseFlowNodeVisualization;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.twoPhaseFlowVisualization.TwoPhaseFlowVisualization;

public class TwoPhasePipeFlowVisualization
extends TwoPhaseFlowVisualization {
    double[][][] pressurePoint = new double[2][10][10];
    double[][][] velocityPoint = new double[2][10][10];
    double[][][] reynoldsNumber = new double[2][10][10];
    double[][][] phaseFraction = new double[2][10][10];
    double[][][] temperaturePoint = new double[2][10][10];
    double[][][] interphaseContactLength = new double[2][10][10];
    double[][][] interfaceTemperaturePoint = new double[2][10][10];
    public double[][][][] bulkComposition;
    public double[][][][] interfaceComposition;
    public double[][][][] effectiveMassTransferCoefficient;
    public double[][][][] molarFlux;
    public double[][][][] schmidtNumber;
    public double[][][][] totalMolarMassTransferRate;
    public double[][][][] totalVolumetricMassTransferRate;
    double[] xPlace = new double[10];
    double[] timeArray = new double[10];

    public TwoPhasePipeFlowVisualization() {
    }

    public TwoPhasePipeFlowVisualization(int nodes, int timeSteps) {
        this.flowNodes = new TwoPhaseFlowNodeVisualization[timeSteps][nodes];
        this.flowSystem = new FlowSystem[timeSteps];
        this.absTime = new double[timeSteps];
        int i = 0;
        while (i < timeSteps) {
            int j = 0;
            while (j < nodes) {
                this.flowNodes[i][j] = new TwoPhaseFlowNodeVisualization();
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setPoints() {
        this.pressurePoint = new double[2][this.time][this.flowNodes[0].length];
        this.temperaturePoint = new double[2][this.time][this.flowNodes[0].length];
        this.interphaseContactLength = new double[2][this.time][this.flowNodes[0].length];
        this.velocityPoint = new double[2][this.time][this.flowNodes[0].length];
        this.reynoldsNumber = new double[2][this.time][this.flowNodes[0].length];
        this.phaseFraction = new double[2][this.time][this.flowNodes[0].length];
        this.interfaceTemperaturePoint = new double[2][this.time][this.flowNodes[0].length];
        this.bulkComposition = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.effectiveMassTransferCoefficient = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.interfaceComposition = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.molarFlux = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.schmidtNumber = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.totalMolarMassTransferRate = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.totalVolumetricMassTransferRate = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.xPlace = new double[this.flowNodes[0].length];
        this.timeArray = new double[this.time];
        int k = 0;
        while (k < 2) {
            int j = 0;
            while (j < this.time) {
                this.timeArray[j] = j;
                int i = 0;
                while (i < this.flowNodes[j].length) {
                    this.xPlace[i] = this.flowNodes[j][i].getDistanceToCenterOfNode();
                    this.pressurePoint[k][j][i] = this.flowNodes[j][i].getPressure(k);
                    this.interphaseContactLength[k][j][i] = this.flowNodes[j][i].getInterphaseContactLength();
                    this.temperaturePoint[k][j][i] = this.flowNodes[j][i].getTemperature(k);
                    this.velocityPoint[k][j][i] = this.flowNodes[j][i].getVelocity(k);
                    this.reynoldsNumber[k][j][i] = this.flowNodes[j][i].getReynoldsNumber(k);
                    this.phaseFraction[k][j][i] = this.flowNodes[j][i].getPhaseFraction(k);
                    this.interfaceTemperaturePoint[k][j][i] = this.flowNodes[j][i].getInterfaceTemperature(k);
                    int p = 0;
                    while (p < this.flowNodes[0][0].getNumberOfComponents()) {
                        this.effectiveMassTransferCoefficient[k][p][j][i] = this.flowNodes[j][i].getEffectiveMassTransferCoefficient(p, k);
                        this.bulkComposition[k][p][j][i] = this.flowNodes[j][i].getBulkComposition(p, k);
                        this.interfaceComposition[k][p][j][i] = this.flowNodes[j][i].getInterfaceComposition(p, k);
                        this.molarFlux[k][p][j][i] = this.flowNodes[j][i].getEffectiveSchmidtNumber(p, k);
                        this.schmidtNumber[k][p][j][i] = this.flowNodes[j][i].getEffectiveSchmidtNumber(p, k);
                        this.totalMolarMassTransferRate[k][p][j][i] = this.flowSystem[j].getTotalMolarMassTransferRate(p, i);
                        this.totalVolumetricMassTransferRate[k][p][j][i] = this.totalMolarMassTransferRate[k][p][j][i] * 60.0 / 40.87631889 * 1000.0;
                        ++p;
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    @Override
    public void displayResult(String name) {
        this.setPoints();
    }
}

