/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.geometryDefinitions.reactor;

import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinition;
import neqsim.fluidMechanics.geometryDefinitions.internalGeometry.packings.PallRingPacking;
import neqsim.fluidMechanics.geometryDefinitions.internalGeometry.packings.RachigRingPacking;

public class ReactorData
extends GeometryDefinition {
    private static final long serialVersionUID = 1000L;

    public ReactorData() {
    }

    public ReactorData(double diameter) {
        super(diameter);
    }

    public ReactorData(double diameter, double roughness) {
        super(diameter, roughness);
        this.packing = new PallRingPacking("PallRingPacking");
    }

    public ReactorData(double diameter, int packingType) {
        super(diameter);
        this.setPackingType(packingType);
    }

    @Override
    public void setPackingType(int i) {
        this.packing = new PallRingPacking("PallRingPacking");
    }

    public void setPackingType(String name) {
        if (name.equals("pallring")) {
            this.packing = new PallRingPacking("pallring");
        } else if (name.equals("rashigring")) {
            this.packing = new RachigRingPacking("rashigring");
        } else {
            System.out.println("pakcing " + name + " not defined in database - using pallrings");
            this.packing = new PallRingPacking("pallring");
        }
    }

    @Override
    public void setPackingType(String name, String material, int size) {
        if (name.equals("pallring")) {
            this.packing = new PallRingPacking("pallring", material, size);
        } else if (name.equals("rashigring")) {
            this.packing = new RachigRingPacking("rashigring", material, size);
        } else {
            System.out.println("pakcing " + name + " not defined in database - using pallrings");
            this.packing = new PallRingPacking("pallring", material, size);
        }
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public ReactorData clone() {
        ReactorData clonedPipe = null;
        try {
            clonedPipe = (ReactorData)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedPipe;
    }
}

