/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowSystem.twoPhaseFlowSystem.twoPhaseReactorFlowSystem;

import java.util.UUID;
import neqsim.fluidMechanics.flowLeg.pipeLeg.PipeLeg;
import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode.StratifiedFlowNode;
import neqsim.fluidMechanics.flowSolver.twoPhaseFlowSolver.twoPhasePipeFlowSolver.TwoPhaseFixedStaggeredGridSolver;
import neqsim.fluidMechanics.flowSystem.twoPhaseFlowSystem.TwoPhaseFlowSystem;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.geometryDefinitions.reactor.ReactorData;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.twoPhaseFlowVisualization.twoPhasePipeFlowVisualization.TwoPhasePipeFlowVisualization;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class TwoPhaseReactorFlowSystem
extends TwoPhaseFlowSystem {
    private static final long serialVersionUID = 1000L;

    @Override
    public void createSystem() {
        this.flowLeg = new PipeLeg[this.getNumberOfLegs()];
        int i = 0;
        while (i < this.getNumberOfLegs()) {
            this.flowLeg[i] = new PipeLeg();
            ++i;
        }
        this.flowNode = new FlowNodeInterface[this.totalNumberOfNodes];
        this.flowNode[0] = new StratifiedFlowNode(this.thermoSystem, this.equipmentGeometry[0]);
        this.flowNode[this.totalNumberOfNodes - 1] = this.flowNode[0].getNextNode();
        super.createSystem();
        this.setNodes();
    }

    @Override
    public void init() {
        int phase;
        int j = 0;
        while (j < this.getTotalNumberOfNodes()) {
            this.flowNode[j].setInterphaseModelType(1);
            this.flowNode[j].getGeometry();
            this.flowNode[j].initFlowCalc();
            this.flowNode[j].init();
            ++j;
        }
        j = 0;
        while (j < this.getTotalNumberOfNodes()) {
            phase = 0;
            while (phase < 2) {
                this.flowNode[j].setVelocityOut(phase, this.flowNode[j].getVelocity(phase));
                ++phase;
            }
            ++j;
        }
        int k = 1;
        while (k < this.getTotalNumberOfNodes()) {
            phase = 0;
            while (phase < 2) {
                this.flowNode[k].setVelocityIn(phase, this.flowNode[k - 1].getVelocityOut(phase));
                ++phase;
            }
            ++k;
        }
    }

    @Override
    public void solveSteadyState(int type, UUID id) {
        double[] times = new double[]{0.0};
        this.display = new TwoPhasePipeFlowVisualization(this.getTotalNumberOfNodes(), 1);
        this.getTimeSeries().setTimes(times);
        SystemInterface[] systems = new SystemInterface[]{this.flowNode[0].getBulkSystem()};
        this.getTimeSeries().setInletThermoSystems(systems);
        this.getTimeSeries().setNumberOfTimeStepsInInterval(1);
        double[] outletFlowRates = new double[]{0.0, 0.0};
        this.getTimeSeries().setOutletMolarFlowRate(outletFlowRates);
        this.flowSolver = new TwoPhaseFixedStaggeredGridSolver(this, this.getSystemLength(), this.getTotalNumberOfNodes(), false);
        this.flowSolver.setSolverType(type);
        this.flowSolver.solveTDMA();
        this.getTimeSeries().init(this);
        this.display.setNextData(this);
    }

    @Override
    public void solveTransient(int type, UUID id) {
        this.calcIdentifier = id;
    }

    public static void main(String[] args) {
        TwoPhaseReactorFlowSystem pipe = new TwoPhaseReactorFlowSystem();
        SystemSrkEos testSystem = new SystemSrkEos(295.3, 5.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        testSystem.addComponent("methane", 0.11152181, 0);
        testSystem.addComponent("water", 0.04962204876, 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        pipe.setInletThermoSystem(testSystem);
        pipe.setNumberOfLegs(5);
        pipe.setNumberOfNodesInLeg(100);
        double[] height = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] length = new double[]{0.0, 1.7, 3.5, 5.0, 7.5, 10.4};
        double[] outerTemperature = new double[]{278.0, 278.0, 278.0, 278.0, 278.0, 278.0, 278.0, 275.0, 275.0, 275.0, 275.0};
        pipe.setLegHeights(height);
        pipe.setLegPositions(length);
        pipe.setLegOuterTemperatures(outerTemperature);
        GeometryDefinitionInterface[] pipeGemometry = new ReactorData[5];
        double[] pipeDiameter = new double[]{0.02588, 0.02588, 0.02588, 0.02588, 0.02588};
        int i = 0;
        while (i < pipeDiameter.length) {
            pipeGemometry[i] = new ReactorData(pipeDiameter[i], 1);
            ++i;
        }
        pipe.setEquipmentGeometry(pipeGemometry);
        pipe.createSystem();
        pipe.init();
        pipe.solveSteadyState(2);
    }
}

