/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowSystem.twoPhaseFlowSystem.stirredCellSystem;

import java.util.UUID;
import neqsim.fluidMechanics.flowLeg.pipeLeg.PipeLeg;
import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhaseStirredCellNode.StirredCellNode;
import neqsim.fluidMechanics.flowSolver.twoPhaseFlowSolver.stirredCellSolver.StirredCellSolver;
import neqsim.fluidMechanics.flowSystem.twoPhaseFlowSystem.TwoPhaseFlowSystem;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.twoPhaseFlowVisualization.twoPhasePipeFlowVisualization.TwoPhasePipeFlowVisualization;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;

public class StirredCellSystem
extends TwoPhaseFlowSystem {
    private static final long serialVersionUID = 1000L;

    @Override
    public void createSystem() {
        this.flowLeg = new PipeLeg[this.getNumberOfLegs()];
        int i = 0;
        while (i < this.getNumberOfLegs()) {
            this.flowLeg[i] = new PipeLeg();
            ++i;
        }
        this.flowNode = new FlowNodeInterface[this.totalNumberOfNodes];
        this.flowNode[0] = new StirredCellNode(this.thermoSystem, this.equipmentGeometry[0]);
        this.flowNode[this.totalNumberOfNodes - 1] = this.flowNode[0].getNextNode();
        super.createSystem();
        this.setNodes();
    }

    @Override
    public void init() {
        int phase;
        int j = 0;
        while (j < this.getTotalNumberOfNodes()) {
            this.flowNode[j].init();
            ++j;
        }
        j = 0;
        while (j < this.getTotalNumberOfNodes()) {
            phase = 0;
            while (phase < 2) {
                this.flowNode[j].setVelocityOut(phase, this.flowNode[j].getVelocity(phase));
                ++phase;
            }
            ++j;
        }
        int k = 1;
        while (k < this.getTotalNumberOfNodes()) {
            phase = 0;
            while (phase < 2) {
                this.flowNode[k].setVelocityIn(phase, this.flowNode[k - 1].getVelocityOut(phase));
                ++phase;
            }
            ++k;
        }
    }

    @Override
    public void solveSteadyState(int type, UUID id) {
        this.flowSolver = new StirredCellSolver(this, this.getSystemLength(), this.getTotalNumberOfNodes(), false);
        this.calcIdentifier = id;
    }

    @Override
    public void solveTransient(int solverType, UUID id) {
        this.getTimeSeries().init(this);
        this.display = new TwoPhasePipeFlowVisualization(this.getTotalNumberOfNodes(), this.getTimeSeries().getTime().length);
        int i = 0;
        while (i < this.getTimeSeries().getTime().length) {
            this.getNode(0).setBulkSystem(this.getTimeSeries().getThermoSystem()[i]);
            this.flowNode[0].initFlowCalc();
            this.flowNode[0].init();
            this.flowNode[0].setVelocityIn(this.flowNode[0].getVelocity());
            this.flowNode[this.getTotalNumberOfNodes() - 1].setVelocity(this.getTimeSeries().getOutletMolarFlowRates()[i]);
            System.out.println("time: " + i + "  " + this.getTimeSeries().getTime()[i]);
            this.flowSolver.solveTDMA();
            this.display.setNextData(this, this.getTimeSeries().getTime(i));
            ++i;
        }
        this.calcIdentifier = id;
    }

    public static void main(String[] args) {
        StirredCellSystem pipe = new StirredCellSystem();
        SystemSrkEos testSystem = new SystemSrkEos(295.3, 5.0);
        testSystem.addComponent("methane", 0.11152181, 0);
        testSystem.addComponent("water", 0.04962204876, 1);
        testSystem.setMixingRule(2);
        pipe.setInletThermoSystem(testSystem);
        pipe.setNumberOfLegs(1);
        pipe.setNumberOfNodesInLeg(10);
        double[] height = new double[]{0.0, 0.0};
        double[] length = new double[]{0.0, 10.0};
        double[] outerTemperature = new double[]{278.0, 278.0};
        double[] outerHeatTransferCoef = new double[]{2.0, 2.0};
        double[] wallHeatTransferCoef = new double[]{2.0, 2.0};
        pipe.setLegHeights(height);
        pipe.setLegPositions(length);
        pipe.setLegOuterTemperatures(outerTemperature);
        pipe.setLegOuterHeatTransferCoefficients(outerHeatTransferCoef);
        pipe.setLegWallHeatTransferCoefficients(wallHeatTransferCoef);
        GeometryDefinitionInterface[] pipeGemometry = new PipeData[6];
        double[] pipeDiameter = new double[]{0.02588, 0.02588};
        int i = 0;
        while (i < pipeDiameter.length) {
            pipeGemometry[i] = new PipeData(pipeDiameter[i]);
            ++i;
        }
        pipe.setEquipmentGeometry(pipeGemometry);
        pipe.createSystem();
        pipe.init();
        double[] times = new double[]{0.0, 10.0};
        pipe.getTimeSeries().setTimes(times);
        SystemInterface[] systems = new SystemInterface[]{testSystem, testSystem, testSystem};
        pipe.getTimeSeries().setInletThermoSystems(systems);
        pipe.getTimeSeries().setNumberOfTimeStepsInInterval(5);
        pipe.solveSteadyState(2);
        pipe.solveTransient(2);
        System.out.println("disp");
        pipe.getNode(0).display();
        pipe.getNode(0).display();
        pipe.getNode(10).display();
    }
}

