/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowSolver.onePhaseFlowSolver.onePhasePipeFlowSolver;

import Jama.Matrix;
import neqsim.MathLib.generalMath.TDMAsolve;
import neqsim.fluidMechanics.flowSolver.onePhaseFlowSolver.onePhasePipeFlowSolver.OnePhasePipeFlowSolver;
import neqsim.fluidMechanics.flowSystem.onePhaseFlowSystem.pipeFlowSystem.PipeFlowSystem;
import neqsim.thermo.ThermodynamicConstantsInterface;

public class OnePhaseFixedStaggeredGrid
extends OnePhasePipeFlowSolver
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    Matrix diffMatrix;
    int iter = 0;
    Matrix[] diff4Matrix;
    double[][] xNew;
    protected double[] oldMass;
    protected double[] oldComp;
    protected double[] oldDensity;
    protected double[] oldVelocity;
    protected double[][] oldComposition;
    protected double[] oldInternalEnergy;
    protected double[] oldImpuls;
    protected double[] oldEnergy;

    public OnePhaseFixedStaggeredGrid() {
    }

    public OnePhaseFixedStaggeredGrid(PipeFlowSystem pipe, double length, int nodes, boolean dynamic) {
        super(pipe, length, nodes);
        this.dynamic = dynamic;
        this.oldMass = new double[nodes];
        this.oldComp = new double[nodes];
        this.oldImpuls = new double[nodes];
        this.diff4Matrix = new Matrix[pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.oldEnergy = new double[nodes];
        this.oldVelocity = new double[nodes];
        this.oldDensity = new double[nodes];
        this.oldInternalEnergy = new double[nodes];
        this.oldComposition = new double[pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()][nodes];
        this.numberOfVelocityNodes = nodes;
    }

    @Override
    public OnePhaseFixedStaggeredGrid clone() {
        OnePhaseFixedStaggeredGrid clonedSystem = null;
        try {
            clonedSystem = (OnePhaseFixedStaggeredGrid)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    public void initProfiles() {
        double err = 0.0;
        double oldPres = 0.0;
        double dpdx = 0.0;
        do {
            err = 0.0;
            this.pipe.getNode(0).initFlowCalc();
            this.pipe.getNode(0).init();
            this.pipe.getNode(0).setVelocityIn(this.pipe.getNode(0).getVelocity());
            int i = 0;
            while (i < this.numberOfNodes - 1) {
                this.pipe.getNode(i).init();
                this.pipe.getNode(i + 1).getBulkSystem().setTemperature((4.0 * this.pipe.getNode(i).calcTotalHeatTransferCoefficient(0) * (this.pipe.getNode(i).getGeometry().getSurroundingEnvironment().getTemperature() - this.pipe.getNode(i).getBulkSystem().getPhases()[0].getTemperature()) / (this.pipe.getNode(i).getBulkSystem().getPhases()[0].getCp() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass() * this.pipe.getNode(i + 1).getVelocity() * this.pipe.getNode(i + 1).getGeometry().getDiameter() * this.pipe.getNode(i + 1).getBulkSystem().getPhases()[0].getDensity()) + this.pipe.getNode(i + 1).getBulkSystem().getPhases()[0].getJouleThomsonCoefficient() * dpdx) * (this.pipe.getNode(i + 1).getGeometry().getNodeLength() + this.pipe.getNode(i).getGeometry().getNodeLength()) * 0.5 + this.pipe.getNode(i).getBulkSystem().getTemperature());
                if (this.pipe.getNode(i + 1).getBulkSystem().getTemperature() < 10.5) {
                    this.pipe.getNode(i + 1).getBulkSystem().setTemperature(10.5);
                }
                this.pipe.getNode(i + 1).initFlowCalc();
                this.pipe.getNode(i + 1).init();
                oldPres = this.pipe.getNode(i + 1).getBulkSystem().getPressure();
                this.pipe.getNode(i + 1).getBulkSystem().setPressure(-this.pipe.getNode(i).getWallFrictionFactor() * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() * this.pipe.getNode(i).getVelocity() * this.pipe.getNode(i).getVelocity() / this.pipe.getNode(i).getGeometry().getDiameter() / 2.0 * this.pipe.getNode(i).getGeometry().getNodeLength() / 100000.0 - 9.80665 * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() * (this.pipe.getNode(i + 1).getVerticalPositionOfNode() - this.pipe.getNode(i).getVerticalPositionOfNode()) / 100000.0 + this.pipe.getNode(i).getBulkSystem().getPressure());
                err += oldPres - this.pipe.getNode(i + 1).getBulkSystem().getPressure();
                this.pipe.getNode(i + 1).initFlowCalc();
                this.pipe.getNode(i + 1).init();
                dpdx = (this.pipe.getNode(i + 1).getBulkSystem().getPressure() - this.pipe.getNode(i).getBulkSystem().getPressure()) / ((this.pipe.getNode(i + 1).getGeometry().getNodeLength() + this.pipe.getNode(i).getGeometry().getNodeLength()) * 0.5);
                this.pipe.getNode(i + 1).setVelocityIn(this.pipe.getNode(i + 1).getVelocity());
                this.pipe.getNode(i + 1).setVelocity(this.pipe.getNode(i + 1).getVelocityIn().doubleValue());
                this.pipe.getNode(i + 1).init();
                ++i;
            }
        } while (Math.abs(err) > 1.0);
        this.initMatrix();
    }

    public void initMatrix() {
        int i = 0;
        while (i < this.numberOfNodes) {
            this.pipe.getNode(i).init();
            double enthalpy = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass();
            this.solMatrix.set(i, 0, this.pipe.getNode(i).getVelocityIn().doubleValue());
            this.sol3Matrix.set(i, 0, enthalpy);
            this.sol2Matrix.set(i, 0, this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity());
            int j = 0;
            while (j < this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfComponents()) {
                this.sol4Matrix[j].set(i, 0, this.pipe.getNode(i).getBulkSystem().getPhases()[0].getComponents()[j].getx() * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getComponents()[j].getMolarMass() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass());
                ++j;
            }
            ++i;
        }
    }

    public void initPressure(int iteration) {
        int i = 0;
        while (i < this.numberOfNodes) {
            this.pipe.getNode(i).getBulkSystem().setPressure(this.pipe.getNode(i).getBulkSystem().getPhases()[0].getdPdrho() * this.diffMatrix.get(i, 0) * 1.0E-5 + this.pipe.getNode(i).getBulkSystem().getPressure());
            this.pipe.getNode(i).init();
            ++i;
        }
    }

    public void initVelocity(int iteration) {
        int i = 0;
        while (i < this.numberOfNodes) {
            this.pipe.getNode(i).setVelocityIn(this.pipe.getNode(i).getVelocityIn().doubleValue() + (this.solMatrix.get(i, 0) - this.pipe.getNode(i).getVelocityIn().doubleValue()));
            ++i;
        }
        i = 0;
        while (i < this.numberOfNodes) {
            double meanVelocity = 0.0;
            meanVelocity = i == this.numberOfNodes - 1 ? this.pipe.getNode(i).getVelocityIn().doubleValue() : (this.pipe.getNode(i).getVelocityIn().doubleValue() + this.pipe.getNode(i).getVelocityOut().doubleValue()) / 2.0;
            this.pipe.getNode(i).setVelocity(meanVelocity);
            this.pipe.getNode(i).init();
            ++i;
        }
    }

    public void initTemperature(int iteration) {
        int i = 0;
        while (i < this.numberOfNodes) {
            this.pipe.getNode(i).init();
            this.pipe.getNode(i).getBulkSystem().setTemperature(this.pipe.getNode(i).getBulkSystem().getTemperature() + (double)iteration * 1.0 / (10.0 + (double)iteration) * this.diffMatrix.get(i, 0) / (this.pipe.getNode(i).getBulkSystem().getPhases()[0].getCp() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass()));
            this.pipe.getNode(i).init();
            ++i;
        }
    }

    public void initComposition(int iter) {
        int j = 1;
        while (j < this.numberOfNodes) {
            int p = 0;
            while (p < this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()) {
                this.pipe.getNode(j).getBulkSystem().getPhases()[0].getComponents()[p].setx(this.sol4Matrix[p].get(j, 0) * this.pipe.getNode(j).getBulkSystem().getPhases()[0].getMolarMass() / this.pipe.getNode(j).getBulkSystem().getPhases()[0].getComponents()[p].getMolarMass());
                ++p;
            }
            this.pipe.getNode(j).getBulkSystem().getPhases()[0].normalize();
            this.pipe.getNode(j).init();
            ++j;
        }
    }

    public void setMassConservationMatrixTDMA() {
        double Fw;
        double Fe;
        double Aw;
        double Ae;
        if (!this.dynamic) {
            double SU = 0.0;
            this.a[0] = 0.0;
            this.b[0] = 1.0;
            this.c[0] = 0.0;
            this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhases()[0].getDensity();
        } else {
            double Ae2 = this.pipe.getNode(1).getGeometry().getArea();
            double Aw2 = this.pipe.getNode(0).getGeometry().getArea();
            double Fw2 = this.pipe.getNode(0).getVelocityIn().doubleValue() * Aw2;
            double Fe2 = this.oldVelocity[1] * Ae2;
            this.oldMass[0] = 1.0 / this.timeStep * this.pipe.getNode(0).getGeometry().getArea() * this.pipe.getNode(0).getGeometry().getNodeLength();
            this.a[0] = Math.max(Fw2, 0.0);
            this.c[0] = Math.max(-Fe2, 0.0);
            this.b[0] = this.a[0] + this.c[0] + (Fe2 - Fw2) + this.oldMass[0];
            this.r[0] = this.oldMass[0] * this.oldDensity[0];
        }
        int i = 1;
        while (i < this.numberOfNodes - 1) {
            Ae = this.pipe.getNode(i).getGeometry().getArea();
            Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
            Fe = this.pipe.getNode(i).getVelocityOut().doubleValue() * Ae;
            Fw = this.pipe.getNode(i).getVelocityIn().doubleValue() * Aw;
            this.oldMass[i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getGeometry().getArea() * this.pipe.getNode(i).getGeometry().getNodeLength() : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldMass[i];
            this.r[i] = this.oldMass[i] * this.oldDensity[i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
            ++i;
        }
        i = this.numberOfNodes - 1;
        Ae = this.pipe.getNode(i).getGeometry().getArea();
        Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
        Fe = this.pipe.getNode(i).getVelocity() * Ae;
        Fw = this.pipe.getNode(i).getVelocityIn().doubleValue() * Aw;
        this.oldMass[i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getGeometry().getArea() * this.pipe.getNode(i).getGeometry().getNodeLength() : 0.0;
        this.a[i] = Math.max(Fw, 0.0);
        this.c[i] = Math.max(-Fe, 0.0);
        this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldMass[i];
        this.r[i] = this.oldMass[i] * this.oldDensity[i];
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void setImpulsMatrixTDMA() {
        double nodeLength;
        double vertposchange;
        double meanVelocity;
        double oldMeanDensity;
        double meanDensity;
        double meanFrik;
        double meanDiameter;
        double Amean;
        double Aw;
        double Ae;
        double SU = 0.0;
        double SP = 0.0;
        double Fw = 0.0;
        double Fe = 0.0;
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = this.pipe.getNode(0).getVelocityIn().doubleValue();
        this.a[1] = 0.0;
        this.b[1] = 1.0;
        this.c[1] = 0.0;
        this.r[1] = this.pipe.getNode(0).getVelocityIn().doubleValue();
        int i = 2;
        while (i < this.numberOfNodes - 1) {
            Ae = this.pipe.getNode(i).getGeometry().getArea();
            Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
            Amean = this.pipe.getNode(i - 1).getGeometry().getArea();
            meanDiameter = this.pipe.getNode(i - 1).getGeometry().getDiameter();
            meanFrik = this.pipe.getNode(i - 1).getWallFrictionFactor();
            meanDensity = (this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() + this.pipe.getNode(i - 1).getBulkSystem().getPhases()[0].getDensity()) / 2.0;
            oldMeanDensity = (this.oldDensity[i - 1] + this.oldDensity[i]) / 2.0;
            meanVelocity = (this.pipe.getNode(i - 1).getVelocity() + this.pipe.getNode(i).getVelocity()) / 2.0;
            vertposchange = this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode();
            nodeLength = this.pipe.getNode(i - 1).getGeometry().getNodeLength();
            SU = -Amean * (this.pipe.getNode(i).getBulkSystem().getPressure() - this.pipe.getNode(i - 1).getBulkSystem().getPressure()) * 100000.0 - Amean * 9.80665 * meanDensity * vertposchange + Amean * nodeLength * meanDensity * meanFrik / meanDiameter * meanVelocity * Math.abs(meanVelocity) / 2.0;
            SP = -Amean * nodeLength * meanDensity * meanFrik / meanDiameter * meanVelocity;
            Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[0].getDensity() * (this.pipe.getNode(i - 1).getVelocityIn().doubleValue() + this.pipe.getNode(i - 1).getVelocityOut().doubleValue()) / 2.0;
            Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() * (this.pipe.getNode(i).getVelocityIn().doubleValue() + this.pipe.getNode(i).getVelocityOut().doubleValue()) / 2.0;
            this.oldImpuls[i] = this.dynamic ? 1.0 / this.timeStep * oldMeanDensity * nodeLength * Amean : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldImpuls[i];
            this.r[i] = SU + this.oldImpuls[i] * this.oldVelocity[i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
            ++i;
        }
        i = this.numberOfNodes - 1;
        Ae = this.pipe.getNode(i).getGeometry().getArea();
        Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
        Amean = this.pipe.getNode(i - 1).getGeometry().getArea();
        meanDiameter = this.pipe.getNode(i - 1).getGeometry().getDiameter();
        meanFrik = this.pipe.getNode(i - 1).getWallFrictionFactor();
        meanDensity = this.pipe.getNode(i - 1).getBulkSystem().getPhases()[0].getDensity();
        oldMeanDensity = this.oldDensity[i - 1];
        meanVelocity = this.pipe.getNode(i - 1).getVelocity();
        vertposchange = this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode();
        nodeLength = this.pipe.getNode(i - 1).getGeometry().getNodeLength();
        SU = -Amean * (this.pipe.getNode(i).getBulkSystem().getPressure() - this.pipe.getNode(i - 1).getBulkSystem().getPressure()) * 100000.0 - Amean * 9.80665 * meanDensity * vertposchange + Amean * nodeLength * meanDensity * meanFrik / meanDiameter * meanVelocity * Math.abs(meanVelocity) / 2.0;
        SP = -Amean * nodeLength * meanDensity * meanFrik / meanDiameter * meanVelocity;
        Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[0].getDensity() * (this.pipe.getNode(i - 1).getVelocityIn().doubleValue() + this.pipe.getNode(i - 1).getVelocityOut().doubleValue()) / 2.0;
        Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() * (this.pipe.getNode(i).getVelocityIn().doubleValue() + this.pipe.getNode(i).getVelocityOut().doubleValue()) / 2.0;
        this.oldImpuls[i] = this.dynamic ? 1.0 / this.timeStep * oldMeanDensity * nodeLength * Amean : 0.0;
        this.a[i] = Math.max(Fw, 0.0);
        this.c[i] = Math.max(-Fe, 0.0);
        this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldImpuls[i];
        this.r[i] = SU + this.oldImpuls[i] * this.oldVelocity[i];
        this.a[this.numberOfNodes - 1] = -this.a[this.numberOfNodes - 1];
        this.c[this.numberOfNodes - 1] = -this.c[this.numberOfNodes - 1];
    }

    public void setEnergyMatrixTDMA() {
        double SU;
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhases()[0].getEnthalpy() / this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(0).getBulkSystem().getPhases()[0].getMolarMass();
        int i = 1;
        while (i < this.numberOfNodes - 1) {
            double fe = this.pipe.getNode(i + 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i + 1).getGeometry().getNodeLength());
            double fw = this.pipe.getNode(i - 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i - 1).getGeometry().getNodeLength());
            double Ae = this.pipe.getNode(i).getGeometry().getArea();
            double Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
            double vertposchange = (1.0 - fe) * (this.pipe.getNode(i + 1).getVerticalPositionOfNode() - this.pipe.getNode(i).getVerticalPositionOfNode()) + (1.0 - fw) * (this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode());
            SU = -this.pipe.getNode(i).getGeometry().getArea() * 9.80665 * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() * this.pipe.getNode(i).getVelocity() * vertposchange + this.pipe.getNode(i).getGeometry().getArea() * 4.0 * this.pipe.getNode(i).calcTotalHeatTransferCoefficient(0) * (this.pipe.getNode(i).getGeometry().getSurroundingEnvironment().getTemperature() - this.pipe.getNode(i).getBulkSystem().getTemperature()) / this.pipe.getNode(i).getGeometry().getDiameter() * this.pipe.getNode(i).getGeometry().getNodeLength();
            double SP = 0.0;
            double Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[0].getDensity() * this.pipe.getNode(i).getVelocityIn().doubleValue();
            double Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() * this.pipe.getNode(i).getVelocityOut().doubleValue();
            this.oldEnergy[i] = this.dynamic ? 1.0 / this.timeStep * this.oldDensity[i] * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getGeometry().getArea() : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldEnergy[i];
            this.r[i] = SU + this.oldEnergy[i] * this.oldInternalEnergy[i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
            ++i;
        }
        i = this.numberOfNodes - 1;
        double fw = this.pipe.getNode(i - 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i - 1).getGeometry().getNodeLength());
        double Ae = this.pipe.getNode(i).getGeometry().getArea();
        double Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
        double vertposchange = (1.0 - fw) * (this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode());
        SU = -this.pipe.getNode(i).getGeometry().getArea() * 9.80665 * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() * this.pipe.getNode(i).getVelocity() * vertposchange + this.pipe.getNode(i).getGeometry().getArea() * 4.0 * this.pipe.getNode(i).calcTotalHeatTransferCoefficient(0) * (this.pipe.getNode(i).getGeometry().getSurroundingEnvironment().getTemperature() - this.pipe.getNode(i).getBulkSystem().getTemperature()) / this.pipe.getNode(i).getGeometry().getDiameter() * this.pipe.getNode(i).getGeometry().getNodeLength();
        double SP = 0.0;
        double Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[0].getDensity() * this.pipe.getNode(i).getVelocityIn().doubleValue();
        double Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() * this.pipe.getNode(i).getVelocity();
        this.oldEnergy[i] = this.dynamic ? 1.0 / this.timeStep * this.oldDensity[i] * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getGeometry().getArea() : 0.0;
        this.a[i] = Math.max(Fw, 0.0);
        this.c[i] = Math.max(-Fe, 0.0);
        this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldEnergy[i];
        this.r[i] = SU + this.oldEnergy[i] * this.oldInternalEnergy[i];
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void setComponentConservationMatrix(int componentNumber) {
        double Fw;
        double Fe;
        double Aw;
        double Ae;
        double SU = 0.0;
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhases()[0].getComponents()[componentNumber].getx() * this.pipe.getNode(0).getBulkSystem().getPhases()[0].getComponents()[componentNumber].getMolarMass() / this.pipe.getNode(0).getBulkSystem().getPhases()[0].getMolarMass();
        int i = 1;
        while (i < this.numberOfNodes - 1) {
            Ae = this.pipe.getNode(i).getGeometry().getArea();
            Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
            Fe = this.pipe.getNode(i).getVelocityOut().doubleValue() * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() * Ae;
            Fw = this.pipe.getNode(i).getVelocityIn().doubleValue() * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[0].getDensity() * Aw;
            this.oldComp[i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getGeometry().getArea() * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldComp[i];
            this.r[i] = this.oldComp[i] * this.oldComposition[componentNumber][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
            ++i;
        }
        i = this.numberOfNodes - 1;
        Ae = this.pipe.getNode(i).getGeometry().getArea();
        Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
        Fe = this.pipe.getNode(i).getVelocity() * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() * Ae;
        Fw = this.pipe.getNode(i).getVelocityIn().doubleValue() * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[0].getDensity() * Aw;
        this.oldComp[i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getGeometry().getArea() * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity() : 0.0;
        this.a[i] = Math.max(Fw, 0.0);
        this.c[i] = Math.max(-Fe, 0.0);
        this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldComp[i];
        this.r[i] = this.oldComp[i] * this.oldComposition[componentNumber][i];
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void initFinalResults() {
        int i = 0;
        while (i < this.numberOfNodes) {
            this.oldVelocity[i] = this.pipe.getNode(i).getVelocityIn().doubleValue();
            this.oldDensity[i] = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getDensity();
            this.oldInternalEnergy[i] = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass();
            int j = 0;
            while (j < this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfComponents()) {
                this.oldComposition[j][i] = this.sol4Matrix[j].get(i, 0);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void solveTDMA() {
        int iter = 0;
        int iterTop = 0;
        double maxDiff = 1.0;
        double diff = 0.0;
        this.xNew = new double[this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()][this.numberOfNodes];
        if (!this.dynamic) {
            this.initProfiles();
        }
        this.initMatrix();
        do {
            double[] d;
            maxDiff = 0.0;
            ++iterTop;
            iter = 0;
            if (this.solverType >= 0) {
                do {
                    maxDiff = 0.0;
                    do {
                        ++iter;
                        this.setImpulsMatrixTDMA();
                        Matrix solOld = this.solMatrix.copy();
                        d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                        this.solMatrix = new Matrix(d, 1).transpose();
                        this.diffMatrix = this.solMatrix.minus(solOld);
                        this.initVelocity(iter);
                        diff = Math.abs(this.diffMatrix.norm1() / this.solMatrix.norm1());
                        if (!(diff > maxDiff)) continue;
                        maxDiff = diff;
                    } while (diff > 1.0E-15 && iter < 10);
                    if (this.solverType <= 0) continue;
                    iter = 0;
                    do {
                        ++iter;
                        this.setMassConservationMatrixTDMA();
                        d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                        Matrix sol2Old = this.sol2Matrix.copy();
                        this.sol2Matrix = new Matrix(d, 1).transpose();
                        this.diffMatrix = this.sol2Matrix.minus(sol2Old);
                        this.initPressure(iter);
                        diff = Math.abs(this.diffMatrix.norm1() / this.sol2Matrix.norm1());
                        if (!(diff > maxDiff)) continue;
                        maxDiff = diff;
                    } while (diff > 1.0E-15 && iter < 10);
                } while (Math.abs(maxDiff) > 1.0E-10);
            }
            if (this.solverType >= 10) {
                iter = 0;
                do {
                    ++iter;
                    Matrix sol3Old = this.sol3Matrix.copy();
                    this.setEnergyMatrixTDMA();
                    d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                    this.sol3Matrix = new Matrix(d, 1).transpose();
                    this.diffMatrix = this.sol3Matrix.minus(sol3Old);
                    this.initTemperature(iter);
                    diff = Math.abs(this.diffMatrix.norm1() / this.sol3Matrix.norm1());
                    if (!(diff > maxDiff)) continue;
                    maxDiff = diff;
                } while (diff > 1.0E-15 && iter < 10);
            }
            if (this.solverType < 20) continue;
            iter = 0;
            do {
                ++iter;
                int p = 0;
                while (p < this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()) {
                    this.setComponentConservationMatrix(p);
                    Matrix sol4Old = this.sol4Matrix[p].copy();
                    this.xNew[p] = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                    this.sol4Matrix[p] = new Matrix(this.xNew[p], 1).transpose();
                    this.diff4Matrix[p] = this.sol4Matrix[p].minus(sol4Old);
                    diff = Math.abs(this.diff4Matrix[p].norm1() / this.sol4Matrix[p].norm1());
                    if (diff > maxDiff) {
                        maxDiff = diff;
                    }
                    ++p;
                }
                this.initComposition(iter);
            } while (diff > 1.0E-15 && iter < 10);
        } while (Math.abs(maxDiff) > 1.0E-10 && iterTop < 100);
        this.initFinalResults();
    }
}

