/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary.KrishnaStandartFilmModel;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseTwoPhase.interphasePipeFlow.InterphaseDropletFlow;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.TwoPhaseFlowNode;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class BubbleFlowNode
extends TwoPhaseFlowNode {
    private static final long serialVersionUID = 1000L;
    private double averageBubbleDiameter = 0.001;

    public BubbleFlowNode() {
        this.flowNodeType = "bubble";
    }

    public BubbleFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "bubble";
        this.interphaseTransportCoefficient = new InterphaseDropletFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    public BubbleFlowNode(SystemInterface system, SystemInterface interphaseSystem, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "bubble";
        this.interphaseTransportCoefficient = new InterphaseDropletFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    @Override
    public double calcGasLiquidContactArea() {
        this.interphaseContactArea = this.pipe.getNodeLength() * this.interphaseContactLength[0];
        return this.interphaseContactArea;
    }

    @Override
    public void initFlowCalc() {
        this.phaseFraction[0] = this.getBulkSystem().getVolumeFraction(0);
        this.phaseFraction[1] = 1.0 - this.phaseFraction[0];
        this.initVelocity();
        this.init();
        this.initVelocity();
    }

    @Override
    public BubbleFlowNode clone() {
        BubbleFlowNode clonedSystem = null;
        try {
            clonedSystem = (BubbleFlowNode)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        this.inclination = 0.0;
        this.calcContactLength();
        super.init();
    }

    @Override
    public double calcContactLength() {
        double phaseAngel = 3.14159265 * this.phaseFraction[1] + Math.pow(4.7123889750000005, 0.3333333333333333) * (1.0 - 2.0 * this.phaseFraction[1] + Math.pow(this.phaseFraction[1], 0.3333333333333333) - Math.pow(this.phaseFraction[0], 0.3333333333333333));
        this.wallContactLength[1] = phaseAngel * this.pipe.getDiameter();
        this.wallContactLength[0] = 3.14159265 * this.pipe.getDiameter() - this.wallContactLength[1];
        this.interphaseContactLength[0] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        this.interphaseContactLength[1] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        double volumeOfBubble = 4.1887902047863905 * Math.pow(this.averageBubbleDiameter / 2.0, 3.0);
        double surfaceAreaOfBubble = Math.PI * 4 * Math.pow(this.averageBubbleDiameter / 2.0, 2.0);
        double numbDropletsPerTime = this.getBulkSystem().getPhase(0).getVolume("m3") / volumeOfBubble;
        this.interphaseContactLength[0] = numbDropletsPerTime * surfaceAreaOfBubble / this.velocity[0];
        this.interphaseContactLength[1] = this.interphaseContactLength[0];
        return this.wallContactLength[0];
    }

    @Override
    public FlowNodeInterface getNextNode() {
        BubbleFlowNode newNode = this.clone();
        int i = 0;
        while (i < this.getBulkSystem().getPhases()[0].getNumberOfComponents()) {
            ++i;
        }
        return newNode;
    }

    public static void main(String[] args) {
        SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(295.3, 50.01325);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(0.0250203, 2.5E-4);
        testSystem.addComponent("CO2", 100.1061152181, "kg/hr", 0);
        testSystem.addComponent("water", 1000.206862204876, "kg/hr", 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(4);
        testSystem.initPhysicalProperties();
        testSystem.init_x_y();
        testSystem.initBeta();
        testSystem.init(3);
        testSystem.display();
        BubbleFlowNode test = new BubbleFlowNode(testSystem, pipe1);
        test.setInterphaseModelType(1);
        test.setLengthOfNode(1.0E-4);
        test.getGeometry().getSurroundingEnvironment().setTemperature(293.15);
        test.getFluidBoundary().setHeatTransferCalc(false);
        test.getFluidBoundary().setMassTransferCalc(true);
        double length = 0.0;
        test.initFlowCalc();
        double[][] temperatures2 = new double[3][1000];
        int k = 0;
        int i = 0;
        while (i < 10000) {
            length += test.getLengthOfNode();
            test.initFlowCalc();
            test.calcFluxes();
            if (i > 1 && i % 100 == 0) {
                test.display("length " + length);
                test.getBulkSystem().display("length " + length);
                temperatures2[0][++k] = length;
                temperatures2[1][k] = test.getGeometry().getInnerWallTemperature();
            }
            test.update();
            ++i;
        }
        i = 0;
        while (i < k) {
            System.out.println("len temp  " + temperatures2[0][i] + " " + temperatures2[1][i]);
            ++i;
        }
        System.out.println("contact length " + test.getInterphaseContactArea());
    }

    public double getAverageBubbleDiameter() {
        return this.averageBubbleDiameter;
    }

    public void setAverageBubbleDiameter(double averageBubbleDiameter) {
        this.averageBubbleDiameter = averageBubbleDiameter;
    }
}

