/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary;

import Jama.Matrix;
import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.NonEquilibriumFluidBoundary;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode.AnnularFlow;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class KrishnaStandartFilmModel
extends NonEquilibriumFluidBoundary
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    Matrix phiMatrix;
    Matrix redPhiMatrix;
    Matrix redCorrectionMatrix;
    Matrix betaMatrix;

    public KrishnaStandartFilmModel() {
    }

    public KrishnaStandartFilmModel(SystemInterface system) {
        super(system);
        this.binaryMassTransferCoefficient = new double[2][this.getBulkSystem().getPhases()[0].getNumberOfComponents()][this.getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.binarySchmidtNumber = new double[2][this.getBulkSystem().getPhases()[0].getNumberOfComponents()][this.getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.uMassTrans = new Matrix(this.neq, 1);
        this.Xgij = new Matrix(this.neq, 4);
        this.setuMassTrans();
        this.uMassTransold = this.uMassTrans.copy();
    }

    public KrishnaStandartFilmModel(FlowNodeInterface flowNode) {
        super(flowNode);
        this.binaryMassTransferCoefficient = new double[2][this.getBulkSystem().getPhases()[0].getNumberOfComponents()][this.getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.binarySchmidtNumber = new double[2][this.getBulkSystem().getPhases()[0].getNumberOfComponents()][this.getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.uMassTrans = new Matrix(this.neq, 1);
        this.Xgij = new Matrix(this.neq, 4);
        this.setuMassTrans();
        this.uMassTransold = this.uMassTrans.copy();
        this.phiMatrix = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1);
        this.redCorrectionMatrix = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, 1);
    }

    @Override
    public KrishnaStandartFilmModel clone() {
        KrishnaStandartFilmModel clonedSystem = null;
        try {
            clonedSystem = (KrishnaStandartFilmModel)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    public double calcBinarySchmidtNumbers(int phase) {
        int i = 0;
        while (i < this.getBulkSystem().getPhases()[phase].getNumberOfComponents()) {
            int j = 0;
            while (j < this.getBulkSystem().getPhases()[phase].getNumberOfComponents()) {
                this.binarySchmidtNumber[phase][i][j] = this.getBulkSystem().getPhases()[phase].getPhysicalProperties().getKinematicViscosity() / this.getBulkSystem().getPhases()[phase].getPhysicalProperties().getDiffusionCoefficient(i, j);
                ++j;
            }
            ++i;
        }
        return 1.0;
    }

    public double calcBinaryMassTransferCoefficients(int phase) {
        int i = 0;
        while (i < this.getBulkSystem().getPhases()[phase].getNumberOfComponents()) {
            int j = 0;
            while (j < this.getBulkSystem().getPhases()[phase].getNumberOfComponents()) {
                this.binaryMassTransferCoefficient[phase][i][j] = this.flowNode.getInterphaseTransportCoefficient().calcInterphaseMassTransferCoefficient(phase, this.binarySchmidtNumber[phase][i][j], this.flowNode);
                ++j;
            }
            ++i;
        }
        return 1.0;
    }

    public double calcMassTransferCoefficients(int phase) {
        int n = this.getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1;
        int i = 0;
        while (i < this.getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1) {
            double tempVar = 0.0;
            int j = 0;
            while (j < this.getBulkSystem().getPhases()[phase].getNumberOfComponents()) {
                if (i != j) {
                    tempVar += this.getBulkSystem().getPhases()[phase].getComponents()[j].getx() / this.binaryMassTransferCoefficient[phase][i][j];
                }
                if (j < n) {
                    this.massTransferCoefficientMatrix[phase].set(i, j, -this.getBulkSystem().getPhases()[phase].getComponents()[i].getx() * (1.0 / this.binaryMassTransferCoefficient[phase][i][j] - 1.0 / this.binaryMassTransferCoefficient[phase][i][n]));
                }
                ++j;
            }
            this.massTransferCoefficientMatrix[phase].set(i, i, tempVar + this.getBulkSystem().getPhases()[phase].getComponents()[i].getx() / this.binaryMassTransferCoefficient[phase][i][n]);
            ++i;
        }
        this.massTransferCoefficientMatrix[phase] = this.massTransferCoefficientMatrix[phase].inverse();
        return 1.0;
    }

    public void calcPhiMatrix(int phase) {
        int n = this.getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1;
        int i = 0;
        while (i < this.getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1) {
            double tempVar = 0.0;
            int j = 0;
            while (j < this.getBulkSystem().getPhases()[phase].getNumberOfComponents()) {
                if (i != j || i == n) {
                    tempVar += this.nFlux.get(i, 0) / (1.0 / (this.getBulkSystem().getPhases()[phase].getMolarVolume() * 1.0E-5) * this.binaryMassTransferCoefficient[phase][i][j]);
                }
                if (j < n) {
                    this.phiMatrix.set(i, j, -this.nFlux.get(i, 0) * (1.0 / (1.0 / (this.getBulkSystem().getPhases()[phase].getMolarVolume() * 1.0E-5) * this.binaryMassTransferCoefficient[phase][i][j]) - 1.0 / (1.0 / (this.getBulkSystem().getPhases()[phase].getMolarVolume() * 1.0E-5) * this.binaryMassTransferCoefficient[phase][i][n])));
                }
                ++j;
            }
            this.phiMatrix.set(i, i, tempVar + this.nFlux.get(i, 0) / (1.0 / (this.getBulkSystem().getPhases()[phase].getMolarVolume() * 1.0E-5) * this.binaryMassTransferCoefficient[phase][i][n]));
            ++i;
        }
    }

    public void calcRedPhiMatrix(int phase) {
        this.redPhiMatrix = new Matrix(this.phiMatrix.eig().getRealEigenvalues(), 1);
    }

    public void calcRedCorrectionMatrix(int phase) {
        int i = 0;
        while (i < this.getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1) {
            this.redCorrectionMatrix.set(i, 0, this.redPhiMatrix.get(0, i) * Math.exp(this.redPhiMatrix.get(0, i)) / (Math.exp(this.redPhiMatrix.get(0, i)) - 0.999999999999999));
            ++i;
        }
    }

    public void calcCorrectionMatrix(int phase) {
        Matrix modalPhiMatrix = this.phiMatrix.eig().getV();
        Matrix diagonalRedCorrectionMatrix = new Matrix(this.getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1);
        int i = 0;
        while (i < this.getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1) {
            diagonalRedCorrectionMatrix.set(i, i, this.redCorrectionMatrix.get(i, 0));
            ++i;
        }
        this.rateCorrectionMatrix[phase] = modalPhiMatrix.times(diagonalRedCorrectionMatrix.times(modalPhiMatrix.inverse()));
    }

    public void calcTotalMassTransferCoefficientMatrix(int phase) {
        this.totalMassTransferCoefficientMatrix[phase] = this.massTransferCoefficientMatrix[phase];
        this.totalMassTransferCoefficientMatrix[phase] = Math.abs(this.totalFlux) > 1.0E-30 ? (this.useFiniteFluxCorrection(phase) && this.useThermodynamicCorrections(phase) ? this.rateCorrectionMatrix[phase].times(this.nonIdealCorrections[phase].times(this.massTransferCoefficientMatrix[phase])) : (this.useFiniteFluxCorrection(phase) ? this.rateCorrectionMatrix[phase].times(this.massTransferCoefficientMatrix[phase]) : (this.useThermodynamicCorrections(phase) ? this.massTransferCoefficientMatrix[phase].times(this.nonIdealCorrections[phase]) : this.massTransferCoefficientMatrix[phase]))) : this.massTransferCoefficientMatrix[phase];
    }

    public void initCorrections(int phase) {
        this.calcPhiMatrix(phase);
        this.calcRedPhiMatrix(phase);
        this.calcRedCorrectionMatrix(phase);
        this.calcCorrectionMatrix(phase);
    }

    @Override
    public void initMassTransferCalc() {
        super.initMassTransferCalc();
        int phase = 0;
        while (phase < 2) {
            this.calcBinarySchmidtNumbers(phase);
            this.calcBinaryMassTransferCoefficients(phase);
            this.calcMassTransferCoefficients(phase);
            this.initCorrections(phase);
            this.calcNonIdealCorrections(phase);
            this.calcTotalMassTransferCoefficientMatrix(phase);
            ++phase;
        }
    }

    @Override
    public void initHeatTransferCalc() {
        super.initHeatTransferCalc();
        int phase = 0;
        while (phase < 2) {
            this.calcHeatTransferCoefficients(phase);
            this.calcHeatTransferCorrection(phase);
            ++phase;
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.massTransferCalc) {
            this.initMassTransferCalc();
        }
        if (this.heatTransferCalc) {
            this.initHeatTransferCalc();
        }
    }

    @Override
    public void solve() {
        super.solve();
    }

    public static void main(String[] args) {
        System.out.println("Starter.....");
        SystemSrkEos testSystem = new SystemSrkEos(295.3, 3.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(0.1, 0.025);
        testSystem.addComponent("methane", 0.0071152181, 0);
        testSystem.addComponent("ethane", 0.0071152181, 0);
        testSystem.addComponent("water", 0.00362204876, 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        testSystem.initPhysicalProperties();
        AnnularFlow test = new AnnularFlow(testSystem, pipe1);
        test.initFlowCalc();
        test.init();
        KrishnaStandartFilmModel test2 = new KrishnaStandartFilmModel(test);
        test2.solve();
        test2.calcFluxes();
        test2.getInterphaseSystem().display();
        test2.display("");
    }
}

