/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc;

import Jama.Matrix;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.dataPresentation.fileHandeling.createTextFile.TextFile;
import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.FluidBoundaryInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary.reactiveFilmModel.enhancementFactor.EnhancementFactor;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FluidBoundary
implements FluidBoundaryInterface,
Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(FluidBoundary.class);
    protected FlowNodeInterface flowNode;
    protected SystemInterface bulkSystem;
    protected SystemInterface interphaseSystem;
    protected ThermodynamicOperations interphaseOps;
    protected ThermodynamicOperations bulkSystemOps;
    public double[] interphaseHeatFlux = new double[2];
    public boolean massTransferCalc = true;
    public boolean heatTransferCalc = false;
    public boolean[] thermodynamicCorrections;
    public boolean[] finiteFluxCorrection;
    protected boolean numeric = false;
    protected Matrix jFlux;
    protected Matrix nFlux;
    protected EnhancementFactor enhancementFactor;
    protected double totalFlux = 0.0;
    protected Matrix[] nonIdealCorrections;
    protected Matrix[] fluxTypeCorrectionMatrix;
    protected Matrix[] rateCorrectionMatrix;
    protected Matrix[] fluxTypeCorrectionMatrixV;
    protected Matrix[] totalMassTransferCoefficientMatrix;
    protected Matrix[] massTransferCoefficientMatrix;
    protected double[][][] binarySchmidtNumber;
    public double[][][] binaryMassTransferCoefficient;
    public double[] heatTransferCoefficient;
    public double[] heatTransferCorrection;
    protected double[] prandtlNumber;
    protected int solverType = 0;

    public FluidBoundary() {
    }

    public FluidBoundary(SystemInterface system) {
        this.bulkSystem = system;
        this.bulkSystemOps = new ThermodynamicOperations(this.bulkSystem);
        this.nonIdealCorrections = new Matrix[2];
        this.fluxTypeCorrectionMatrix = new Matrix[2];
        this.fluxTypeCorrectionMatrixV = new Matrix[2];
        this.rateCorrectionMatrix = new Matrix[2];
        this.totalMassTransferCoefficientMatrix = new Matrix[2];
        this.massTransferCoefficientMatrix = new Matrix[2];
        this.jFlux = new Matrix(system.getPhases()[0].getNumberOfComponents() - 1, 1);
        this.nFlux = new Matrix(system.getPhases()[0].getNumberOfComponents(), 1);
        this.nFlux.set(0, 0, 0.0);
        this.nFlux.set(1, 0, 0.0);
        this.heatTransferCoefficient = new double[2];
        this.heatTransferCorrection = new double[2];
        this.thermodynamicCorrections = new boolean[2];
        this.finiteFluxCorrection = new boolean[2];
        this.prandtlNumber = new double[2];
        this.initInterphaseSystem();
    }

    public void initInterphaseSystem() {
        this.interphaseSystem = this.bulkSystem.clone();
        this.interphaseSystem.setNumberOfPhases(2);
        this.interphaseSystem.initBeta();
        this.interphaseSystem.setTemperature((this.bulkSystem.getPhase(0).getTemperature() + this.bulkSystem.getPhase(1).getTemperature()) / 2.0);
        this.interphaseSystem.calc_x_y();
        this.interphaseSystem.init(3);
        ThermodynamicOperations interphaseOps = new ThermodynamicOperations(this.interphaseSystem);
        interphaseOps.TPflash();
    }

    public FluidBoundary(FlowNodeInterface flowNode) {
        this(flowNode.getBulkSystem());
        this.flowNode = flowNode;
    }

    @Override
    public FluidBoundary clone() {
        FluidBoundary clonedSystem = null;
        try {
            clonedSystem = (FluidBoundary)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        clonedSystem.interphaseSystem = this.interphaseSystem.clone();
        clonedSystem.nFlux = (Matrix)this.nFlux.clone();
        return clonedSystem;
    }

    public void setSolverType(int type) {
        this.solverType = type;
    }

    public void initMassTransferCalc() {
    }

    public void initHeatTransferCalc() {
    }

    public void init() {
        this.interphaseSystem.init(3);
    }

    @Override
    public SystemInterface getBulkSystem() {
        return this.bulkSystem;
    }

    public void setBulkSystem(SystemInterface bulkSystem) {
        this.bulkSystem = bulkSystem;
    }

    @Override
    public SystemInterface getInterphaseSystem() {
        return this.interphaseSystem;
    }

    @Override
    public void setInterphaseSystem(SystemInterface interphaseSystem) {
        this.interphaseSystem = interphaseSystem;
    }

    public ThermodynamicOperations getInterphaseOpertions() {
        return this.interphaseOps;
    }

    @Override
    public ThermodynamicOperations getBulkSystemOpertions() {
        return this.bulkSystemOps;
    }

    public void calcFluxTypeCorrectionMatrix(int phase, int k) {
        this.fluxTypeCorrectionMatrixV[phase] = new Matrix(this.bulkSystem.getPhases()[phase].getNumberOfComponents(), 1);
        this.fluxTypeCorrectionMatrix[phase] = new Matrix(this.bulkSystem.getPhases()[phase].getNumberOfComponents() - 1, 1);
        double temp = 0.0;
        double sum = 0.0;
        int i = 0;
        while (i < this.bulkSystem.getPhases()[phase].getNumberOfComponents() - 1) {
            temp = i == k ? 1.0 : 0.0;
            this.fluxTypeCorrectionMatrixV[phase].set(i, 0, temp);
            sum += this.fluxTypeCorrectionMatrixV[phase].get(i, 0) * this.bulkSystem.getPhases()[phase].getComponents()[i].getx();
            ++i;
        }
        sum += this.fluxTypeCorrectionMatrixV[phase].get(this.bulkSystem.getPhases()[phase].getNumberOfComponents() - 1, 0) * this.bulkSystem.getPhases()[phase].getComponents()[this.bulkSystem.getPhases()[phase].getNumberOfComponents() - 1].getx();
        i = 0;
        while (i < this.bulkSystem.getPhases()[phase].getNumberOfComponents() - 1) {
            this.fluxTypeCorrectionMatrix[phase].set(i, 0, (this.fluxTypeCorrectionMatrixV[phase].get(i, 0) - this.fluxTypeCorrectionMatrixV[phase].get(this.bulkSystem.getPhases()[phase].getNumberOfComponents() - 1, 0)) / sum);
            ++i;
        }
    }

    public void calcNonIdealCorrections(int phase) {
        this.nonIdealCorrections[phase] = new Matrix(this.bulkSystem.getPhases()[phase].getNumberOfComponents() - 1, this.bulkSystem.getPhases()[phase].getNumberOfComponents() - 1);
        double temp = 0.0;
        int i = 0;
        while (i < this.bulkSystem.getPhases()[phase].getNumberOfComponents() - 1) {
            int j = 0;
            while (j < this.bulkSystem.getPhases()[phase].getNumberOfComponents() - 1) {
                temp = i == j ? 1.0 : 0.0;
                this.nonIdealCorrections[phase].set(i, j, temp + this.bulkSystem.getPhases()[phase].getComponents()[i].getx() * this.bulkSystem.getPhases()[phase].getComponents()[i].getdfugdn(j) * this.bulkSystem.getPhases()[phase].getNumberOfMolesInPhase());
                ++j;
            }
            ++i;
        }
    }

    @Override
    public double getInterphaseMolarFlux(int component) {
        return this.nFlux.get(component, 0);
    }

    @Override
    public double getInterphaseHeatFlux(int phase) {
        return this.interphaseHeatFlux[phase];
    }

    @Override
    public void massTransSolve() {
    }

    @Override
    public void heatTransSolve() {
    }

    @Override
    public Matrix[] getMassTransferCoefficientMatrix() {
        return this.massTransferCoefficientMatrix;
    }

    @Override
    public double getBinaryMassTransferCoefficient(int phase, int i, int j) {
        return this.binaryMassTransferCoefficient[phase][i][j];
    }

    @Override
    public double getEffectiveMassTransferCoefficient(int phase, int i) {
        double temp = 0.0;
        int j = 0;
        while (j < this.bulkSystem.getPhase(phase).getNumberOfComponents()) {
            try {
                temp += this.bulkSystem.getPhase(phase).getComponent(j).getx() * this.binaryMassTransferCoefficient[phase][i][j];
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
            ++j;
        }
        return temp;
    }

    @Override
    public EnhancementFactor getEnhancementFactor() {
        return this.enhancementFactor;
    }

    @Override
    public void setEnhancementType(int type) {
    }

    @Override
    public boolean isHeatTransferCalc() {
        return this.heatTransferCalc;
    }

    @Override
    public void setHeatTransferCalc(boolean heatTransferCalc) {
        this.heatTransferCalc = heatTransferCalc;
    }

    @Override
    public void setMassTransferCalc(boolean massTransferCalc) {
        this.massTransferCalc = massTransferCalc;
    }

    @Override
    public boolean useThermodynamicCorrections(int phase) {
        return this.thermodynamicCorrections[phase];
    }

    @Override
    public void useThermodynamicCorrections(boolean thermodynamicCorrections) {
        this.thermodynamicCorrections[0] = thermodynamicCorrections;
        this.thermodynamicCorrections[1] = thermodynamicCorrections;
    }

    @Override
    public void useThermodynamicCorrections(boolean thermodynamicCorrections, int phase) {
        this.thermodynamicCorrections[phase] = thermodynamicCorrections;
    }

    @Override
    public boolean useFiniteFluxCorrection(int phase) {
        return this.finiteFluxCorrection[phase];
    }

    @Override
    public void useFiniteFluxCorrection(boolean finiteFluxCorrection) {
        this.finiteFluxCorrection[0] = finiteFluxCorrection;
        this.finiteFluxCorrection[1] = finiteFluxCorrection;
    }

    @Override
    public void useFiniteFluxCorrection(boolean finiteFluxCorrection, int phase) {
        this.finiteFluxCorrection[phase] = finiteFluxCorrection;
    }

    public String[][] createTable(String name) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        String[][] table = new String[this.bulkSystem.getPhases()[0].getNumberOfComponents() * 10][5];
        table[0][0] = "";
        table[0][1] = "";
        table[0][2] = "";
        table[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test = new FieldPosition(0);
        int i = 0;
        while (i < this.bulkSystem.getNumberOfPhases()) {
            int j = 0;
            while (j < this.bulkSystem.getPhases()[0].getNumberOfComponents()) {
                table[j + 1][0] = "eff. mass trans coef. " + this.bulkSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i + 1] = nf.format(this.getEffectiveMassTransferCoefficient(i, j), buf, test).toString();
                table[j + 1][4] = "[-] bulkcoef";
                ++j;
            }
            if (this.getBulkSystem().isChemicalSystem()) {
                this.getEnhancementFactor().calcEnhancementVec(i);
                j = 0;
                while (j < this.bulkSystem.getPhases()[0].getNumberOfComponents()) {
                    table[j + this.bulkSystem.getPhases()[0].getNumberOfComponents() + 2][0] = "enhancement " + this.getInterphaseSystem().getPhases()[0].getComponents()[j].getName();
                    buf = new StringBuffer();
                    table[j + this.bulkSystem.getPhases()[0].getNumberOfComponents() + 2][i + 1] = nf.format(this.getEnhancementFactor().getEnhancementVec(j), buf, test).toString();
                    table[j + this.bulkSystem.getPhases()[0].getNumberOfComponents() + 2][4] = "[-] interfacecoef";
                    ++j;
                }
            }
            this.getBulkSystem().getPhase(i).getPhysicalProperties().calcEffectiveDiffusionCoefficients();
            j = 0;
            while (j < this.bulkSystem.getPhases()[0].getNumberOfComponents()) {
                table[j + 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 3][0] = "schmidt " + this.bulkSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 3][i + 1] = nf.format(this.getBulkSystem().getPhase(i).getPhysicalProperties().getEffectiveSchmidtNumber(j), buf, test).toString();
                table[j + 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 3][4] = "[-] fluidboundarycoef";
                ++j;
            }
            buf = new StringBuffer();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 11][0] = "Node";
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 11][i + 1] = name;
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 11][4] = "-";
            ++i;
        }
        return table;
    }

    @Override
    public void display(String name) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        JDialog dialog = new JDialog((Frame)new JFrame(), "Node-Report");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setSize(screenDimension.width / 2, screenDimension.height / 2);
        Object[] names = new String[]{"", "Phase 1", "Phase 2", "Phase 3", "Unit"};
        Object[][] table = this.createTable(name);
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        Jtab.setRowHeight(dialog.getHeight() / table.length);
        Jtab.setFont(new Font("Serif", 0, dialog.getHeight() / table.length - dialog.getHeight() / table.length / 10));
        dialog.setVisible(true);
    }

    @Override
    public void write(String name, String filename, boolean newfile) {
        String[][] table = this.createTable(name);
        TextFile file = new TextFile();
        if (newfile) {
            file.newFile(filename);
        }
        file.setOutputFileName(filename);
        file.setValues(table);
        file.createFile();
        this.getBulkSystem().write(name, filename, false);
    }
}

